/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public final class ScDataHandleVerifyPlugin
extends AbstractOpBizRuleParameterEdit {
    private static final String SC_DATA_HANDLE_KEY = "scdatahandlekey";
    private static final String SC_VERIFY_HANDLE_KEY = "verifyhandlekey";
    private static final String EXECUTESCENE = "executescene";
    private static final String CHECKSCENE = "checkscene";

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        this.initDataHandleKeys();
        this.initVerifyDataHandleKeys();
        this.initExecuteSceneValues();
        this.initCheckSceneValues();
    }

    private void initExecuteSceneValues() {
        ComboEdit executeScene = (ComboEdit)this.getControl(EXECUTESCENE);
        if (executeScene != null) {
            executeScene.setComboItems(this.assembleSceneValues(true));
        }
    }

    private void initCheckSceneValues() {
        ComboEdit checkScene = (ComboEdit)this.getControl(CHECKSCENE);
        if (checkScene != null) {
            checkScene.setComboItems(this.assembleSceneValues(false));
        }
    }

    private List<ComboItem> assembleSceneValues(Boolean filterEntity) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
        QFilter qFilter = QFilter.isNotNull((String)"id");
        if (filterEntity.booleanValue()) {
            qFilter.and(new QFilter("entity", "=", (Object)this.getEntityNumber()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.scm.plugin.ScDataHandleVerifyPlugin", (String)"pbd_scenedefine", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            ComboItem datahandlekey = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                datahandlekey = new ComboItem(new LocaleString(name + "(" + number + ")"), id);
                comboItems.add(datahandlekey);
            }
        }
        return comboItems;
    }

    private void initVerifyDataHandleKeys() {
        ComboEdit verifyhandlekey = (ComboEdit)this.getControl(SC_VERIFY_HANDLE_KEY);
        if (verifyhandlekey != null) {
            verifyhandlekey.setComboItems(this.assembleHandleKeys(false));
        }
    }

    private void initDataHandleKeys() {
        ComboEdit datahandlekey = (ComboEdit)this.getControl(SC_DATA_HANDLE_KEY);
        if (datahandlekey != null) {
            datahandlekey.setComboItems(this.assembleHandleKeys(true));
        }
    }

    private List<ComboItem> assembleHandleKeys(Boolean filterEntity) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (filterEntity.booleanValue()) {
            qFilter.and(new QFilter("entity", "=", (Object)this.getEntityNumber()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.scm.plugin.ScDataHandleVerifyPlugin", (String)"pbd_scdatahandle", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            ComboItem datahandlekey = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                datahandlekey = new ComboItem(new LocaleString(name + "(" + number + ")"), id);
                comboItems.add(datahandlekey);
            }
        }
        return comboItems;
    }

    public String getParameter() {
        HashMap<String, String> param = new HashMap<String, String>(2);
        if (this.getModel().getProperty(EXECUTESCENE) != null) {
            String executeScene = (String)this.getModel().getValue(EXECUTESCENE);
            param.put(EXECUTESCENE, executeScene);
        }
        if (this.getModel().getProperty(CHECKSCENE) != null) {
            String checkScene = (String)this.getModel().getValue(CHECKSCENE);
            param.put(CHECKSCENE, checkScene);
        }
        if (this.getModel().getProperty(SC_DATA_HANDLE_KEY) != null) {
            String scdatahandlekey = (String)this.getModel().getValue(SC_DATA_HANDLE_KEY);
            param.put(SC_DATA_HANDLE_KEY, scdatahandlekey);
        }
        if (this.getModel().getProperty(SC_VERIFY_HANDLE_KEY) != null) {
            String scverifydatahandlekey = (String)this.getModel().getValue(SC_VERIFY_HANDLE_KEY);
            param.put(SC_VERIFY_HANDLE_KEY, scverifydatahandlekey);
        }
        return SerializationUtils.toJsonString(param);
    }

    public boolean checkParameter() {
        boolean verify = true;
        String executeScene = (String)this.getModel().getValue(EXECUTESCENE);
        String checkScene = (String)this.getModel().getValue(CHECKSCENE);
        StringBuilder verifyMessage = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)executeScene)) {
            verifyMessage.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6570\u636e\u5904\u7406\u6807\u8bc6\u3002", (String)"ScDataHandleVerifyPlugin_0", (String)"bos-ext-scm", (Object[])new Object[0])).append("\t\n");
            verify = false;
        }
        if (StringUtils.isBlank((CharSequence)checkScene)) {
            verifyMessage.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6821\u9a8c\u5904\u7406\u64cd\u4f5c\u3002", (String)"ScDataHandleVerifyPlugin_1", (String)"bos-ext-scm", (Object[])new Object[0])).append("\t\n");
            verify = false;
        }
        if (!verify) {
            this.getView().showTipNotification(verifyMessage.toString());
        }
        return verify;
    }
}

