/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ScmMenuHideExtPlugin
implements IPortalAppMenuExtService {
    public static final String SRM_APPID = "XV1IC150UR4";

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(8);
        Set<String> srmHideenuIds = this.getSrmHideMenuIds(appIdAndMenuIdMap);
        result.put(SRM_APPID, srmHideenuIds);
        return result;
    }

    private Set<String> getSrmHideMenuIds(Map<String, Set<String>> appIdAndMenuIdMap) {
        Set<Object> hideMenuIds = new HashSet<String>(16);
        Set<String> allHidMenuIds = appIdAndMenuIdMap.get(SRM_APPID);
        if (allHidMenuIds != null && allHidMenuIds.isEmpty()) {
            hideMenuIds = allHidMenuIds;
        }
        if (this.isEnableSupplieSrmVersion()) {
            hideMenuIds.add("1061567079267937280");
            hideMenuIds.add("1057073067617987584");
        } else {
            hideMenuIds.add("2169580483111939072");
            hideMenuIds.add("2169572176468904960");
        }
        if (!this.isExistPurEvaPlan()) {
            hideMenuIds.add("1509315226884017152");
            hideMenuIds.add("1509315765424386048");
        }
        if (this.isGroupManager()) {
            hideMenuIds.add("2005725596553853952");
        }
        return hideMenuIds;
    }

    private boolean isEnableSupplieSrmVersion() {
        QFilter qFilter = new QFilter("paramkey", "=", (Object)"enablenewsrmversion");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])qFilter.toArray());
        return dyn != null && "Y".equals(dyn.getString("paramvalue"));
    }

    private boolean isExistPurEvaPlan() {
        String srmEvaplan = MetadataDao.getIdByNumber((String)"srm_evaplan", (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isEmpty((CharSequence)srmEvaplan)) {
            return false;
        }
        return QueryServiceHelper.exists((String)"srm_evaplan", null);
    }

    private boolean isGroupManager() {
        Object val;
        AppParam appParam = new AppParam();
        appParam.setViewType("15");
        appParam.setAppId(SRM_APPID);
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Map sysParaMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        String paramVal = "";
        if (null != sysParaMap && null != (val = sysParaMap.get("supmanagerparam"))) {
            paramVal = val.toString();
        }
        return paramVal == null || StringUtils.isBlank((CharSequence)paramVal) || "A".equals(paramVal);
    }
}

