/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fcs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.helper.SuspectRepeatHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;

public class SuspectRepeatCtrlAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(SuspectRepeatCtrlAction.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block8: {
                    try {
                        logger.info("\u5f00\u59cb\u7591\u4f3c\u9632\u91cd\u63a7\u5236\u670d\u52a1");
                        Set<Long> idSet = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getLong("id")).collect(Collectors.toSet());
                        String operateKey = this.getOperateKey();
                        Map<Object, Object> controlMap = SuspectRepeatHelper.getControlMessageInfo(idSet);
                        if (!controlMap.isEmpty()) {
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                DynamicObject bill = dataEntity.getDataEntity();
                                Long pkId = bill.getLong("id");
                                String controlMessage = controlMap.getOrDefault(pkId, null);
                                List controlList = (List)controlMap.get("operateKey");
                                if (controlMessage == null || controlList == null || !controlList.contains(operateKey)) continue;
                                logger.info("\u4e25\u63a7\u63d0\u793a\u4fe1\u606f\uff1a" + controlMessage);
                                this.addErrorMessage(dataEntity, controlMessage);
                            }
                        }
                        String isCheck = (String)this.getOption().getVariables().get("isCheck");
                        logger.info("isCheck:[" + isCheck + "]");
                        if (isCheck == null) {
                            Map<Object, Object> landingMap = SuspectRepeatHelper.getLandingMessageInfo(idSet);
                            if (!landingMap.isEmpty()) {
                                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                    DynamicObject bill = dataEntity.getDataEntity();
                                    Long pkId = bill.getLong("id");
                                    String landingMessage = landingMap.getOrDefault(pkId, null);
                                    List landingList = (List)landingMap.get("operateKey");
                                    if (landingMessage == null || landingList == null || !landingList.contains(operateKey)) continue;
                                    logger.info("\u843d\u5730\u63d0\u793a\u4fe1\u606f\uff1a" + landingMessage);
                                    this.addErrorMessage(dataEntity, landingMessage);
                                }
                            }
                        } else {
                            this.showNoConfirmDataMessage(this.dataEntities);
                        }
                        logger.info("\u7ed3\u675f\u7591\u4f3c\u9632\u91cd\u63a7\u5236\u670d\u52a1");
                    }
                    catch (Exception ex) {
                        logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                        if (!(ex instanceof KDBizException)) break block8;
                        throw ex;
                    }
                }
            }

            private void showNoConfirmDataMessage(ExtendedDataEntity[] dataEntities) {
                String strNoConfirmIds = (String)this.getOption().getVariables().get("notConfirmBilllIds");
                if (strNoConfirmIds != null) {
                    List notConfirmBilllIds = (List)SerializationUtils.fromJsonString((String)strNoConfirmIds, List.class);
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject bill = dataEntity.getDataEntity();
                        if (!notConfirmBilllIds.contains(bill.getLong("id"))) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u672a\u8fdb\u884c\u786e\u8ba4\u3002", (String)"SuspectRepeatCtrlAction_1", (String)"bos-ext-tmc", (Object[])new Object[0]));
                    }
                }
            }
        });
    }
}

