/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.utils.DateUtil;
import kd.bos.ext.tmc.utils.helper.ScheduleCacheHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ScheduleProposalExecInfo
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(ScheduleProposalExecInfo.class);
    private long schemaId;
    private ScheduleExecuteStatus executeStatus;
    private boolean isProgress;
    private int percent;
    private int operTC;
    private int operTCC;
    private int recordTC;
    private int recordTSC;
    private int recordTFC;
    private String execDetails;
    private ScheduleExceOperInfo exceOperInfo;
    private Date lastUpdateDate;

    public ScheduleProposalExecInfo() {
    }

    public ScheduleProposalExecInfo(long schemaId) {
        this.schemaId = schemaId;
        this.isProgress = false;
        this.lastUpdateDate = new Date();
    }

    public static ScheduleProposalExecInfo getInstance(long schemaId) {
        String intellExecInfoStr = ScheduleCacheHelper.getDistributeCache().get(ScheduleProposalExecInfo.getCacheKey(schemaId));
        if (Objects.isNull(intellExecInfoStr)) {
            return null;
        }
        try {
            ScheduleProposalExecInfo intelSchemelExecInfo = (ScheduleProposalExecInfo)SerializationUtils.fromJsonString((String)intellExecInfoStr, ScheduleProposalExecInfo.class);
            if (DateUtil.isSameDay(intelSchemelExecInfo.getLastUpdateDate(), new Date())) {
                return intelSchemelExecInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
        return null;
    }

    public static void execInfoWriteCache(ScheduleProposalExecInfo schemeInfo) {
        String executeDetails;
        ScheduleExceOperInfo exceOperInfo = schemeInfo.getExceOperInfo();
        if (exceOperInfo.getOperRTC() == 0) {
            executeDetails = String.format(ResManager.loadKDString((String)"\u51c6\u5907\u6267\u884c\u201c%1$s\u201d\u64cd\u4f5c\uff0c\u6570\u636e\u51c6\u5907\u4e2d\u3002", (String)"ScheduleProposalExecInfo_1", (String)"bos-ext-tmc", (Object[])new Object[0]), exceOperInfo.getOperName());
        } else {
            int totalCount = Math.max(exceOperInfo.getOperRTC(), exceOperInfo.getOperRTSC() + exceOperInfo.getOperRTFC());
            executeDetails = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u201c%1$s\u201d\u64cd\u4f5c\uff0c\u5171\u83b7\u53d6%2$s\u6761\u6570\u636e\uff0c\u76ee\u524d\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761\u3002", (String)"ScheduleProposalExecInfo_2", (String)"bos-ext-tmc", (Object[])new Object[0]), exceOperInfo.getOperName(), totalCount, exceOperInfo.getOperRTSC(), exceOperInfo.getOperRTFC());
        }
        schemeInfo.setExecDetails(executeDetails);
        if (schemeInfo.getSchemaId() > 0L) {
            try {
                ScheduleCacheHelper.getDistributeCache().put(ScheduleProposalExecInfo.getCacheKey(schemeInfo.getSchemaId()), SerializationUtils.toJsonString((Object)schemeInfo));
            }
            catch (Exception e) {
                LOGGER.info("schemeInfo: {}", (Object)schemeInfo);
                LOGGER.error((Throwable)e);
            }
        }
    }

    public static void removeScheduleExecInfo(long schemaId) {
        ScheduleCacheHelper.getDistributeCache().remove(ScheduleProposalExecInfo.getCacheKey(schemaId));
    }

    public static String getCacheKey(long schemaId) {
        return "iep_intell_" + schemaId;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public ScheduleExecuteStatus getExecuteStatus() {
        return this.executeStatus;
    }

    public void setExecuteStatus(ScheduleExecuteStatus executeStatus) {
        if (ScheduleExecuteStatus.STOP == executeStatus) {
            this.executeStatus = executeStatus;
            return;
        }
        if (ScheduleExecuteStatus.PROCESSING == this.executeStatus) {
            this.executeStatus = executeStatus;
            return;
        }
        this.executeStatus = executeStatus;
    }

    public boolean isProgress() {
        return this.isProgress;
    }

    public void setProgress(boolean progress) {
        this.isProgress = progress;
    }

    public int getPercent() {
        ScheduleExceOperInfo operInfo = this.exceOperInfo;
        if (this.getOperTC() != 0 && operInfo.getOperRTC() != 0) {
            int operPercent = this.getOperTCC() * 100 / this.getOperTC();
            int curOperPercent = (int)((double)(operInfo.getOperRTSC() + operInfo.getOperRTFC()) * 100.0 / (double)operInfo.getOperRTC() / (double)this.getOperTC());
            this.percent = operPercent + curOperPercent;
        }
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public int getRecordTC() {
        return this.recordTC;
    }

    public void appendRecordTC(int recordTC) {
        this.recordTC += recordTC;
        this.exceOperInfo.setOperRTC(recordTC);
    }

    public int getRecordTSC() {
        return this.recordTSC;
    }

    public int getRecordTFC() {
        return this.recordTFC;
    }

    public void appendExecRecord(int successCount, int failCount) {
        this.recordTSC += successCount;
        this.recordTFC += failCount;
        this.exceOperInfo.setOperRTSC(successCount);
        this.exceOperInfo.setOperRTFC(failCount);
    }

    public String getExecDetails() {
        return this.execDetails;
    }

    public void setExecDetails(String execDetails) {
        this.execDetails = execDetails;
    }

    public ScheduleExceOperInfo getExceOperInfo() {
        return this.exceOperInfo;
    }

    public void setExceOperInfo(ScheduleExceOperInfo exceOperInfo) {
        this.exceOperInfo = exceOperInfo;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateTime) {
        this.lastUpdateDate = lastUpdateTime;
    }

    public int getOperTC() {
        return this.operTC;
    }

    public void setOperTC(int operTC) {
        this.operTC = operTC;
    }

    public int getOperTCC() {
        return this.operTCC;
    }

    public void setOperTCC() {
        ++this.operTCC;
    }

    public String toString() {
        return "ScheduleExecInfo{schemaId=" + this.schemaId + ", isProgress=" + this.isProgress + ", operTotC=" + this.operTC + ", operComC=" + this.operTCC + ", percent=" + this.percent + ", recordTotC=" + this.recordTC + ", recordSucC=" + this.recordTSC + ", recordFaiC=" + this.recordTFC + ", execDetails='" + this.execDetails + '\'' + ", lastUpdateDate=" + this.lastUpdateDate + '}';
    }
}

