/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.BankPasswordHelper;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BankInputPasswordPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Set opKeys;
        String entityName;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        if (view instanceof BillView) {
            entityName = view.getModel().getDataEntityType().getName();
        } else {
            BillList billList = (BillList)view.getControl("billlistap");
            entityName = billList.getEntityId();
        }
        Map config = BusinessDataServiceHelper.loadFromCache((String)"cas_showppwdconfig", (QFilter[])new QFilter[0]);
        Map<String, String> data = config.values().stream().collect(Collectors.groupingBy(s -> s.getString("billtype.number"), Collectors.mapping(s -> s.getString("opkey"), Collectors.joining())));
        if (this.isNeedPassword().booleanValue() && !option.containsVariable("isValidated") && data.containsKey(entityName) && data.get(entityName).contains(operateKey) && (opKeys = Arrays.stream(data.get(entityName).split(",")).collect(Collectors.toSet())).contains(operateKey)) {
            args.setCancel(true);
            BankPasswordHelper.checkBankPwd(null, (IFormPlugin)this, this.getView(), operateKey, option);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_PWD_CALLBACK")) {
            Map data2 = (Map)evt.getReturnData();
            String randomIdx = this.getView().getPageCache().get("randomIdx");
            String opkey = this.getView().getPageCache().get("realopkey");
            if (data2 != null && "1".equals(data2.get("loginpass")) && randomIdx.equals(data2.get("randomIdx"))) {
                OperateOption option = EmptyUtil.isEmpty(this.getView().getPageCache().get("oldoption")) ? OperateOption.create() : (OperateOption)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("oldoption"));
                option.setVariableValue("isCheckPassCA", "isCheckPassCA");
                option.setVariableValue("isValidated", "1");
                this.getView().invokeOperation(opkey, option);
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_NEWPWD_CALLBACK")) {
            Map data3 = (Map)evt.getReturnData();
            if (data3 != null && "1".equals(data3.get("initpass"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f\u3002", (String)"CommitToBe_1", (String)"bos-ext-tmc", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else if ((StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_RESETPWD_CALLBACK") || StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_UPDATEPWD_CALLBACK")) && (data = (Map)evt.getReturnData()) != null && "1".equals(data.get("resetsuccess"))) {
            String mesage = StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_RESETPWD_CALLBACK") ? ResManager.loadKDString((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f\u3002", (String)"CommitToBe_6", (String)"bos-ext-tmc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\u3002", (String)"CommitToBe_7", (String)"bos-ext-tmc", (Object[])new Object[0]);
            evt.getView().showSuccessNotification(mesage, Integer.valueOf(2000));
            BankPasswordHelper.showPwdForm(BankInputPasswordPlugin.class.getName(), "cas_bankinputpwd", evt.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("updatePwd".equals(callBackId)) {
            MessageBoxResult result = evt.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                BankPasswordHelper.showPwdForm(BankInputPasswordPlugin.class.getName(), "cas_bankupdatepwd", this.getView());
            } else if (MessageBoxResult.No.equals((Object)result)) {
                BankPasswordHelper.showPwdForm(BankInputPasswordPlugin.class.getName(), "cas_bankinputpwd", this.getView());
            }
        }
    }

    protected Boolean isNeedPassword() {
        Boolean isNeedPassWord = Boolean.FALSE;
        QFilter payWriteNumber = new QFilter("number", "=", (Object)"fi.cas.pass.ca");
        DynamicObject payWriteConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber});
        if (payWriteConfig != null && "true".equals(payWriteConfig.getString("configvalue"))) {
            isNeedPassWord = Boolean.TRUE;
        }
        return isNeedPassWord;
    }
}

