/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class IncontainerListPlugin
extends AbstractListPlugin
implements RowClickEventListener {
    private static final String SUSPECTDATA = "suspectData";
    private static final String SELECTFIELDS = "billid,suspectentry.suspectbillentity suspectbillentity,suspectentry.suspectbillid suspectbillid,suspectset.number,destdescribe";

    public void registerListener(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList != null) {
            billList.addListRowSelectAllListeners((Consumer)new Consumer<ListRowSelectAllEvent>(){

                @Override
                public void accept(ListRowSelectAllEvent arg0) {
                    String flexType = (String)IncontainerListPlugin.this.getView().getFormShowParameter().getCustomParam("flexType");
                    if ("currentdata".equals(flexType)) {
                        IncontainerListPlugin.this.returnListSelectData();
                    }
                }
            });
        }
        CardEntry cardEntry = (CardEntry)this.getControl("cardentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String flexType = (String)this.getView().getFormShowParameter().getCustomParam("flexType");
        if (billList != null && "susdata".equals(flexType)) {
            Set suspectBillIds = (Set)SerializationUtils.deSerializeFromBase64((String)this.getView().getParentView().getPageCache().get(SUSPECTDATA));
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            DynamicObjectCollection cardentry = this.getModel().getEntryEntity("cardentry");
            cardentry.clear();
            if (EmptyUtil.isNoEmpty(entityNumber)) {
                DynamicObjectCollection suspectData = QueryServiceHelper.query((String)"fcs_suspectbill", (String)SELECTFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)suspectBillIds)});
                Set data = suspectData.stream().filter(s -> entityNumber.equals(s.getString("suspectbillentity"))).collect(Collectors.toSet());
                Map cardMap = data.stream().collect(Collectors.groupingBy(s -> s.getString("suspectset.number"), Collectors.groupingBy(s -> s.getString("destdescribe"), Collectors.mapping(s -> s.getLong("suspectbillid"), Collectors.toSet()))));
                for (DynamicObject row : data) {
                    cardMap.get(row.getString("suspectset.number")).get(row.getString("destdescribe")).add(row.getLong("billid"));
                }
                List suspectIds = (List)this.getView().getFormShowParameter().getCustomParam("suspectIds");
                for (Map.Entry entryMap : cardMap.entrySet()) {
                    String suspectNumber = entryMap.getKey();
                    for (Map.Entry entrySet : entryMap.getValue().entrySet()) {
                        ArrayList tempList = new ArrayList(suspectIds);
                        tempList.retainAll(entrySet.getValue());
                        if (!EmptyUtil.isNoEmpty(tempList)) continue;
                        DynamicObject card = cardentry.addNew();
                        card.set("title", (Object)ResManager.loadKDString((String)"\u7591\u4f3c\u91cd\u590d\u5173\u952e\u5b57\u6bb5\uff08\u9632\u91cd\u89c4\u5219\uff1a%s\uff09", (String)"IncontainerListPlugin_0", (String)"bos-ext-tmc", (Object[])new Object[]{suspectNumber}));
                        card.set("detail", (Object)entrySet.getKey());
                        card.set("suspectbillids", (Object)tempList.stream().map(Object::toString).collect(Collectors.joining(",")));
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String flexType = (String)this.getView().getFormShowParameter().getCustomParam("flexType");
        if (billList != null) {
            if ("susdata".equals(flexType)) {
                ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                ArrayList<Object> listGridMetaData = new ArrayList<Object>(10);
                listGridMetaData.add(billList.getListGridViewKey());
                HashMap<String, Boolean> listGridClientConfig = new HashMap<String, Boolean>(4);
                listGridClientConfig.put("selcheckbox", false);
                listGridMetaData.add(listGridClientConfig);
                clientViewProxy.addAction("updateControlMetadata", listGridMetaData);
                this.getView().setVisible(Boolean.valueOf(this.selectdataIdNotEmptiy()), new String[]{"cardflex"});
                DynamicObjectCollection cardentry = this.getModel().getEntryEntity("cardentry");
                if (this.selectdataIdNotEmptiy() && EmptyUtil.isEmpty(this.getView().getPageCache().get("isClick")) && cardentry.size() > 0) {
                    CardEntry cardEntry = (CardEntry)this.getControl("cardentry");
                    cardEntry.selectCard(Integer.valueOf(0));
                    this.getView().getPageCache().put("isClick", "true");
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardflex"});
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        String flexType = (String)this.getView().getFormShowParameter().getCustomParam("flexType");
        if ("currentdata".equals(flexType)) {
            this.returnListSelectData();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey;
        Object source = evt.getSource();
        if (source instanceof CardEntry && "cardentry".equals(entryKey = ((CardEntry)source).getEntryKey())) {
            DynamicObject card = (DynamicObject)this.getModel().getEntryEntity("cardentry").get(evt.getRow());
            Set suspectCardBillIds = Arrays.stream(card.getString("suspectbillids").split(",")).map(Long::parseLong).collect(Collectors.toSet());
            BillList billList = (BillList)this.getView().getControl("billlistap");
            if (billList != null) {
                billList.setFilter(new QFilter("id", "in", suspectCardBillIds));
                billList.refreshData();
            }
        }
    }

    private void returnListSelectData() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
        String selectDataIdStr = Arrays.stream(primaryKeyValues).map(Object::toString).collect(Collectors.joining(","));
        this.getView().getParentView().getModel().setValue("selectdataid", (Object)selectDataIdStr);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private boolean selectdataIdNotEmptiy() {
        String selectdataid = (String)this.getView().getParentView().getModel().getValue("selectdataid");
        return EmptyUtil.isNoEmpty(selectdataid);
    }
}

