/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin.fbd;

import com.alibaba.fastjson.JSON;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.tmc.model.fbd.AttachTypeItem;
import kd.bos.ext.tmc.model.fbd.AttachTypePanelCache;
import kd.bos.ext.tmc.prop.fbd.AttachTypePanelProp;
import kd.bos.ext.tmc.utils.commitToBe.enums.BillStatusEnum;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.fbd.AttachTypeFactory;
import kd.bos.ext.tmc.utils.helper.fbd.AttachTypeHelper;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.attachment.AttachmentFieldModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;

public class AttachTypePanelEdit
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(AttachTypePanelEdit.class);
    private boolean initFromAttachmentPanel = false;

    public void initialize() {
        super.initialize();
        this.addEntryGridListener();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void createNewData(BizDataEventArgs e) {
        this.initDataFromDb(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initFormPageData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"attach_type_panel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"attach_type_list"});
        this.getParentViewNoPlugin().getPageCache().put("childPageId", this.getView().getPageId());
        IDataModel parentModel = this.getParentViewNoPlugin().getModel();
        String status = (String)parentModel.getValue("billstatus");
        this.getView().setEnable(Boolean.valueOf(StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getValue())), new String[]{"entryentity", "refreshattachtype"});
        this.getView().setVisible(Boolean.valueOf(StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getValue())), new String[]{"btn_refreshattachtype"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        switch (opKey) {
            case "save": {
                boolean fromAuditFlow = this.isFromAuditFlow();
                operate.getOption().setVariableValue("skipValidate", fromAuditFlow ? "1" : "0");
                if (fromAuditFlow) {
                    return;
                }
                this.validateAttachTypeChange(args);
                break;
            }
            case "refreshattachtype": {
                this.validateAttachTypeChange(args);
                break;
            }
            case "deleteattach": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\u8be5\u6587\u4ef6\uff1f", (String)"AttachTypePanelEdit_1", (String)"bos-ext-tmc", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteattach", (IFormPlugin)this));
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
                DynamicObject attachBase = entryRowEntity.getDynamicObject("attach");
                IPageCache pageCache = this.getPageCache();
                pageCache.put("attachtypeid", String.valueOf(entryRowEntity.getLong("attachtypeid")));
                pageCache.put("opFileId", String.valueOf(attachBase.getPkValue()));
                pageCache.put("uid", String.valueOf(attachBase.getString("uid")));
                pageCache.put("rowIndex", rowIndex + "");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (opKey) {
            case "rename": 
            case "retype": {
                this.showAttachForm(opKey);
                break;
            }
            case "preview": {
                this.previewFile();
                break;
            }
            case "download": {
                this.downloadFile();
                break;
            }
            case "downloadall": {
                this.downloadAllAttachments();
                break;
            }
            case "attachupload": {
                AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment");
                attachmentEdit.openEntryUploadView(rowIndex, false);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult res = evt.getResult();
        IFormView view = this.getView();
        switch (callBackId) {
            case "deleteattach": {
                if (!MessageBoxResult.Yes.equals((Object)res)) break;
                IPageCache pageCache = this.getPageCache();
                Long typeId = Long.parseLong(pageCache.get("attachtypeid"));
                Long opFileId = Long.parseLong(pageCache.get("opFileId"));
                String uid = pageCache.get("uid");
                pageCache.remove("attachtypeid");
                pageCache.remove("opFileId");
                pageCache.remove("uid");
                HashMap<String, String> attaches = new HashMap<String, String>(1);
                attaches.put("uid", uid);
                AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment");
                AttachmentFieldModel attachmentModel = (AttachmentFieldModel)attachmentEdit.getAttachmentModel();
                attachmentModel.deleteAttachments(this.getModel().getDataEntity().getDataEntityType().getName(), attachmentEdit.getTableName(), attaches);
                AttachTypePanelCache cache = AttachTypeFactory.getAttachmentTypePanelCache(view);
                for (AttachTypeItem item : cache.getItemList()) {
                    if (!Objects.equals(item.getAttItemId(), typeId)) continue;
                    item.getFileIdList().remove(opFileId);
                    break;
                }
                this.getModel().deleteEntryRow("entryentity", Integer.parseInt(pageCache.get("rowIndex")));
                pageCache.remove("rowIndex");
                cache.getItemList().removeIf(next -> next.getAttItemId() == 0L && EmptyUtil.isEmpty(next.getFileIdList()));
                AttachTypeFactory.putPageCache(view, cache);
                this.processAttachTypeEntryFromCache(cache, "special");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object returnDataObject = evt.getReturnData();
        AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment");
        AttachmentFieldModel attachmentModel = (AttachmentFieldModel)attachmentEdit.getAttachmentModel();
        switch (actionId) {
            case "rename": {
                if (null == returnDataObject) break;
                Map customParams = (Map)returnDataObject;
                String fileName = (String)customParams.get("inputtext");
                String suffix = (String)customParams.get("fileSuffix");
                int rowIndex = (Integer)customParams.get("rowIndex");
                attachmentModel.rename((String)customParams.get("uid"), fileName + suffix);
                DynamicObject currentRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
                DynamicObject attachBase = currentRowEntity.getDynamicObject("attach");
                currentRowEntity.set("attachnametext", (Object)(attachBase.getString("name") + "(" + attachBase.get("size") + "b)"));
                view.updateView("entryentity", rowIndex);
                break;
            }
            case "retype": {
                if (null == returnDataObject) break;
                Map customParams = (Map)returnDataObject;
                Long newTypeId = Long.parseLong(customParams.get("newTypeId").toString());
                Long oldTypeId = Long.parseLong(customParams.get("oldTypeId").toString());
                Long fileId = Long.parseLong(customParams.get("opFileId").toString());
                AttachTypePanelCache cache = AttachTypeFactory.getAttachmentTypePanelCache(view);
                for (AttachTypeItem item : cache.getItemList()) {
                    if (Objects.equals(item.getAttItemId(), oldTypeId)) {
                        item.getFileIdList().remove(fileId);
                        continue;
                    }
                    if (!Objects.equals(item.getAttItemId(), newTypeId)) continue;
                    item.getFileIdList().add(fileId);
                }
                cache.getItemList().removeIf(next -> next.getAttItemId() == 0L && EmptyUtil.isEmpty(next.getFileIdList()));
                AttachTypeFactory.putPageCache(view, cache);
                this.processAttachTypeEntryFromCache(cache, "special");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newVal = changeData.getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity(true);
        int rowIndex = changeData.getRowIndex();
        switch (key) {
            case "attachment": {
                DynamicObject attachBase;
                MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)newVal;
                DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
                DynamicObjectType entryObjectType = entries.getDynamicObjectType();
                AttachTypePanelCache cache = AttachTypeFactory.getAttachmentTypePanelCache(view);
                ArrayList<Object> fileIdList = new ArrayList<Object>(10);
                DynamicObject currentEntry = (DynamicObject)entries.get(rowIndex);
                long currentAttachTypeId = currentEntry.getLong("attachtypeid");
                entries.removeIf(entry -> currentAttachTypeId == entry.getLong("attachtypeid") && EmptyUtil.isEmpty(entry.getString("attachtypename")));
                if (currentAttachTypeId == 0L) {
                    entries.add(0, currentEntry);
                }
                int iterator = rowIndex;
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)mulBasedataDynamicObjectCollection)) {
                    for (DynamicObject attach : mulBasedataDynamicObjectCollection) {
                        attachBase = attach.getDynamicObject("fbasedataid");
                        if (iterator != rowIndex) {
                            DynamicObject newEntry = new DynamicObject(entryObjectType);
                            entries.add(iterator, newEntry);
                            model.setValue("attachtypeid", (Object)currentAttachTypeId, iterator);
                        }
                        model.setValue("attach", attachBase.getPkValue(), iterator);
                        model.setValue("isupload", (Object)true, iterator);
                        model.setValue("entryattachtypesetting", (Object)(cache.getSetting() != null ? 1 : 0), iterator);
                        model.setValue("mustupload", model.getValue("mustupload", rowIndex), iterator);
                        model.setValue("mustuploadatconfig", model.getValue("mustuploadatconfig", rowIndex), iterator);
                        ++iterator;
                        fileIdList.add(attachBase.getPkValue());
                    }
                } else {
                    model.setValue("attach", null, rowIndex);
                    model.setValue("isupload", (Object)false, rowIndex);
                    model.setValue("attachnametext", null, rowIndex);
                    model.setValue("mark", null, rowIndex);
                }
                for (DynamicObject entry2 : entries) {
                    attachBase = entry2.getDynamicObject("attach");
                    if (EmptyUtil.isNoEmpty(attachBase)) {
                        entry2.set("attachnametext", (Object)(attachBase.getString("name") + "(" + attachBase.get("size") + "b)"));
                        entry2.set("mark", (Object)attachBase.getString("description"));
                    }
                    entry2.set("entrykey", (Object)"1");
                }
                List<AttachTypeItem> itemList = cache.getItemList();
                itemList.forEach(item -> {
                    if (item.getAttItemId().longValue() == currentEntry.getLong("attachtypeid")) {
                        item.setFileIdList(fileIdList);
                    }
                });
                AttachTypeFactory.putPageCache(view, cache);
                view.updateView("entryentity");
                break;
            }
            case "mark": {
                AttachmentEdit attachmentEdit = (AttachmentEdit)this.getControl("attachment");
                AttachmentFieldModel attachmentModel = (AttachmentFieldModel)attachmentEdit.getAttachmentModel();
                DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
                DynamicObject attachBase = entryRowEntity.getDynamicObject("attach");
                attachmentModel.mark(attachBase.getString("uid"), new LocaleString((String)newVal));
                view.updateView("entryentity", rowIndex);
                break;
            }
        }
    }

    private void initDataFromDb(BizDataEventArgs e) {
        IDataModel model = this.getParentViewNoPlugin().getModel();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("releasebillid", "=", model.getValue("id")));
        filters.add(new QFilter("releasebilltype", "=", (Object)model.getDataEntity().getDataEntityType().getName()));
        DynamicObject attachTypePanel = BusinessDataServiceHelper.loadSingle((String)"fbd_attachtype_panel", (QFilter[])filters.toArray(new QFilter[0]));
        if (EmptyUtil.isNoEmpty(attachTypePanel)) {
            e.setDataEntity((Object)attachTypePanel);
            this.initFromAttachmentPanel = false;
        } else {
            this.initFromAttachmentPanel = true;
        }
    }

    private void addEntryGridListener() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            block28: {
                Object source;
                DynamicObject data;
                block27: {
                    data = pkEvent.getRowData();
                    source = pkEvent.getSource();
                    if (!(source instanceof OperationColumn)) break block27;
                    String key = ((OperationColumn)source).getKey();
                    List operationColItems = (List)pkEvent.getFormatValue();
                    switch (key) {
                        case "showattachiconcolumn": {
                            for (OperationColItem operationColItem : operationColItems) {
                                if (data.getBoolean("isupload")) continue;
                                operationColItem.setVisible(false);
                                operationColItem.setLocked(true);
                            }
                            break block28;
                        }
                        case "operationcolumnap": {
                            for (OperationColItem operationColItem : operationColItems) {
                                DynamicObject attachBase;
                                String opKey = operationColItem.getOperationKey();
                                if (!AttachTypePanelProp.ENTRY_OP_COLUMN_KEY.contains(opKey)) continue;
                                IDataModel parentModel = this.getParentViewNoPlugin().getModel();
                                String status = (String)parentModel.getValue("billstatus");
                                if (!AttachTypePanelProp.ENTRY_OP_COLUMN_NOT_SAVE_SHOW_KEY.contains(opKey) && !StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getValue())) {
                                    operationColItem.setVisible(false);
                                    operationColItem.setLocked(true);
                                }
                                if (!data.getBoolean("isupload")) {
                                    operationColItem.setVisible(false);
                                    operationColItem.setLocked(true);
                                }
                                if ("preview".equals(opKey) && (EmptyUtil.isEmpty(attachBase = data.getDynamicObject("attach")) || !AttachTypePanelProp.SUPPORT_PREVIEW_TYPE.contains(attachBase.getString("type")))) {
                                    operationColItem.setVisible(false);
                                    operationColItem.setLocked(true);
                                }
                                if (!"retype".equals(opKey) || data.getBoolean("entryattachtypesetting")) continue;
                                operationColItem.setVisible(false);
                            }
                            break block28;
                        }
                        case "uploadoperationcolumn": {
                            for (OperationColItem operationColItem : operationColItems) {
                                String opKey = operationColItem.getOperationKey();
                                if (!"attachupload".equalsIgnoreCase(opKey)) continue;
                                IDataModel parentModel = this.getParentViewNoPlugin().getModel();
                                String status = (String)parentModel.getValue("billstatus");
                                if (!StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getValue())) {
                                    operationColItem.setLocked(true);
                                }
                                if (!EmptyUtil.isEmpty(data.getString("attachtypename")) || pkEvent.getRowIndex() == 0) continue;
                                operationColItem.setVisible(false);
                                operationColItem.setLocked(true);
                            }
                            break block28;
                        }
                        case "mustuploadopcolumn": {
                            for (OperationColItem operationColItem : operationColItems) {
                                boolean mustUpload = data.getBoolean("mustupload");
                                if (mustUpload && !EmptyUtil.isEmpty(data.getString("attachtypename"))) continue;
                                operationColItem.setVisible(false);
                                operationColItem.setLocked(true);
                            }
                            break block28;
                        }
                    }
                    break block28;
                }
                if (source instanceof TextEdit) {
                    String key;
                    switch (key = ((TextEdit)source).getKey()) {
                        case "mark": {
                            if (data.getBoolean("isupload")) break;
                            ((TextEdit)source).setEnable("", Boolean.FALSE.booleanValue(), pkEvent.getRowIndex());
                        }
                    }
                }
            }
        });
    }

    private void initFormPageData() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        if (data.getDataEntityState().getFromDatabase()) {
            if (this.isFromAuditFlow()) {
                this.initAttachmentTypeUploadListForAuditFlow();
            } else {
                this.initAttachmentTypeUploadListForDetails();
            }
        } else {
            IDataModel parentModel = this.getParentViewNoPlugin().getModel();
            model.setValue("releasebillid", parentModel.getValue("id"));
            model.setValue("releasebilltype", (Object)parentModel.getDataEntityType().getName());
            boolean initFromPanelResult = false;
            if (this.initFromAttachmentPanel) {
                initFromPanelResult = this.initAttachmentTypeUploadListFromPanel();
            }
            if (!initFromPanelResult) {
                this.initAttachmentTypeUploadList("common");
            }
        }
    }

    private IFormView getParentViewNoPlugin() {
        return this.getView().getViewNoPlugin(this.getFormShowCustomParam("parentPageId"));
    }

    private String getFormShowCustomParam(String key) {
        return (String)this.getView().getFormShowParameter().getCustomParam(key);
    }

    private boolean initAttachmentTypeUploadListFromPanel() {
        String attachmentPanelKey = (String)this.getView().getFormShowParameter().getCustomParam("businessAttachPanelKey");
        IFormView parentView = this.getParentViewNoPlugin();
        IDataModel parentModel = parentView.getModel();
        List attachments = AttachmentServiceHelper.getAttachments((String)parentView.getEntityId(), (Object)parentModel.getValue("id"), (String)attachmentPanelKey);
        if (EmptyUtil.isEmpty(attachments)) {
            return false;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject data = model.getDataEntity(true);
        Object pkId = data.getPkValue();
        if (EmptyUtil.isEmpty(pkId)) {
            pkId = DB.genLongId((String)data.getDataEntityType().getAlias());
            data.set("id", pkId);
        }
        String entityId = data.getDataEntityType().getName();
        attachments.forEach(attachment -> {
            attachment.put("uid", AttachTypeHelper.getInstance().getUid());
            attachment.put("entityNum", entityId);
            attachment.put("billPkId", String.valueOf(model.getValue("id")));
            String preViewUrl = attachment.getOrDefault("previewurl", "");
            String url = attachment.getOrDefault("url", "");
            preViewUrl = preViewUrl.indexOf("&") > 0 ? preViewUrl.substring(0, preViewUrl.indexOf("&")) : preViewUrl;
            preViewUrl = preViewUrl.indexOf("path=") > 0 ? preViewUrl.substring(preViewUrl.indexOf("path=") + 6) : preViewUrl;
            url = url.indexOf("&") > 0 ? url.substring(0, url.indexOf("&")) : url;
            url = url.indexOf("path=") > 0 ? url.substring(url.indexOf("path=") + 6) : url;
            attachment.put("previewurl", preViewUrl);
            attachment.put("url", url);
            attachment.put("uploadTime", attachment.getOrDefault("createdate", new Date().getTime()));
        });
        AttachmentEdit attachmentEdit = (AttachmentEdit)this.getView().getControl("attachment");
        List saveAttachments = attachmentEdit.getAttachmentModel().saveAttachments(attachmentEdit.getModel(), view.getPageId(), entityId, attachments);
        if (EmptyUtil.isEmpty(saveAttachments)) {
            return false;
        }
        AttachTypePanelCache cache = AttachTypeFactory.initAttachmentCache(view, "panel");
        List<AttachTypeItem> itemList = cache.getItemList();
        List<Object> fileIds = saveAttachments.stream().map(attach -> attach.getLong("id")).collect(Collectors.toList());
        boolean haveSetting = cache.getSetting() != null;
        model.deleteEntryData("entryentity");
        for (AttachTypeItem typeItem : itemList) {
            if (typeItem.getAttItemId() != 0L) continue;
            typeItem.setFileIdList(fileIds);
        }
        AttachTypeFactory.putPageCache(view, cache);
        this.processAttachTypeEntryFromCache(cache, "panel");
        model.setValue("attachtypesetting", (Object)haveSetting);
        return true;
    }

    private void initAttachmentTypeUploadListForDetails() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        AttachTypePanelCache cache = AttachTypeFactory.initAttachmentCache(view, "common");
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
        boolean haveSetting = cache.getSetting() != null;
        this.initEntryPropFromAttachType(data, cache);
        List<AttachTypeItem> itemList = cache.getItemList();
        if (EmptyUtil.isEmpty(itemList)) {
            view.updateView("entryentity");
            return;
        }
        if (EmptyUtil.isEmpty(entries)) {
            for (AttachTypeItem typeItem : itemList) {
                boolean mustUploadAtCondition = this.itemMustUpload(typeItem);
                boolean mustUpload = typeItem.getMustUpload() != null && typeItem.getMustUpload() != false;
                DynamicObject newEntry = entries.addNew();
                newEntry.set("attachtypeid", (Object)typeItem.getAttItemId());
                newEntry.set("attachtypename", (Object)typeItem.getAttachName());
                newEntry.set("attachtypeinfo", (Object)typeItem.getAttachInfo());
                newEntry.set("operatenode", (Object)typeItem.getAtOperateNode());
                newEntry.set("mustuploadatconfig", (Object)mustUploadAtCondition);
                newEntry.set("mustupload", (Object)mustUpload);
                newEntry.set("entryattachtypesetting", (Object)haveSetting);
            }
        } else {
            Set typeIdSet = entries.stream().map(e -> e.getLong("attachtypeid")).collect(Collectors.toSet());
            for (AttachTypeItem typeItem : itemList) {
                boolean mustUpload;
                boolean mustUploadAtCondition = this.itemMustUpload(typeItem);
                boolean bl = mustUpload = typeItem.getMustUpload() != null && typeItem.getMustUpload() != false;
                if (typeIdSet.contains(typeItem.getAttItemId())) {
                    entries.forEach(e -> {
                        if (e.getLong("attachtypeid") == typeItem.getAttItemId().longValue() && EmptyUtil.isNoEmpty(e.getString("attachtypename"))) {
                            e.set("attachtypename", (Object)typeItem.getAttachName());
                            e.set("attachtypeinfo", (Object)typeItem.getAttachInfo());
                            e.set("operatenode", (Object)typeItem.getAtOperateNode());
                            e.set("mustuploadatconfig", (Object)mustUploadAtCondition);
                            e.set("mustupload", (Object)mustUpload);
                        }
                    });
                    continue;
                }
                DynamicObject newEntry = entries.addNew();
                newEntry.set("attachtypeid", (Object)typeItem.getAttItemId());
                newEntry.set("attachtypename", (Object)typeItem.getAttachName());
                newEntry.set("attachtypeinfo", (Object)typeItem.getAttachInfo());
                newEntry.set("operatenode", (Object)typeItem.getAtOperateNode());
                newEntry.set("mustuploadatconfig", (Object)mustUploadAtCondition);
                newEntry.set("mustupload", (Object)mustUpload);
                newEntry.set("entryattachtypesetting", (Object)haveSetting);
            }
            entries.removeIf(e -> itemList.stream().noneMatch(item -> item.getAttItemId().equals(e.getLong("attachtypeid"))) && EmptyUtil.isEmpty(e.getDynamicObject("attach")));
        }
        entries.forEach(e -> e.set("entrykey", (Object)"1"));
        view.updateView("entryentity");
    }

    private void initAttachmentTypeUploadListForAuditFlow() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        AttachTypePanelCache cache = AttachTypeFactory.initAttachmentCache(view, "common");
        this.initEntryPropFromAttachType(data, cache);
        view.updateView("entryentity");
    }

    private void initEntryPropFromAttachType(DynamicObject data, AttachTypePanelCache cache) {
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
        boolean haveSetting = cache.getSetting() != null;
        List<AttachTypeItem> itemList = cache.getItemList();
        if (EmptyUtil.isNoEmpty(entries)) {
            entries.forEach(entry -> {
                DynamicObject attachBase = entry.getDynamicObject("attach");
                if (EmptyUtil.isNoEmpty(attachBase)) {
                    entry.set("attachnametext", (Object)(attachBase.getString("name") + "(" + attachBase.get("size") + "b)"));
                    entry.set("mark", (Object)attachBase.getString("description"));
                }
                entry.set("entryattachtypesetting", (Object)haveSetting);
                entry.set("entrykey", (Object)"1");
                if (EmptyUtil.isNoEmpty(itemList)) {
                    for (AttachTypeItem typeItem : itemList) {
                        if (!typeItem.getAttItemId().equals(entry.getLong("attachtypeid"))) continue;
                        boolean mustUploadAtCondition = this.itemMustUpload(typeItem);
                        entry.set("mustuploadatconfig", (Object)mustUploadAtCondition);
                        entry.set("operatenode", (Object)typeItem.getAtOperateNode());
                        if (!EmptyUtil.isNoEmpty(entry.getString("attachtypename"))) break;
                        boolean mustUpload = typeItem.getMustUpload() != null && typeItem.getMustUpload() != false;
                        entry.set("mustupload", (Object)mustUpload);
                        entry.set("attachtypename", (Object)typeItem.getAttachName());
                        entry.set("attachtypeinfo", (Object)typeItem.getAttachInfo());
                        break;
                    }
                }
            });
        }
    }

    private boolean itemMustUpload(AttachTypeItem typeItem) {
        if (typeItem.getMustUpload() == null) {
            return false;
        }
        return typeItem.getMustUpload() != false && AttachTypeHelper.getInstance().isFilterBill(typeItem.getAtCondition(), this.getParentViewNoPlugin().getModel().getDataEntity(true));
    }

    private void initAttachmentTypeUploadList(String initType) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        AttachTypePanelCache cache = AttachTypeFactory.initAttachmentCache(view, initType);
        if (EmptyUtil.isEmpty(model.getValue("id"))) {
            model.setValue("id", cache.getId());
        }
        if (EmptyUtil.isEmpty(model.getValue("billno"))) {
            model.setValue("billno", (Object)cache.getBillNo());
        }
        model.setValue("attachtypesetting", (Object)EmptyUtil.isNoEmpty(cache.getSetting()));
        this.processAttachTypeEntryFromCache(cache, initType);
    }

    private void processAttachTypeEntryFromCache(AttachTypePanelCache cache, String initType) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
        List<AttachTypeItem> itemList = cache.getItemList();
        if (EmptyUtil.isEmpty(itemList)) {
            return;
        }
        DynamicObjectType entryObjectType = model.getEntryEntity("entryentity").getDynamicObjectType();
        model.deleteEntryData("entryentity");
        int rowIndex = 0;
        for (AttachTypeItem typeItem : itemList) {
            List<Object> fileIdList = typeItem.getFileIdList();
            boolean mustUploadAtCondition = this.itemMustUpload(typeItem);
            boolean mustUpload = typeItem.getMustUpload() != null && typeItem.getMustUpload() != false;
            String operateNode = typeItem.getAtOperateNode();
            if (EmptyUtil.isEmpty(fileIdList)) {
                DynamicObject entry = new DynamicObject(entryObjectType);
                entry.set("attachtypeid", (Object)typeItem.getAttItemId());
                entry.set("attachtypename", (Object)typeItem.getAttachName());
                entry.set("attachtypeinfo", (Object)typeItem.getAttachInfo());
                entry.set("mustuploadatconfig", (Object)mustUploadAtCondition);
                entry.set("mustupload", (Object)mustUpload);
                entry.set("operatenode", (Object)operateNode);
                entries.add(rowIndex++, entry);
                continue;
            }
            int firstRowIndex = rowIndex;
            for (Object id : fileIdList) {
                DynamicObject sameAttachTypeEntry;
                if (StringUtils.equals((CharSequence)initType, (CharSequence)"common") || StringUtils.equals((CharSequence)initType, (CharSequence)"panel")) {
                    sameAttachTypeEntry = new DynamicObject(entryObjectType);
                    sameAttachTypeEntry.set("attachtypeid", (Object)typeItem.getAttItemId());
                    sameAttachTypeEntry.set("isupload", (Object)true);
                    entries.add(rowIndex, sameAttachTypeEntry);
                    if (firstRowIndex == rowIndex) {
                        model.setValue("attachtypename", (Object)typeItem.getAttachName(), rowIndex);
                        model.setValue("attachtypeinfo", (Object)typeItem.getAttachInfo(), rowIndex);
                        model.setValue("attachment", (Object)fileIdList.toArray(), rowIndex);
                    }
                } else if (StringUtils.equals((CharSequence)initType, (CharSequence)"special") && firstRowIndex == rowIndex) {
                    sameAttachTypeEntry = new DynamicObject(entryObjectType);
                    sameAttachTypeEntry.set("attachtypeid", (Object)typeItem.getAttItemId());
                    sameAttachTypeEntry.set("isupload", (Object)true);
                    entries.add(rowIndex, sameAttachTypeEntry);
                    model.setValue("attachtypename", (Object)typeItem.getAttachName(), rowIndex);
                    model.setValue("attachtypeinfo", (Object)typeItem.getAttachInfo(), rowIndex);
                    model.setValue("attachment", (Object)fileIdList.toArray(), rowIndex);
                }
                model.setValue("attach", id, rowIndex);
                model.setValue("operatenode", (Object)operateNode, rowIndex);
                model.setValue("mustuploadatconfig", (Object)mustUploadAtCondition, rowIndex);
                model.setValue("mustupload", (Object)mustUpload, rowIndex);
                model.setValue("entryattachtypesetting", (Object)(cache.getSetting() != null ? 1 : 0), rowIndex);
                DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
                DynamicObject attachBase = entryRowEntity.getDynamicObject("attach");
                model.setValue("attachnametext", (Object)(attachBase.getString("name") + "(" + attachBase.get("size") + "b)"), rowIndex);
                model.setValue("mark", (Object)attachBase.getString("description"), rowIndex);
                ++rowIndex;
            }
        }
        entries.forEach(e -> e.set("entrykey", (Object)"1"));
        view.updateView("entryentity");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateAttachTypeChange(BeforeDoOperationEventArgs args) {
        String cancelMsg;
        boolean existBlankType;
        boolean saveOperate;
        boolean haveAttachTypeSettingDb;
        IDataModel model;
        String opKey;
        block15: {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            opKey = operate.getOperateKey();
            model = this.getModel();
            OperateOption option = operate.getOption();
            DynamicObject dataEntity = model.getDataEntity(true);
            AttachTypePanelCache cache = AttachTypeFactory.getAttachmentTypePanelCache(this.getView());
            List<AttachTypeItem> itemList = cache.getItemList();
            DynamicObject settingDb = AttachTypeFactory.getMatchAttachType(this.getView());
            boolean haveAttachTypeSetting = dataEntity.getBoolean("attachtypesetting");
            haveAttachTypeSettingDb = EmptyUtil.isNoEmpty(settingDb);
            saveOperate = StringUtils.equals((CharSequence)option.getVariableValue("operateType", ""), (CharSequence)"save");
            if (!haveAttachTypeSetting && !haveAttachTypeSettingDb) {
                return;
            }
            existBlankType = dataEntity.getDynamicObjectCollection("entryentity").stream().filter(e -> EmptyUtil.isEmpty(e.getLong("attachtypeid"))).distinct().findAny().isPresent();
            cancelMsg = ResManager.loadKDString((String)"\u9644\u4ef6\u5206\u7c7b\u4fe1\u606f\u6709\u5237\u65b0\uff0c\u5df2\u4e0a\u4f20\u9644\u4ef6\u5df2\u7edf\u4e00\u653e\u5728\u7b2c\u4e00\u4e2a\u7a7a\u767d\u5206\u7c7b\u884c\uff0c\u8bf7\u901a\u8fc7\u201c\u91cd\u5206\u7c7b\u201d\u64cd\u4f5c\u6765\u8c03\u6574\u5df2\u4e0a\u4f20\u9644\u4ef6\u5bf9\u5e94\u7684\u5206\u7c7b\u3002", (String)"AttachTypePanelEdit_0", (String)"bos-ext-tmc", (Object[])new Object[0]);
            if (!haveAttachTypeSetting && existBlankType || !haveAttachTypeSettingDb) {
                this.initAttachmentTypeUploadList("special");
                if (!saveOperate) {
                    if (opKey.equals("refreshattachtype")) {
                        this.getView().showConfirm(cancelMsg, MessageBoxOptions.OK);
                    } else {
                        this.getView().showErrorNotification(cancelMsg);
                    }
                    args.setCancel(true);
                    args.setCancelMessage(cancelMsg);
                    return;
                }
            }
            HashSet<Long> allTypeIdSet = new HashSet<Long>(10);
            Map<Long, AttachTypeItem> idAndTypeItemMap = itemList.stream().collect(Collectors.toMap(AttachTypeItem::getAttItemId, dy -> dy, (m1, m2) -> m1));
            HashMap idAndAttachTypeMap = haveAttachTypeSettingDb ? settingDb.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (m1, m2) -> m1)) : new HashMap(10);
            allTypeIdSet.addAll(idAndTypeItemMap.keySet());
            allTypeIdSet.addAll(idAndAttachTypeMap.keySet());
            boolean typeCountChange = false;
            boolean otherChange = false;
            for (Long typeId : allTypeIdSet) {
                if (typeId == 0L) continue;
                AttachTypeItem attachTypeItem = idAndTypeItemMap.get(typeId);
                DynamicObject attachTypeDy = (DynamicObject)idAndAttachTypeMap.get(typeId);
                if (attachTypeItem == null || EmptyUtil.isEmpty(attachTypeDy)) {
                    typeCountChange = true;
                    break;
                }
                if (StringUtils.equals((CharSequence)attachTypeItem.getAtCondition(), (CharSequence)attachTypeDy.getString("atsavecondition_tag")) && StringUtils.equals((CharSequence)attachTypeItem.getAtOperateNode(), (CharSequence)attachTypeDy.getString("atoperatenode")) && StringUtils.equals((CharSequence)attachTypeItem.getAttachName(), (CharSequence)attachTypeDy.getString("attachname")) && (EmptyUtil.isNoEmpty(attachTypeItem.getMustUpload()) && attachTypeItem.getMustUpload() != false) == attachTypeDy.getBoolean("ismustupload")) continue;
                otherChange = true;
            }
            if (typeCountChange) {
                this.initAttachmentTypeUploadList("special");
                if (saveOperate) {
                    operate.getOption().setVariableValue("skipValidate", "1");
                    break block15;
                } else {
                    if (opKey.equals("refreshattachtype")) {
                        this.getView().showConfirm(cancelMsg, MessageBoxOptions.OK);
                    } else {
                        this.getView().showErrorNotification(cancelMsg);
                    }
                    args.setCancelMessage(cancelMsg);
                    args.setCancel(true);
                    return;
                }
            }
            if (otherChange) {
                this.initAttachmentTypeUploadListForDetails();
                if (saveOperate && allTypeIdSet.contains(0L)) {
                    operate.getOption().setVariableValue("skipValidate", "1");
                }
            }
        }
        if (!saveOperate && existBlankType && !opKey.equals("refreshattachtype")) {
            this.getView().showErrorNotification(cancelMsg);
            args.setCancelMessage(cancelMsg);
            args.setCancel(true);
            return;
        }
        model.setValue("attachtypesetting", (Object)haveAttachTypeSettingDb);
    }

    private void showAttachForm(String opKey) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject currentRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
        DynamicObject attachBase = currentRowEntity.getDynamicObject("attach");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fbd_attach_text_dialog");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("rowIndex", rowIndex);
        if (StringUtils.equals((CharSequence)"rename", (CharSequence)opKey)) {
            String fileName = attachBase.getString("name");
            String name = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
            String suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : "";
            customParams.put("inputtext", name);
            customParams.put("fileSuffix", suffix);
            customParams.put("uid", attachBase.getString("uid"));
            parameter.setCaption(ResManager.loadKDString((String)"\u91cd\u547d\u540d", (String)"AttachTypePanelEdit_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"retype", (CharSequence)opKey)) {
            parameter.setFormId("fbd_attach_combo_dialog");
            AttachTypePanelCache attachmentTypePanelCache = AttachTypeFactory.getAttachmentTypePanelCache(view);
            List<AttachTypeItem> itemList = attachmentTypePanelCache.getItemList();
            ArrayList comboItems = new ArrayList(10);
            itemList.stream().filter(item -> EmptyUtil.isNoEmpty(item.getAttItemId())).forEach(item -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(item.getAttachName()));
                comboItem.setValue(item.getAttItemId().toString());
                comboItems.add(comboItem);
            });
            customParams.put("opFileId", attachBase.getPkValue());
            customParams.put("oldTypeId", currentRowEntity.getLong("attachtypeid"));
            customParams.put("typeItemList", JSON.toJSONString(comboItems));
            parameter.setCaption(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b", (String)"AttachTypePanelEdit_3", (String)"bos-ext-tmc", (Object[])new Object[0]));
        }
        parameter.setCustomParams(customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
        view.showForm(parameter);
    }

    private void previewFile() {
        int rowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex = model.getEntryCurrentRowIndex("entryentity"));
        DynamicObject attachBase = entryRowEntity.getDynamicObject("attach");
        if (EmptyUtil.isEmpty(attachBase)) {
            return;
        }
        this.getView().previewAttachment(AttachTypeHelper.getInstance().getFileInfo(attachBase));
    }

    private void downloadFile() {
        int rowIndex;
        IDataModel model = this.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex = model.getEntryCurrentRowIndex("entryentity"));
        DynamicObject attachBase = entryRowEntity.getDynamicObject("attach");
        if (EmptyUtil.isEmpty(attachBase)) {
            return;
        }
        String downloadUrl = UrlService.getAttachmentDownloadUrl((String)attachBase.getString("url"));
        this.getView().openUrl(downloadUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAllAttachments() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        HashSet attachIdSet = new HashSet(10);
        entries.forEach(entry -> {
            DynamicObjectCollection attaches = entry.getDynamicObjectCollection("attachment");
            if (EmptyUtil.isNoEmpty(attaches)) {
                attachIdSet.addAll(attaches.stream().map(att -> att.getLong("fbasedataid_id")).collect(Collectors.toSet()));
            }
        });
        if (EmptyUtil.isEmpty(attachIdSet)) {
            return;
        }
        DynamicObjectCollection attachmentList = QueryServiceHelper.query((String)"bd_attachment", (String)"name,url", (QFilter[])new QFilter("id", "in", (Object)attachIdSet.toArray()).toArray());
        if (EmptyUtil.isEmpty(attachmentList)) {
            return;
        }
        ArrayList attachments = new ArrayList(10);
        attachmentList.forEach(attachment -> {
            BatchDownloadRequest.File file = new BatchDownloadRequest.File(attachment.getString("name"), attachment.getString("url"));
            attachments.add(file);
        });
        BatchDownloadRequest.Dir downloadDir = new BatchDownloadRequest.Dir("attachment");
        BatchDownloadRequest.File[] files = attachments.toArray(new BatchDownloadRequest.File[attachments.size()]);
        downloadDir.setFiles(files);
        BatchDownloadRequest bdr = new BatchDownloadRequest("downloadall");
        bdr.setDirs(new BatchDownloadRequest.Dir[]{downloadDir});
        FileService fs = FileServiceFactory.getAttachmentFileService();
        FileOutputStream out = null;
        FileInputStream input = null;
        String url = "";
        try {
            File file = File.createTempFile("attachment", ".zip");
            out = new FileOutputStream(file);
            input = new FileInputStream(file);
            String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36";
            fs.batchDownload(bdr, (OutputStream)out, userAgent);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            url = cache.saveAsUrl(file.getName(), (InputStream)input, 120);
            this.close(out);
            this.close(input);
        }
        catch (Exception e) {
            try {
                LOGGER.error("AttachTypePanelEdit downloadAllAttachments error.", (Throwable)e);
                this.close(out);
                this.close(input);
            }
            catch (Throwable throwable) {
                this.close(out);
                this.close(input);
                throw throwable;
            }
        }
        if (EmptyUtil.isNoEmpty(url)) {
            view.download(url);
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isFromAuditFlow() {
        FormShowParameter parentFormShowParameter = this.getParentViewNoPlugin().getFormShowParameter();
        Map customParams = parentFormShowParameter.getCustomParams();
        return StringUtils.equalsIgnoreCase((CharSequence)customParams.getOrDefault("SCENE", ""), (CharSequence)"AUDITFLOW");
    }
}

