/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.validation.TransferBillValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GenerateTransferBillOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(GenerateTransferBillOpAction.class);
    private Map<String, Object> checkParam = null;
    private List<Object> successList = null;
    private List<Long> ids = new ArrayList<Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TransferBillValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String billIds = (String)this.getOption().getVariables().get("billIds");
        if (billIds != null) {
            this.ids = (List)SerializationUtils.fromJsonString((String)billIds, List.class);
        }
        if ((dataEntities = e.getDataEntities()) == null || dataEntities.length < 1 || this.ids.isEmpty()) {
            return;
        }
        String formId = dataEntities[0].getDynamicObjectType().getName();
        log.info("scmc-pm: VMIService.checkGenerateTransferBill param --> " + formId + this.ids);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"VMIService", (String)"checkGenerateTransferBill", (Object[])new Object[]{formId, this.ids});
        if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue() && result.get("message") instanceof String && StringUtils.isNotBlank(result.get("message"))) {
            String message = (String)result.get("message");
            log.info("scmc-pm: VMIService.checkGenerateTransferBill failure --> " + message);
            e.setCancel(Boolean.TRUE.booleanValue());
            e.setCancelMessage(message);
        } else if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && ((Boolean)result.get("success")).booleanValue() && result.get("checkparam") instanceof Map) {
            this.checkParam = (Map)result.get("checkparam");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1 || this.ids.isEmpty()) {
            return;
        }
        ArrayList<Long> canPushTatgetBillIds = new ArrayList<Long>(10);
        for (DynamicObject bill : dataEntities) {
            Long billId = (Long)bill.getPkValue();
            if (!"C".equals(bill.get("billstatus")) || !this.ids.contains(billId)) continue;
            canPushTatgetBillIds.add(billId);
        }
        if (canPushTatgetBillIds.isEmpty()) {
            return;
        }
        this.ids = canPushTatgetBillIds;
        String formId = dataEntities[0].getDynamicObjectType().getName();
        log.info("scmc-pm: VMIService.generateTransferBill param --> " + formId + this.ids);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"VMIService", (String)"generateTransferBill", (Object[])new Object[]{formId, this.ids, this.checkParam});
        if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue() && result.get("message") instanceof String && StringUtils.isNotBlank(result.get("message"))) {
            String message = (String)result.get("message");
            log.info("scmc-pm: VMIService.generateTransferBill failure --> " + message);
            throw new KDBizException(message);
        }
        if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && ((Boolean)result.get("success")).booleanValue() && result.get("successlist") instanceof List) {
            this.successList = (List)result.get("successlist");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntitys();
        if (dataEntities == null || dataEntities.length < 1 || this.ids.isEmpty()) {
            return;
        }
        String formId = dataEntities[0].getDynamicObjectType().getName();
        log.info("scmc-pm: VMIService.deleteTransferBill param --> " + formId + this.ids);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"VMIService", (String)"deleteTransferBill", (Object[])new Object[]{formId, this.ids, null});
        if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue() && result.get("message") instanceof String && StringUtils.isNotBlank(result.get("message"))) {
            log.error("scmc-pm: VMIService.deleteTransferBill failure --> " + result.get("message"));
        }
    }
}

