/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule.asyncop.ctautopush;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtAutoPushECOpAction
extends AbstractOpBizRuleAction {
    public static final String CLOUD_ID = "scmc";
    public static final String APP_ID = "iscc";
    public static final String RECORD_SERVICE = "CtAutoPushRecordService";
    public static final String RECORD_SERVICE_METHOD = "genAutoPushRecord";
    public static final String AUTO_PUSH_EC_SERVICE = "CtAutoPushService";
    public static final String SCENES_CODE = "iscc_ct_autopush";
    public static final String BILL_ID = "billId";
    public static final String PUSH_PARAM = "pushParam";
    private static final Log log = LogFactory.getLog(CtAutoPushECOpAction.class);

    private static void execute(String dbRoute, List<String> businessInfo, Param param) throws Exception {
        ECGlobalSession.begin((String)SCENES_CODE, (DBRoute)DBRoute.of((String)dbRoute), (Propagation)Propagation.REQUIRES_NEW);
        ECGlobalSession.register((String)CLOUD_ID, (String)APP_ID, (String)AUTO_PUSH_EC_SERVICE, (Param)param);
        ECGlobalSession.setBusinessType((String)"CtAutoPushECOpAction");
        if (CollectionUtils.isNotEmpty(businessInfo)) {
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.setAsync((boolean)true);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String entityTypeName = this.billEntityType.getName();
        DynamicObject[] dataEntities = e.getDataEntities();
        List ids = Stream.of(dataEntities).map(bill -> (Long)bill.getPkValue()).collect(Collectors.toList());
        List pushParamList = (List)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)RECORD_SERVICE, (String)RECORD_SERVICE_METHOD, (Object[])new Object[]{entityTypeName, ids, RequestContext.get().getTraceId(), RequestContext.get().getCurrUserId()});
        if (pushParamList == null || pushParamList.isEmpty()) {
            log.info("\u8c03\u7528CtAutoPushRecordService\u83b7\u53d6\u5230\u7684\u4e0b\u63a8\u53c2\u6570\u4e3a\u7a7a\u3002");
            return;
        }
        log.info("\u8c03\u7528CtAutoPushService\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u6267\u884c\u81ea\u52a8\u4e0b\u63a8\u5f00\u59cb\uff0c\u8c03\u7528\u53c2\u6570\u5927\u5c0f\uff1a", (Object)pushParamList.size());
        String routeKey = this.billEntityType.getDBRouteKey();
        try {
            for (Map param : pushParamList) {
                Object billId = param.get(BILL_ID);
                Object pushParam = param.get(PUSH_PARAM);
                List<String> businessInfo = Collections.singletonList(entityTypeName + "#" + billId);
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)PUSH_PARAM, pushParam);
                CtAutoPushECOpAction.execute(routeKey, businessInfo, (Param)commonParam);
            }
        }
        catch (Exception exception) {
            log.error("\u8c03\u7528CtAutoPushService\u6700\u7ec8\u4e00\u81f4\u6027\u670d\u52a1\u6267\u884c\u81ea\u52a8\u4e0b\u63a8\u5f02\u5e38\uff1a", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

