/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.paycontrol.validation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;

public class AdvancePaymentValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(AdvancePaymentValidator.class);
    private static final String ENTITY_SALORDERBILL = "sm_salorder";
    private static final String ENTITY_DELIVERNOTICE = "sm_delivernotice";
    private static final String ENTITY_SALOUTBILL = "im_saloutbill";
    private static final String ENTITY_CONTROLSETTING = "sm_delcontrolsetting";
    private static String MSBD_DBPARAM_EENTITY = "msbd_dbparam";
    private static String SBS_BILLFIELDMAPPING = "sbs_billfieldmapping";
    private static final String REC_PLAN_ENTRY = "recplanentry";
    private static final Map<String, String> entityToEntryKeyMap = new HashMap<String, String>(4);
    private static final Map<String, Long> entityToTableIdMap = new HashMap<String, Long>(2);

    public Set<String> preparePropertys() {
        Set fieldKeys = super.preparePropertys();
        fieldKeys.add("recplanentry.r_needrecadvance");
        fieldKeys.add("recplanentry.r_recamount");
        fieldKeys.add("recplanentry.r_controlsend");
        fieldKeys.add("recplanentry.r_recadvanceamount");
        fieldKeys.add("recplanentry.r_recadvanceamount");
        fieldKeys.add("ischargeoff");
        fieldKeys.add("invscheme");
        fieldKeys.add("billentry");
        fieldKeys.add("billentry_lk");
        fieldKeys.add("billentry_lk_sbillid");
        fieldKeys.add("billentry_lk_sid");
        fieldKeys.add("billentry_lk_stableid");
        fieldKeys.add("billentry.amountandtax");
        fieldKeys.add("billentry.srcbillid");
        fieldKeys.add("billentry.srcbillentryid");
        return fieldKeys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String entityNumber = this.entityKey;
        QFilter qFilter = new QFilter("key", "=", (Object)"payment_control_extbill");
        try {
            String paramValue;
            DynamicObject dbParam = BusinessDataServiceHelper.loadSingleFromCache((String)MSBD_DBPARAM_EENTITY, (QFilter[])qFilter.toArray());
            if (dbParam != null && (paramValue = dbParam.getString("value")).contains(entityNumber)) {
                return;
            }
        }
        catch (Exception e) {
            logger.error("msbd_dbparam query error", (Throwable)e);
            return;
        }
        try {
            if (ENTITY_SALORDERBILL.equals(entityNumber)) {
                this.doSalOrderControlValid();
            } else {
                this.doOtherControlValid(entityNumber);
            }
        }
        catch (Exception e) {
            logger.error("controlValid error", (Throwable)e);
            return;
        }
    }

    private void doOtherControlValid(String entityNumber) {
        String entryKey = this.getLinkEntryKey(entityNumber);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Optional<EntityType> lk = dataEntityType.getAllEntities().values().stream().filter(e -> e instanceof LinkEntryType).filter(e -> Objects.equals(e.getParent().getName(), entryKey)).findFirst();
        if (lk.isPresent()) {
            String entryLkKey = lk.get().getName();
            if (StringUtils.isBlank((CharSequence)entryLkKey)) {
                return;
            }
            String sBillIdKey = this.getLkKey(entryLkKey, "sbillid");
            String sIdKey = this.getLkKey(entryLkKey, "sid");
            String sTableIdKey = this.getLkKey(entryLkKey, "stableid");
            ExtendedDataEntity[] extDatas = this.getDataEntities();
            List newExtDatas = Arrays.stream(extDatas).collect(Collectors.toList());
            boolean isNegativeBill = false;
            if (this.isSalOutBill() && newExtDatas.size() == 1) {
                DynamicObject dataEntity = extDatas[0].getDataEntity();
                isNegativeBill = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"DeliverControlService", (String)"isNegativeBill", (Object[])new Object[]{dataEntity.getLong("invscheme.id"), dataEntity.getBoolean("ischargeoff")});
            }
            boolean finalIsNegativeBill = isNegativeBill;
            List collect = newExtDatas.stream().flatMap(s -> this.packageDataInfo((ExtendedDataEntity)s, entryKey, entryLkKey, sBillIdKey, sIdKey, sTableIdKey, finalIsNegativeBill)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                logger.info("AdvancePaymentValidator: linkData is empty, entryKey -> {}", (Object)entryKey);
                return;
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"DeliverControlService", (String)"executeOpRecController", (Object[])new Object[]{this.getEntityKey(), this.getValidateContext().getOperateName(), collect});
            if (result != null) {
                for (ExtendedDataEntity extData : extDatas) {
                    Object pkValue = extData.getDataEntity().getPkValue();
                    String errorMsg = (String)result.get(pkValue);
                    if (errorMsg == null || !StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                    this.addFatalErrorMessage(extData, errorMsg);
                }
            }
        } else {
            logger.error("not link entry error");
            return;
        }
    }

    private String getLinkEntryKey(String entityNumber) {
        String entryKey = entityToEntryKeyMap.get(entityNumber);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            QFilter qFilter = new QFilter("targetobj", "=", (Object)ENTITY_CONTROLSETTING);
            qFilter.and("sourcebill", "=", (Object)entityNumber);
            qFilter.and("isenable", "=", (Object)true);
            DynamicObject mapping = BusinessDataServiceHelper.loadSingleFromCache((String)SBS_BILLFIELDMAPPING, (QFilter[])qFilter.toArray());
            if (mapping != null) {
                DynamicObjectCollection colsmap = mapping.getDynamicObjectCollection("colsmap");
                if (colsmap == null || colsmap.isEmpty()) {
                    return null;
                }
                for (DynamicObject row : colsmap) {
                    String sourceField = row.getString("targetobjcol");
                    if (!"billentry".equals(sourceField)) continue;
                    String sourceBillCol = row.getString("sourcebillcol");
                    entityToEntryKeyMap.put(entityNumber, sourceBillCol);
                    return sourceBillCol;
                }
            }
        }
        return entryKey;
    }

    private Stream<Map<String, Object>> packageDataInfo(ExtendedDataEntity extendedDataEntity, String entryKey, String entryLkKey, String sBillIdKey, String sIdKey, String sTableIdKey, boolean isNegativeBill) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(entryKey);
        return rows.stream().map(s -> this.packageRowInfo((DynamicObject)s, entryLkKey, sBillIdKey, sIdKey, sTableIdKey, dataEntity.getLong("id"), isNegativeBill)).filter(Objects::nonNull);
    }

    private Map<String, Object> packageRowInfo(DynamicObject row, String entryLkKey, String sBillIdKey, String sIdKey, String sTableIdKey, Long billId, boolean isNegativeBill) {
        DynamicObjectCollection lkRows = null;
        Long entryId = row.getLong("id");
        if (row.containsProperty(entryLkKey)) {
            lkRows = row.getDynamicObjectCollection(entryLkKey);
        }
        if (lkRows == null || lkRows.isEmpty()) {
            if (this.isSalOutBill() && billId != null && billId != 0L) {
                ArrayList<BFRowId> bfRowIds = new ArrayList<BFRowId>(1);
                BFRowId bfRowId = new BFRowId(null, Long.valueOf(row.getLong("srcbillid")), entityToTableIdMap.get(ENTITY_SALOUTBILL), Long.valueOf(row.getLong("srcbillentryid")));
                bfRowIds.add(bfRowId);
                return this.buildRowInfo(bfRowIds, this.getAmountAndTax(row, isNegativeBill), entryId, billId);
            }
            return null;
        }
        List<BFRowId> bfRowIds = lkRows.stream().map(s -> this.packageLkRowInfo((DynamicObject)s, sBillIdKey, sIdKey, sTableIdKey)).collect(Collectors.toList());
        return this.buildRowInfo(bfRowIds, this.getAmountAndTax(row, isNegativeBill), entryId, billId);
    }

    private boolean isSalOutBill() {
        return ENTITY_SALOUTBILL.equals(this.entityKey);
    }

    private Map<String, Object> buildRowInfo(List<BFRowId> bfRowIds, BigDecimal amountAndTax, Long entryId, Long billId) {
        HashMap<String, Object> rowInfo = new HashMap<String, Object>(4);
        rowInfo.put("bfRowIds", bfRowIds);
        rowInfo.put("amount", amountAndTax);
        rowInfo.put("rowId", entryId);
        rowInfo.put("billId", billId);
        return rowInfo;
    }

    private BigDecimal getAmountAndTax(DynamicObject row, boolean isNegativeBill) {
        if ("delete".equals(this.getOperateKey())) {
            return BigDecimal.ZERO;
        }
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (row.containsProperty("amountandtax")) {
            amountAndTax = row.getBigDecimal("amountandtax");
            if (isNegativeBill) {
                amountAndTax = amountAndTax.abs().negate();
            }
        }
        return amountAndTax;
    }

    private BFRowId packageLkRowInfo(DynamicObject lkRow, String sBillIdKey, String sIdKey, String sTableIdKey) {
        BFRowId bfRowId = new BFRowId();
        bfRowId.setBillId(Long.valueOf(lkRow.getLong(sBillIdKey)));
        bfRowId.setEntryId(Long.valueOf(lkRow.getLong(sIdKey)));
        bfRowId.setTableId(Long.valueOf(lkRow.getLong(sTableIdKey)));
        return bfRowId;
    }

    private String getLkKey(String entryLkKey, String suffix) {
        return entryLkKey + "_" + suffix;
    }

    private void doSalOrderControlValid() {
        for (ExtendedDataEntity data : this.getDataEntities()) {
            DynamicObject validData = data.getDataEntity();
            DynamicObjectCollection recPlanEntry = validData.getDynamicObjectCollection(REC_PLAN_ENTRY);
            if (recPlanEntry == null || recPlanEntry.isEmpty()) continue;
            boolean isContainControl = false;
            BigDecimal totalRecAmount = BigDecimal.ZERO;
            BigDecimal recAdvanceAmount = BigDecimal.ZERO;
            for (DynamicObject recPlanRow : recPlanEntry) {
                if (!recPlanRow.getBoolean("r_needrecadvance")) continue;
                totalRecAmount = totalRecAmount.add(recPlanRow.getBigDecimal("r_recamount"));
                if (!ENTITY_SALORDERBILL.equals(recPlanRow.getString("r_controlsend"))) continue;
                isContainControl = true;
                recAdvanceAmount = recPlanRow.getBigDecimal("r_recadvanceamount");
            }
            if (!isContainControl || totalRecAmount.compareTo(recAdvanceAmount) >= 0) continue;
            String salOrderBillNo = validData.getString("billno");
            logger.info("doSalOrderControlValid false,salOrderBillNo -> {},totalRecAmount -> {},recAdvanceAmount -> {}", new Object[]{salOrderBillNo, totalRecAmount, recAdvanceAmount});
            String message = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u7684\u6536\u6b3e\u8ba1\u5212\uff0c\u901a\u8fc7\u9884\u6536\u63a7\u5236\u53d1\u8d27\uff0c\u8ba2\u5355{0}\u5173\u8054\u5df2\u6536\u91d1\u989d\u5408\u8ba1{1}\u5c0f\u4e8e\u5e94\u6536\u91d1\u989d{2}\uff0c\u4e0d\u5141\u8bb8{3}\u3002", (String)"SM-W-016553", (String)"bos-ext-scmc", (Object[])new Object[]{salOrderBillNo, totalRecAmount, recAdvanceAmount, this.getOperationName()});
            this.addFatalErrorMessage(data, message);
        }
    }

    static {
        entityToEntryKeyMap.put(ENTITY_DELIVERNOTICE, "billentry");
        entityToEntryKeyMap.put(ENTITY_SALOUTBILL, "billentry");
        TableDefine salOutTable = EntityMetadataCache.loadTableDefine((String)ENTITY_SALOUTBILL, (String)"billentry");
        if (salOutTable != null) {
            entityToTableIdMap.put(salOutTable.getEntityNumber(), salOutTable.getTableId());
        }
    }
}

