/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.operation;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;

public class EntryRowOpSettingPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(EntryRowOpSettingPlugin.class);
    private static final String OP_TYPE = "OpType";
    private static final String ENTRY_FIELD_ITEMS = "entryfielditems";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String opType = (String)view.getFormShowParameter().getCustomParams().get(OP_TYPE);
        if ("entryrowsplitop".equals(opType)) {
            view.setVisible(Boolean.FALSE, new String[]{"batchfill", "copyrow"});
        } else if ("entryrowcopyop".equals(opType)) {
            view.setVisible(Boolean.FALSE, new String[]{"batchfill", "splitrow", "pluginname"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"copyrow", "splitrow", "pluginname"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entitynumber");
        String pluginName = (String)formShowParameter.getCustomParam("pluginname");
        String entryKey = (String)formShowParameter.getCustomParam("entrykey");
        String material = (String)formShowParameter.getCustomParam("material");
        String entityId = this.getEntityId(entityNumber);
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            logger.info("EntryRowOpSettingPlugin=====\u521d\u59cb\u5316\u9875\u9762\u5206\u5f55\u5931\u8d25: entityNumber = " + entityNumber + ", entityId\u4e3a\u7a7a.");
            return;
        }
        int entryFieldSize = this.setEntryFieldKey(entityId);
        IDataModel model = this.getModel();
        model.setValue("pluginname", (Object)pluginName);
        model.setValue("entrykey", (Object)entryKey);
        model.setValue("material", (Object)material);
        this.setConfigInfo(entryFieldSize);
    }

    private void setConfigInfo(int entryFieldSize) {
        List dataList = (List)this.getView().getFormShowParameter().getCustomParam("datalist");
        if (dataList == null || entryFieldSize == 0) {
            return;
        }
        HashMap<String, Map> paramMap = new HashMap<String, Map>(dataList.size());
        block0: for (Map map : dataList) {
            for (Map.Entry entrySet : map.entrySet()) {
                String key = (String)entrySet.getKey();
                if (!"currentmetadatakey".equals(key)) continue;
                Object value = entrySet.getValue();
                if (!(value instanceof String)) continue block0;
                paramMap.put((String)value, map);
                continue block0;
            }
        }
        IDataModel model = this.getModel();
        for (int i = 0; i < entryFieldSize; ++i) {
            String currentMetaDataKey = (String)model.getValue("currentmetadatakey", i);
            Map fieldInfo = (Map)paramMap.get(currentMetaDataKey);
            if (fieldInfo == null) continue;
            model.setValue("batchfill", fieldInfo.get("batchfill"), i);
            model.setValue("copyrow", fieldInfo.get("copyrow"), i);
            model.setValue("splitrow", fieldInfo.get("splitrow"), i);
        }
    }

    private int setEntryFieldKey(String entityId) {
        List entryFieldItems;
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getRootEntity().getItems();
        HashMap<String, Object> fieldItem = new HashMap<String, Object>(items.size());
        for (EntityItem item : items) {
            if (!(item instanceof EntryEntity)) continue;
            this.loadEntryEntityNode(item, fieldItem);
            break;
        }
        if ((entryFieldItems = (List)fieldItem.get(ENTRY_FIELD_ITEMS)) == null || entryFieldItems.isEmpty()) {
            return 0;
        }
        int size = entryFieldItems.size();
        this.getView().getModel().batchCreateNewEntryRow("entryentity", size);
        for (int i = 0; i < size; ++i) {
            Map map = (Map)entryFieldItems.get(i);
            this.getModel().setValue("currentmetadata", map.get(NAME), i);
            this.getModel().setValue("currentmetadatakey", map.get(NUMBER), i);
        }
        return size;
    }

    private String getEntityId(String number) {
        String entityId = "";
        if (StringUtils.isBlank((CharSequence)number)) {
            return entityId;
        }
        String sql = "SELECT FID FROM t_meta_entitydesign WHERE FNUMBER= ?";
        List formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{number}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(EntryRowOpSettingPlugin.ID, rs.getString("FID"));
                    list.add(map);
                }
                return list;
            }
        });
        if (formList != null && formList.size() > 0) {
            entityId = (String)((Map)formList.get(0)).get(ID);
        }
        return entityId;
    }

    private void loadEntryEntityNode(EntityItem<?> field, Map<String, Object> fieldItem) {
        EntryEntity entryField = (EntryEntity)field;
        List entryItems = entryField.getItems();
        String entryFieldKey = entryField.getKey();
        ArrayList<HashMap<String, Object>> entryNodeList = new ArrayList<HashMap<String, Object>>(entryItems.size());
        for (EntityItem entryItem : entryItems) {
            HashMap<String, Object> entryItemInfo = new HashMap<String, Object>(16);
            if (entryItem instanceof EntryEntity) {
                this.loadEntryEntityNode(entryItem, entryItemInfo);
            }
            if (entryItemInfo.get(ENTRY_FIELD_ITEMS) != null) {
                List entryfielditems = (List)entryItemInfo.get(ENTRY_FIELD_ITEMS);
                entryNodeList.addAll(entryfielditems);
            }
            entryItemInfo.put(ID, entryItem.getId());
            entryItemInfo.put(NUMBER, entryFieldKey + "." + entryItem.getKey());
            entryItemInfo.put(NAME, entryItem.getName().toString());
            entryNodeList.add(entryItemInfo);
        }
        fieldItem.put(ENTRY_FIELD_ITEMS, entryNodeList);
        fieldItem.put(ID, field.getId());
        fieldItem.put(NUMBER, field.getKey());
        fieldItem.put(NAME, field.getName().toString());
    }
}

