/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.tpl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;

public class FieldSelectPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnreset"});
    }

    public void afterCreateNewData(EventObject e) {
        String currentNumber = (String)this.getView().getFormShowParameter().getCustomParam("currentnumber");
        if (StringUtils.isBlank((CharSequence)currentNumber)) {
            return;
        }
        String sql = "SELECT FID FROM t_meta_entitydesign WHERE FNUMBER= ?";
        List formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{currentNumber}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rs.getString("FID"));
                    list.add(map);
                }
                return list;
            }
        });
        String entityId = "";
        if (formList != null && formList.size() > 0) {
            entityId = (String)((Map)formList.get(0)).get("id");
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List fields = entityMetadata.getRootEntity().getItems();
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>(fields.size());
        for (EntityItem field : fields) {
            HashMap<String, Object> fieldItem = new HashMap<String, Object>();
            if (field instanceof EntryEntity) {
                this.loadEntryEntityNode(field, fieldItem);
            } else {
                fieldItem.put("id", field.getId());
                fieldItem.put("number", field.getKey());
                fieldItem.put("name", field.getName().toString());
            }
            nodeList.add(fieldItem);
        }
        TreeView tree = (TreeView)this.getView().getControl("fieldtree");
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setLongNumber(entityMetadata.getKey());
        root.setText(entityMetadata.getName().toString());
        root.setIsOpened(true);
        tree.addNode(this.setTreeNode(root, nodeList, entityMetadata.getId()));
        this.getPageCache().put("fieldtree", SerializationUtils.toJsonString((Object)root));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnreset".equals(key)) {
            this.reset();
        } else if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void loadEntryEntityNode(EntityItem<?> field, Map<String, Object> fieldItem) {
        EntryEntity entryField = (EntryEntity)field;
        List entryItems = entryField.getItems();
        ArrayList<HashMap<String, Object>> entryNodeList = new ArrayList<HashMap<String, Object>>(entryItems.size());
        for (EntityItem entryItem : entryItems) {
            HashMap<String, Object> entryItemInfo = new HashMap<String, Object>();
            if (entryItem instanceof EntryEntity) {
                this.loadEntryEntityNode(entryItem, entryItemInfo);
            }
            entryItemInfo.put("id", entryItem.getId());
            entryItemInfo.put("number", entryItem.getKey());
            entryItemInfo.put("name", entryItem.getName().toString());
            entryNodeList.add(entryItemInfo);
        }
        fieldItem.put("entryfielditems", entryNodeList);
        fieldItem.put("id", field.getId());
        fieldItem.put("number", field.getKey());
        fieldItem.put("name", field.getName().toString());
    }

    private TreeNode setTreeNode(TreeNode root, List<Map<String, Object>> rootNodeList, String rootNodeId) {
        for (Map<String, Object> map : rootNodeList) {
            TreeNode node = new TreeNode();
            if (map.get("entryfielditems") != null) {
                TreeNode entityNode = new TreeNode();
                entityNode.setParentid(rootNodeId);
                entityNode.setId((String)map.get("id"));
                entityNode.setLongNumber((String)map.get("number"));
                entityNode.setText((String)map.get("name"));
                entityNode.setIsOpened(true);
                root.addChild(entityNode);
                String entryHeadId = (String)map.get("id");
                List entryNodeList = (List)map.get("entryfielditems");
                this.setTreeNode(entityNode, entryNodeList, entryHeadId);
                continue;
            }
            node.setParentid(rootNodeId);
            node.setId((String)map.get("id"));
            node.setLongNumber((String)map.get("number"));
            node.setText((String)map.get("name"));
            root.addChild(node);
        }
        return root;
    }

    private void returnData() {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("fieldtree"), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("fieldtree");
        String id = tree.getTreeState().getFocusNodeId();
        TreeNode node = root.getTreeNode(id, 5);
        int nodeLevel = root.getNodeLevel(id, 0);
        HashMap returnData = new HashMap();
        HashMap<String, String> field = new HashMap<String, String>();
        String fieldName = node.getText();
        String fieldNumber = node.getLongNumber();
        for (int i = 1; i < nodeLevel; ++i) {
            String parentid = node.getParentid();
            node = root.getTreeNode(parentid, 5);
            fieldName = node.getText() + "." + fieldName;
            fieldNumber = node.getLongNumber() + "." + fieldNumber;
        }
        field.put("fieldname", fieldName);
        field.put("fieldkey", fieldNumber);
        returnData.put("field", field);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void reset() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("field", null);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

