/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.plugin.validation.ConditionHiddenPlugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.validation.CustValidation;
import kd.bos.metadata.entity.validation.CustValidationParamPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillExistValidatorEdit
extends CustValidationParamPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filter"});
        ((BasedataEdit)this.getControl("bizbillobj")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bizbillobj": {
                this.beforeSelectBizBillObj(e);
                break;
            }
        }
    }

    private void beforeSelectBizBillObj(BeforeF7SelectEvent e) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<String> number = new HashSet<String>(16);
        for (DynamicObject entry : entryEntity) {
            DynamicObject bizbillobj = entry.getDynamicObject("bizbillobj");
            if (bizbillobj == null) continue;
            number.add(bizbillobj.getString("number"));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("number", "not in", number));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "bizbillobj": {
                this.changeBizBillObj(e.getChangeSet());
                break;
            }
            case "filter": {
                this.changeFilter(e.getChangeSet());
            }
        }
    }

    private void changeFilter(ChangeData[] changeSet) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int i = changeData.getRowIndex();
            if (!StringUtils.isEmpty((CharSequence)((String)changeData.getNewValue()))) continue;
            model.setValue("filterstr", null, i);
            model.setValue("filterstr_tag", null, i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeBizBillObj(ChangeData[] changeDatas) {
        IDataModel model = this.getModel();
        model.beginInit();
        for (ChangeData changeData : changeDatas) {
            int i = changeData.getRowIndex();
            model.setValue("filter", null, i);
            model.setValue("filterstr", null, i);
            model.setValue("filterstr_tag", null, i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        String controlEventKey = ((Control)evt.getSource()).getKey();
        if ("filter".equals(controlEventKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object conditionJson = this.getModel().getValue("filterstr_tag", rowIndex);
            DynamicObject value = (DynamicObject)this.getModel().getValue("bizbillobj", rowIndex);
            if (value == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u5355\u636e\u201d\u3002", (String)"BOSEXT-W-688611", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_condition");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "condition"));
            showParameter.addCustPlugin(ConditionHiddenPlugin.class.getName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("formula", conditionJson);
            showParameter.getCustomParams().put("entitynumber", value.getString("number"));
            showParameter.getCustomParams().put("onlyheadfield", String.valueOf(true));
            this.getView().showForm(showParameter);
        }
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("condition".equals(e.getActionId())) {
            String returnData = (String)e.getReturnData();
            if (returnData == null) {
                return;
            }
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            IDataModel model = this.getModel();
            String exprTran = condition.getExprTran();
            model.setValue("filter", (Object)exprTran, rowIndex);
            if (StringUtils.isNotEmpty((CharSequence)exprTran)) {
                model.setValue("filterstr_tag", (Object)returnData, rowIndex);
            } else {
                model.setValue("filterstr_tag", null, rowIndex);
            }
        }
        super.closedCallBack(e);
    }

    protected void showValidation(CustValidation v) {
        List param = Collections.emptyList();
        String paramValue = v.getParameter();
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            param = (List)SerializationUtils.fromJsonString((String)paramValue, List.class);
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        for (Map paramEntry : param) {
            String billObjId = (String)paramEntry.get("billObjEntityId");
            if (StringUtils.isEmpty((CharSequence)billObjId)) continue;
            int i = model.createNewEntryRow("entryentity");
            DynamicObject entityObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_billmainentity");
            entityObj.set("id", (Object)billObjId);
            entityObj.set("number", paramEntry.get("billObjEntityNumber"));
            entityObj.set("name", paramEntry.get("billObjEntityName"));
            model.setValue("bizbillobj", (Object)entityObj, i);
            model.setValue("filter", paramEntry.get("filter"), i);
            model.setValue("filterstr_tag", paramEntry.get("filterstr_tag"), i);
        }
        model.endInit();
    }

    protected void returnValidation(CustValidation v) {
        ArrayList param = new ArrayList();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntity) {
            HashMap<String, String> mapParam = new HashMap<String, String>();
            DynamicObject bizObject = entry.getDynamicObject("bizbillobj");
            if (bizObject != null) {
                mapParam.put("billObjEntityId", bizObject.getString("id"));
                mapParam.put("billObjEntityNumber", bizObject.getString("number"));
                mapParam.put("billObjEntityName", bizObject.getString("name"));
                String filter = entry.getString("filter");
                mapParam.put("filter", filter);
                mapParam.put("filterstr_tag", entry.getString("filterstr_tag"));
            }
            param.add(mapParam);
        }
        String paramValue = SerializationUtils.toJsonString(param);
        v.setParameter(paramValue);
    }
}

