/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UpdateReserveMapping
extends AbstractOpBizRuleAction {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        Map<String, String> bizParams = this.getBizParams();
        String srcBillEntryId = bizParams.getOrDefault("srcbillentryid", "srcbillentryid");
        String srcBillId = bizParams.getOrDefault("srcbillid", "srcbillid");
        e.getFieldKeys().add(srcBillEntryId);
        e.getFieldKeys().add(srcBillId);
    }

    private Map<String, String> getBizParams() {
        String paramStr = this.getBizRule().getParameter();
        HashMap<String, String> params = null;
        try {
            params = (HashMap<String, String>)SerializationUtils.fromJsonString((String)paramStr, Map.class);
        }
        catch (Exception e) {
            params = new HashMap<String, String>();
            Log log = LogFactory.getLog(UpdateReserveMapping.class);
            log.error(String.format("\u914d\u7f6e\u53c2\u6570[%s]\u89e3\u6790\u5931\u8d25", paramStr), (Throwable)e);
        }
        return params;
    }

    private String getEntryFlag(String entityName, String srcBillEntryId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
        IDataEntityProperty pro = type.findProperty(srcBillEntryId);
        IDataEntityType parent = pro.getParent();
        if (parent instanceof EntryType) {
            return parent.getName();
        }
        return null;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        String entityName = datas[0].getDataEntityType().getName();
        Map<String, String> bizParams = this.getBizParams();
        String srcBillEntryId = bizParams.getOrDefault("srcbillentryid", "srcbillentryid");
        String srcBillId = bizParams.getOrDefault("srcbillid", "srcbillid");
        String billEntry = this.getEntryFlag(entityName, srcBillEntryId);
        if (billEntry == null) {
            this.handle4NoEntry(datas, srcBillEntryId, srcBillId, billEntry);
        } else {
            this.handle4HasEntry(datas, srcBillEntryId, srcBillId, billEntry);
        }
    }

    private void handle4NoEntry(DynamicObject[] datas, String srcBillEntryId, String srcBillId, String billEntry) {
        HashMap<Object, DynamicObject> entryMap = new HashMap<Object, DynamicObject>();
        DynamicObjectCollection reserveCols = this.getEntryReserve(datas);
        HashSet<Object> billIdSet = new HashSet<Object>();
        for (DynamicObject reserveCol : reserveCols) {
            billIdSet.add(reserveCol.get("billid"));
        }
        for (DynamicObject data : datas) {
            Object pkValue = data.getPkValue();
            if (billIdSet.contains(pkValue)) continue;
            entryMap.put(data.get(srcBillEntryId), data);
        }
        if (!entryMap.isEmpty()) {
            this.createReserveMaping(entryMap, entryMap);
        }
    }

    protected void handle4HasEntry(DynamicObject[] datas, String srcBillEntryId, String srcBillId, String billEntry) {
        HashMap<Object, List<DynamicObject>> entryMap = new HashMap<Object, List<DynamicObject>>();
        HashMap<Object, DynamicObject> entryParent = new HashMap<Object, DynamicObject>();
        Long zero = 0L;
        Object srcBillEntry = null;
        DynamicObjectCollection reserveCols = this.getEntryReserve(datas);
        HashSet<String> billKeySet = new HashSet<String>();
        for (DynamicObject reserveCol : reserveCols) {
            String entryKey = reserveCol.get("billid") + "_" + reserveCol.get("entryid");
            billKeySet.add(entryKey);
        }
        for (DynamicObject data : datas) {
            Object pkValue = data.getPkValue();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection(billEntry);
            for (DynamicObject entry : entrys) {
                String entryKey = pkValue + "_" + entry.getPkValue();
                if (billKeySet.contains(entryKey) || (srcBillEntry = entry.get(srcBillEntryId)) == null || zero.equals(srcBillEntry)) continue;
                ArrayList<DynamicObject> entryList = (ArrayList<DynamicObject>)entryMap.get(srcBillEntry);
                if (entryList == null) {
                    entryList = new ArrayList<DynamicObject>();
                    entryMap.put(srcBillEntry, entryList);
                }
                entryList.add(entry);
                entryParent.put(entry.get(srcBillEntryId), data);
            }
        }
        if (!entryMap.isEmpty()) {
            this.createReserveMaping4Entrys(entryMap, entryParent);
        }
    }

    private void createReserveMaping4Entrys(Map<Object, List<DynamicObject>> srcEntryIdMap, Map<Object, DynamicObject> entryParent) {
        QFilter fs = new QFilter("entryid", "in", srcEntryIdMap.keySet());
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)UpdateReserveMapping.class.getName(), (String)"sbs_entry_reserve", (String)"entryid,reserveid", (QFilter[])fs.toArray(), null);){
            ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>(srcEntryIdMap.size());
            Object srcEntryId = null;
            for (Row row : rows) {
                srcEntryId = row.get("entryid");
                List<DynamicObject> entrys = srcEntryIdMap.get(srcEntryId);
                if (entrys == null) continue;
                for (DynamicObject entry : entrys) {
                    newRecords.add(this.createReserve(row, entry, entryParent.get(srcEntryId)));
                }
            }
            this.saveReseveMaping(newRecords);
        }
    }

    private void saveReseveMaping(List<DynamicObject> newRecords) {
        if (newRecords == null || newRecords.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew((String)(((Object)((Object)this)).getClass().getName() + ".saveReseveMaping"));){
            try {
                SaveServiceHelper.save((DynamicObject[])newRecords.toArray(new DynamicObject[newRecords.size()]));
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(SCMCLang.reseveTransFail(e.getMessage()));
            }
        }
    }

    private void createReserveMaping(Map<Object, DynamicObject> srcEntryIdMap, Map<Object, DynamicObject> entryParent) {
        QFilter fs = new QFilter("entryid", "in", srcEntryIdMap.keySet());
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)UpdateReserveMapping.class.getName(), (String)"sbs_entry_reserve", (String)"entryid,reserveid", (QFilter[])fs.toArray(), null);){
            ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>(srcEntryIdMap.size());
            Object srcEntryId = null;
            for (Row row : rows) {
                srcEntryId = row.get("entryid");
                if (!srcEntryIdMap.containsKey(srcEntryId)) continue;
                newRecords.add(this.createReserve(row, srcEntryIdMap.get(srcEntryId), srcEntryIdMap.get(srcEntryId)));
            }
            this.saveReseveMaping(newRecords);
        }
    }

    private DynamicObject createReserve(Row row, DynamicObject entry, DynamicObject bill) {
        DynamicObject newRow = BusinessDataServiceHelper.newDynamicObject((String)"sbs_entry_reserve");
        newRow.set("entryid", entry.getPkValue());
        newRow.set("billid", bill.getPkValue());
        newRow.set("entity", (Object)bill.getDataEntityType().getName());
        newRow.set("type", (Object)"2");
        newRow.set("reserveid", row.get("reserveid"));
        return newRow;
    }

    private DynamicObjectCollection getEntryReserve(DynamicObject[] datas) {
        HashSet<Object> billIds = new HashSet<Object>(datas.length);
        for (DynamicObject data : datas) {
            Object pkValue = data.getPkValue();
            if (pkValue == null) continue;
            billIds.add(pkValue);
        }
        return QueryServiceHelper.query((String)"sbs_entry_reserve", (String)"entity,billid,entryid,reserveid", (QFilter[])new QFilter("billid", "in", billIds).toArray());
    }
}

