/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.mscommon;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.ext.scmc.reservation.validation.ReserveOperateErrorInfo;
import kd.bos.ext.scmc.reservation.validation.ReserveValidateResult;
import kd.bos.servicehelper.DispatchServiceHelper;

public class TerminalReleaseReserve
extends AbstractOpBizRuleAction {
    private OperationResult result;
    private boolean success;

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.result == null || StringUtils.isBlank((CharSequence)this.result.getMessage())) {
            return;
        }
        OperationResult op = this.getOperationResult();
        if (op.getSuccessPkIds().size() == 1 && op.getAllErrorOrValidateInfo().isEmpty()) {
            op.setMessage(this.result.getMessage());
            op.setShowMessage(true);
        } else if (!op.getSuccessPkIds().isEmpty()) {
            ReserveValidateResult reserveValidateResult = new ReserveValidateResult();
            ReserveOperateErrorInfo errInfo = new ReserveOperateErrorInfo();
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(this.result.getMessage());
            reserveValidateResult.addErrorInfo(errInfo);
            op.getValidateResult().addValidateError("releaseReserve", (ValidateResult)reserveValidateResult);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        boolean isIgnore = "true".equalsIgnoreCase(this.operateOption.getVariableValue("ismoperate", "false"));
        if (isIgnore) {
            this.success = false;
            this.result = new OperationResult();
            return;
        }
        String operationKey = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if (datas == null || datas.length == 0) {
            return;
        }
        final List<Object> ids = this.getIds(datas);
        final String name = datas[0].getDataEntityType().getName();
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onRollbacked() {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"UnAuditUnReleaseReserve", (Object[])new Object[]{name, JSON.toJSONString((Object)ids)});
            }
        });
        this.result = (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"terminalReleaseReserve", (Object[])new Object[]{name, ids, operationKey});
        this.success = true;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        if (this.success) {
            DynamicObject[] dataEntities = e.getDataEntitys();
            if (dataEntities == null || dataEntities.length == 0) {
                return;
            }
            Long[] ids = new Long[dataEntities.length];
            String billName = dataEntities[0].getDataEntityType().getName();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = dataEntities[i].getLong("id");
            }
            this.result = (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"UnAuditUnReleaseReserve", (Object[])new Object[]{billName, JSON.toJSONString((Object)ids)});
        }
    }

    private List<Object> getIds(DynamicObject[] datas) {
        ArrayList<Object> ids = new ArrayList<Object>(datas.length);
        for (DynamicObject data : datas) {
            ids.add(data.getPkValue());
        }
        return ids;
    }
}

