/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.threadpool;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import kd.bos.ext.scmc.threadpool.AbortPolicy;
import kd.bos.ext.scmc.threadpool.CallerRunsPolicy;
import kd.bos.ext.scmc.threadpool.DiscardOldestPolicy;
import kd.bos.ext.scmc.threadpool.DiscardPolicy;
import kd.bos.ext.scmc.threadpool.SCMCRejectedException;

public interface SCMCRejectedPolicy {
    public static final SCMCRejectedPolicy ABORT = new AbortPolicy();
    public static final SCMCRejectedPolicy CALLER_RUNS = new CallerRunsPolicy();
    public static final SCMCRejectedPolicy DISCARD_OLDEST = new DiscardOldestPolicy();
    public static final SCMCRejectedPolicy DISCARD = new DiscardPolicy();

    default public void executeRejected(Runnable task, SCMCRejectedException exc) {
        throw new RejectedExecutionException("Task " + exc.run.toString() + " rejected from " + exc.executor.toString());
    }

    default public <T> Future<T> submitRejected(Callable<T> task, SCMCRejectedException exc) {
        throw new RejectedExecutionException("Task " + exc.run.toString() + " rejected from " + exc.executor.toString());
    }
}

