/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DeleteTransferBillValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(DeleteTransferBillValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length < 1) {
            return;
        }
        List ids = new ArrayList(16);
        String billIds = (String)this.getOption().getVariables().get("billIds");
        if (billIds != null) {
            ids = (List)SerializationUtils.fromJsonString((String)billIds, List.class);
        }
        if (ids.isEmpty()) {
            return;
        }
        String formId = extendedDataEntities[0].getDataEntity().getDynamicObjectType().getName();
        log.info("scmc-pm: VMIService.checkDeleteTransferBill param --> " + formId + ids);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"VMIService", (String)"checkDeleteTransferBill", (Object[])new Object[]{formId, ids});
        log.info("\u8c03\u7528vmi\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + SerializationUtils.toJsonString((Object)result));
        if (result == null || result.isEmpty() || result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528VMI\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeleteTransferBillValidator_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        Object success = result.get("success");
        if (success instanceof Boolean && ((Boolean)success).booleanValue()) {
            Map billmapping;
            Object errormsgs = result.get("errormsg");
            if (errormsgs instanceof Map) {
                Map errormsgMap = (Map)errormsgs;
                for (ExtendedDataEntity dataEntitie : extendedDataEntities) {
                    DynamicObject bill = dataEntitie.getDataEntity();
                    Object pkValue = bill.getPkValue();
                    String msg = (String)errormsgMap.get(pkValue);
                    if (msg == null) continue;
                    this.addErrorMessage(dataEntitie, msg);
                }
            }
            List mutexedids = result.get("mutexedids") == null ? new ArrayList(10) : (List)result.get("mutexedids");
            Map map = billmapping = result.get("billmapping") == null ? new HashMap(10) : (Map)result.get("billmapping");
            if (!billmapping.isEmpty()) {
                this.getOption().setVariableValue("billmapping", SerializationUtils.toJsonString(billmapping));
            }
            if (!mutexedids.isEmpty()) {
                this.getOption().setVariableValue("mutexedids", SerializationUtils.toJsonString(mutexedids));
            }
        }
    }
}

