/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.QueryServiceHelper;

public class HSPMNewFileMenuPlugin
implements IPortalAppMenuExtService {
    private static final Log LOG = LogFactory.getLog(HSPMNewFileMenuPlugin.class);
    private static final String HSPM_APP_ID = "1WXBPN7+OHJZ";
    private static final String HAM_APP_ID = "1WXBRRPS+/I5";
    private static final String HDM_APP_ID = "1WX49GDDDZ0V";
    private static final String HTM_APP_ID = "1WTT6K3V3TD/";
    private static final String HPFS_SWITCH_NEW_FILE = "hpfs_switch_new_file";
    private static final Set<String> HSPM_OLD_MENU = new HashSet<String>(4);
    private static final Set<String> HAM_OLD_MENU = new HashSet<String>(4);
    private static final Set<String> HDM_OLD_MENU = new HashSet<String>(4);
    private static final Set<String> HTM_OLD_MENU = new HashSet<String>(4);
    private static final Set<String> HSPM_NEW_MENU = new HashSet<String>(4);
    private static final Set<String> HAM_NEW_MENU = new HashSet<String>(4);
    private static final Set<String> HDM_NEW_MENU = new HashSet<String>(4);
    private static final Set<String> HTM_NEW_MENU = new HashSet<String>(4);

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        try {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
            this.hideMenu(appIdAndMenuIdMap, result, HSPM_APP_ID);
            this.hideMenu(appIdAndMenuIdMap, result, HAM_APP_ID);
            this.hideMenu(appIdAndMenuIdMap, result, HDM_APP_ID);
            this.hideMenu(appIdAndMenuIdMap, result, HTM_APP_ID);
            return result;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private void hideMenu(Map<String, Set<String>> appIdAndMenuIdMap, Map<String, Set<String>> result, String hspmAppId) {
        Set<String> menu = appIdAndMenuIdMap.get(hspmAppId);
        if (!CollectionUtils.isEmpty(menu)) {
            DynamicObject configParam = QueryServiceHelper.queryOne((String)"hpfs_devconfig", (String)"businesskey,businessvalue", (QFilter[])new QFilter[]{new QFilter("businesskey", "=", (Object)HPFS_SWITCH_NEW_FILE)});
            result.put(hspmAppId, this.getHideMenu(configParam, hspmAppId));
        }
    }

    private Set<String> getHideMenu(DynamicObject configParam, String appId) {
        HashSet<String> needHideSet = new HashSet<String>(4);
        if (configParam != null) {
            String businessvalue = configParam.getString("businessvalue");
            if ("0".equals(businessvalue)) {
                if (HSPM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HSPM_NEW_MENU);
                } else if (HAM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HAM_NEW_MENU);
                } else if (HDM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HDM_NEW_MENU);
                } else if (HTM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HTM_NEW_MENU);
                }
            } else if ("1".equals(businessvalue)) {
                if (HSPM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HSPM_OLD_MENU);
                } else if (HAM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HAM_OLD_MENU);
                } else if (HDM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HDM_OLD_MENU);
                } else if (HTM_APP_ID.equals(appId)) {
                    needHideSet.addAll(HTM_OLD_MENU);
                }
            }
        }
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        return appMenusInfoByAppId.stream().filter(appMenusInfo -> needHideSet.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getId).collect(Collectors.toSet());
    }

    static {
        HSPM_OLD_MENU.add("hspm_multiviewconfig");
        HSPM_OLD_MENU.add("hspm_multiviewconfigemp");
        HSPM_OLD_MENU.add("hspm_erfilelist");
        HAM_OLD_MENU.add("ham_ermanfilelist");
        HDM_OLD_MENU.add("hspm_parttimefilelist");
        HTM_OLD_MENU.add("htm_erfilelist");
        HSPM_NEW_MENU.add("hspm_erfilelistreform");
        HSPM_NEW_MENU.add("hspm_fileviewconfig");
        HSPM_NEW_MENU.add("hspm_fileviewconfigmob");
        HAM_NEW_MENU.add("ham_ermanfilereformlist");
        HDM_NEW_MENU.add("hdm_partfilereformlist");
        HTM_NEW_MENU.add("htm_erfilereformlist");
    }
}

