/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.field;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.hr.metadata.edit.MulQueryEdit;
import kd.bos.ext.hr.metadata.field.IQueryField;
import kd.bos.ext.hr.metadata.prop.MulQueryProp;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;

public class MulQueryField
extends MulBasedataField
implements IQueryField {
    String editSearchProp;
    String displayProp;
    String listModel = "list";
    boolean preciseSearch = false;
    String treeFormId;
    String billFormId;
    List<Plugin> basedataControllers = Lists.newArrayListWithExpectedSize((int)4);
    private static final long serialVersionUID = -2421227170858625971L;

    @SimplePropertyAttribute(name="EditSearchProp")
    public String getEditSearchProp() {
        return this.editSearchProp;
    }

    public void setEditSearchProp(String editSearchProp) {
        this.editSearchProp = editSearchProp;
    }

    @SimplePropertyAttribute(name="DisplayProp")
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    @SimplePropertyAttribute(name="listModel")
    public String getListModel() {
        return this.listModel;
    }

    public void setListModel(String listModel) {
        this.listModel = listModel;
    }

    @SimplePropertyAttribute(name="preciseSearch")
    public boolean isPreciseSearch() {
        return this.preciseSearch;
    }

    public void setPreciseSearch(boolean preciseSearch) {
        this.preciseSearch = preciseSearch;
    }

    @SimplePropertyAttribute(name="treeFormId")
    public String getTreeFormId() {
        return this.treeFormId;
    }

    public void setTreeFormId(String treeFormId) {
        this.treeFormId = treeFormId;
    }

    @SimplePropertyAttribute(name="billFormId")
    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    @CollectionPropertyAttribute(name="BasedataControllers", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getBasedataControllers() {
        return this.basedataControllers;
    }

    public void setBasedataControllers(List<Plugin> basedataControllers) {
        this.basedataControllers = basedataControllers;
    }

    protected FieldEdit createServerEditor() {
        MulQueryEdit mulQueryEdit = new MulQueryEdit();
        mulQueryEdit.setListModel(this.listModel);
        mulQueryEdit.setTreeFormId(this.treeFormId);
        mulQueryEdit.setBillFormId(this.billFormId);
        mulQueryEdit.setDisplayProp(this.displayProp);
        mulQueryEdit.setEditSearchProp(this.editSearchProp);
        mulQueryEdit.setPreciseSearch("list".equals(this.listModel) && this.preciseSearch);
        mulQueryEdit.setBasedataControllers(this.basedataControllers);
        return mulQueryEdit;
    }

    public Map<String, Object> createEditor() {
        Map ctlRet = super.createEditor();
        return this.createQueryEditor(this.getBaseEntityId(), ctlRet, this.getDisplayProp(), this.getEditSearchProp());
    }

    private void fieldSetDynamicProperty(MulBasedataProp prop) {
        prop.setName(this.getKey());
        prop.setDisplayName(this.getName());
        prop.setAlias(this.getFieldName() == null ? "" : this.getFieldName());
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getFieldName()));
        prop.setFeatures(this.getFeatures().getValue());
        prop.setGroupControl(this.isGroupControl());
        prop.setCompareTypeConfig(this.getCompareTypeConfig());
    }

    protected void setDynamicProperty(MulBasedataProp prop) {
        Field field;
        this.fieldSetDynamicProperty(prop);
        prop.setAlias(this.getTableName());
        prop.setDbIgnore(StringUtils.isBlank((CharSequence)this.getTableName()));
        String name = (String)prop.getDisplayName().getDefaultItem();
        prop.setOrgFunc(this.getOrgFuncs());
        if (this.getBaseEntityId() != null) {
            String number = MetadataDao.getEntityNumberById((String)this.getBaseEntityId());
            if (number == null) {
                this.addBuildError(2, "BaseEntityId", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u67e5\u8be2\u5b9e\u4f53\u201d\u4e0d\u5b58\u5728\u3002", (String)"MulQueryField_0", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            }
            prop.setBaseEntityId(number);
            prop.setMustInput(this.isMustInput());
            if (this.getDisplayProp() == null) {
                this.addBuildError(2, "BaseEntityId", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MulQueryField_2", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            } else {
                prop.setDisplayProp(this.getDisplayProp());
                prop.setEditSearchProp(this.getEditSearchProp());
            }
            this.checkBillFormId(name, number);
        } else {
            this.baseEntityIdNonTip(name);
        }
        if (!StringUtils.isBlank((CharSequence)this.getOrgFieldId()) && (field = this.entityMetadata.getFieldById(this.getOrgFieldId())) != null) {
            prop.setOrgProp(field.getKey().toLowerCase());
        }
        prop.setShowUsed(this.isShowUsed());
    }

    protected void checkBillFormId(String name, String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)this.getBillFormId())) {
            FormConfig fromConfig;
            try {
                fromConfig = FormMetadataCache.getFormConfig((String)this.billFormId);
            }
            catch (Exception e) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u4e0d\u5b58\u5728\u3002", (String)"MulQueryField_3", (String)"bos-ext-hr", (Object[])new Object[0]), name));
                return;
            }
            if (null == fromConfig) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u4e0d\u5b58\u5728\u3002", (String)"MulQueryField_3", (String)"bos-ext-hr", (Object[])new Object[0]), name));
                return;
            }
            if (fromConfig.getModelType().equals("list") && !fromConfig.getEntityTypeId().equals(entityNumber)) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u5173\u8054\u5b9e\u4f53\u4e0e\u67e5\u8be2\u5b9e\u4f53\u4e0d\u4e00\u81f4\u3002", (String)"MulQueryField_4", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            }
        }
    }

    protected void baseEntityIdNonTip(String fieldName) {
        this.addBuildError(2, "BaseEntityId", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u67e5\u8be2\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MulQueryField_1", (String)"bos-ext-hr", (Object[])new Object[0]), fieldName));
    }

    protected void setServerEditorProperties(FieldEdit editor) {
        editor.setFieldKey(this.getKey());
        MulQueryEdit be = (MulQueryEdit)editor;
        be.setDisplayProp(this.getDisplayProp());
        if ("ReportFilterModel".equalsIgnoreCase(this.entityMetadata.getModelType()) || "ReportFormModel".equalsIgnoreCase(this.entityMetadata.getModelType())) {
            be.setShowUsed(false);
        } else {
            be.setShowUsed(this.isShowUsed());
        }
        be.setShowFrequent(this.isShowFrequent());
    }

    protected MulQueryProp createDynamicProperty() {
        DynamicObjectType type = new DynamicObjectType(this.getKey());
        type.setAlias(this.getTableName());
        type.setDbIgnore(StringUtils.isBlank((CharSequence)this.getTableName()));
        type.setDBRouteKey(StringUtils.isNotBlank((CharSequence)this.getTableName()) ? this.entityMetadata.getDBRouteKey() : "");
        this.registerProperties(type);
        MulQueryProp prop = new MulQueryProp(this.getKey(), type);
        prop.setMustInput(this.isMustInput());
        return prop;
    }

    protected void registerProperties(DynamicObjectType type) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        if (this.getBaseEntityId() != null) {
            QueryProp baseProp = new QueryProp();
            String number = MetadataDao.getEntityNumberById((String)this.getBaseEntityId());
            baseProp.setBaseEntityId(number);
            baseProp.setAlias("FBasedataId");
            baseProp.setName("fbasedataid");
            baseProp.setDisplayProp(this.getDisplayProp());
            baseProp.setEditSearchProp(this.getEditSearchProp());
            baseProp.setDbIgnore(true);
            type.addProperty((DynamicProperty)baseProp);
        }
    }

    public int getFieldDBType() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)this.getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
        int pkType = 0;
        for (Entity entity : entityMetadata.getEntitys()) {
            if (entity instanceof BillEntity) {
                pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
                break;
            }
            if (!(entity instanceof QueryEntity)) continue;
            pkType = ((QueryEntity)entity).getPkType() == 0 ? 12 : -5;
            break;
        }
        return pkType;
    }
}

