/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.prop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.ext.hr.metadata.prop.QueryLocalCacheMgr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

@DataEntityTypeAttribute(name="kd.bos.ext.hr.metadata.prop.QueryProp")
public class QueryProp
extends BasedataProp
implements IQueryProp {
    private static final Log LOGGER = LogFactory.getLog(QueryProp.class);
    private static final long serialVersionUID = -477548326973244564L;
    private String billFormId;

    public QueryProp() {
        this.setDbIgnore(true);
    }

    private static boolean getQueryTypeConfig() {
        HashSet<String> searchKeySet = new HashSet<String>();
        searchKeySet.add("query_type_config");
        Map configParams = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)new AppCustomParam("XYRL3+A8Z+Z", searchKeySet));
        String flag = (String)configParams.get("query_type_config");
        if (flag == null) {
            return false;
        }
        return Boolean.parseBoolean(flag);
    }

    public void setComplexType(IDataEntityType dynamicObjectType) {
        if (QueryProp.getQueryTypeConfig()) {
            this.setComplexType2(dynamicObjectType);
        } else {
            this.setComplexType3(dynamicObjectType);
        }
    }

    public void setComplexType3(IDataEntityType dynamicObjectType) {
        try {
            RefEntityType refEntityType;
            try {
                refEntityType = (RefEntityType)dynamicObjectType.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("RefEntityType clone error!");
                refEntityType = (RefEntityType)dynamicObjectType;
            }
            if (refEntityType.getPrimaryKey() == null) {
                String str = ((MetadataService)ServiceFactory.getService(MetadataService.class)).loadEntityMeta(refEntityType.getName());
                Map jsonMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
                RefEntityType mainRefEntityType = RefEntityTypeCache.getRefEntityType((String)((String)jsonMap.get("EntityName")), (boolean)true);
                for (IDataEntityProperty prop : mainRefEntityType.getProperties()) {
                    refEntityType.addProperty((DynamicProperty)prop.clone());
                }
                if (StringUtils.isEmpty((CharSequence)refEntityType.getAlias())) {
                    refEntityType.setAlias(mainRefEntityType.getAlias());
                    refEntityType.setDBRouteKey(mainRefEntityType.getDBRouteKey());
                }
                refEntityType.setNameProperty(this.getNameKey((IDataEntityType)refEntityType, this.getDisplayProp()));
                refEntityType.setNumberProperty(this.getNumberKey((IDataEntityType)refEntityType, this.getDisplayProp()));
            }
            super.setComplexType((IDataEntityType)refEntityType);
        }
        catch (Exception e) {
            LOGGER.info("setComplexType:{}", (Object)e);
        }
    }

    private void handleMainProp(String mainEntityNumber, Set<String> mainEntityFields, List<DynamicProperty> addProps) throws CloneNotSupportedException {
        LongProp idProp;
        ArrayList<String> idKeys = new ArrayList<String>(10);
        RefEntityType mainRefEntityType = RefEntityTypeCache.getRefEntityType((String)mainEntityNumber, (boolean)true);
        for (String field : mainEntityFields) {
            String prop = field.split("\\.")[0];
            IDataEntityProperty property = mainRefEntityType.findProperty(prop);
            if (null != property && !idKeys.contains(prop)) {
                idKeys.add(prop);
                addProps.add((DynamicProperty)property.clone());
                if (!(property instanceof BasedataProp)) continue;
                if (null != mainRefEntityType.getProperty(prop + "_id")) {
                    addProps.add((DynamicProperty)mainRefEntityType.getProperty(prop + "_id").clone());
                    continue;
                }
                if (null == mainRefEntityType.getProperty(prop + ".id")) continue;
                addProps.add((DynamicProperty)mainRefEntityType.getProperty(prop + ".id").clone());
                continue;
            }
            LOGGER.info("entity {} not prop {}", (Object)mainEntityNumber, (Object)prop);
        }
        if (mainRefEntityType.getProperty("id") instanceof LongProp) {
            idProp = new LongProp();
            idProp.setName("id");
            addProps.add((DynamicProperty)idProp);
        } else {
            idProp = new TextProp();
            idProp.setName("id");
            addProps.add((DynamicProperty)idProp);
        }
        if (mainRefEntityType.getProperty("masterid") instanceof LongProp) {
            idProp = new LongProp();
            idProp.setName("masterid");
            addProps.add((DynamicProperty)idProp);
        } else if (mainRefEntityType.getProperty("masterid") instanceof TextProp) {
            idProp = new TextProp();
            idProp.setName("masterid");
            addProps.add((DynamicProperty)idProp);
        }
        if (null != mainRefEntityType.getProperty("multilanguagetext")) {
            addProps.add((DynamicProperty)mainRefEntityType.getProperty("multilanguagetext").clone());
        }
    }

    private Set<String> getMainEntityFields(List<Map<String, Object>> selectFields, List<Map<String, Object>> joinEntitys) {
        HashSet<String> mainEntityFields = new HashSet<String>(10);
        ArrayList<String> joinEntityFields = new ArrayList<String>(10);
        for (Map<String, Object> joinEntity : joinEntitys) {
            String[] fields = ((String)joinEntity.get("IncludeFieldNames")).split(",");
            joinEntityFields.addAll(Arrays.asList(fields));
            String field = (String)joinEntity.get("FKProperty");
            if ("id".equals(field)) continue;
            mainEntityFields.add(field);
        }
        for (Map<String, Object> selectField : selectFields) {
            String field = (String)selectField.get("Alias");
            if (joinEntityFields.contains(field)) continue;
            mainEntityFields.add(field);
        }
        return mainEntityFields;
    }

    public void setComplexType2(IDataEntityType dynamicObjectType) {
        try {
            RefEntityType refEntityType;
            try {
                refEntityType = (RefEntityType)dynamicObjectType.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("RefEntityType clone error!");
                refEntityType = (RefEntityType)dynamicObjectType;
            }
            if (refEntityType.getPrimaryKey() == null) {
                String parentName = null != this.getParent() ? this.getParent().getName() : "null";
                String traceId = RequestContext.get().getTraceId();
                String lockKey = "qp_" + traceId + "_" + refEntityType.getName();
                String lockValue = (String)QueryLocalCacheMgr.getCache(lockKey);
                int count = StringUtils.isEmpty((CharSequence)lockValue) ? 0 : Integer.parseInt(lockValue);
                LOGGER.info("parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                if (count < 3) {
                    QueryLocalCacheMgr.putCache(lockKey, String.valueOf(++count));
                    QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)refEntityType.getName());
                    QueryLocalCacheMgr.putCache(lockKey, String.valueOf(--count));
                    this.addProperty((DynamicObjectType)refEntityType, queryEntityType);
                    LOGGER.info("add all property,parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                    if (StringUtils.isEmpty((CharSequence)refEntityType.getAlias())) {
                        refEntityType.setAlias(queryEntityType.getAlias());
                        refEntityType.setDBRouteKey(queryEntityType.getDBRouteKey());
                    }
                    refEntityType.setNameProperty(this.getNameKey((IDataEntityType)queryEntityType, this.getDisplayProp()));
                    refEntityType.setNumberProperty(this.getNumberKey((IDataEntityType)queryEntityType, this.getDisplayProp()));
                } else {
                    LongProp idProp = new LongProp();
                    idProp.setName("id");
                    this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
                    MetadataReader reader = new MetadataReader(false);
                    String entityId = reader.loadIdByNumber(refEntityType.getName(), MetaCategory.Entity);
                    EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                    QueryEntity queryEntity = (QueryEntity)entityMetadata.getRootEntity();
                    refEntityType.setAlias(this.getTableName(queryEntity.getEntityAlias()));
                    refEntityType.setDBRouteKey(queryEntity.getdbRoute());
                    refEntityType.setNameProperty(this.getDisplayProp());
                    refEntityType.setNumberProperty(this.getEditSearchProp() != null ? this.getEditSearchProp() : this.getDisplayProp());
                    LOGGER.info("only add id,parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                }
            }
            super.setComplexType((IDataEntityType)refEntityType);
        }
        catch (Exception e) {
            LOGGER.info("setComplexType:", (Object)e);
        }
    }

    private String getTableName(String queryEntityNumber) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryEntityNumber)});
        if (null != dy) {
            return dy.getString("tablename");
        }
        return "";
    }

    @Override
    public synchronized void addProperty(IDataEntityType dynamicObjectType, DynamicProperty dynamicProperty) {
        if (dynamicObjectType == null || dynamicObjectType.getProperties() == null || dynamicProperty == null) {
            return;
        }
        if (dynamicObjectType.getProperties().get((Object)dynamicProperty.getName()) == null) {
            dynamicObjectType.getProperties().add((Object)dynamicProperty);
        }
    }

    public Object getBindingBasedataValue(Object val, String displayProp) {
        IDataEntityProperty p2;
        Object[] arr = new Object[]{"", "", ""};
        if (StringUtils.isEmpty((CharSequence)displayProp)) {
            return arr;
        }
        if (!(val instanceof DynamicObject)) {
            return arr;
        }
        DynamicObject value = (DynamicObject)val;
        BasedataEntityType dt = value.getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)value.getDataEntityType() : (BasedataEntityType)this.getComplexType();
        String nameKey = this.getNameKey((IDataEntityType)dt, displayProp);
        String numberKey = this.getNumberKey((IDataEntityType)dt, displayProp);
        IDataEntityProperty p1 = dt.findProperty(numberKey);
        if (p1 != null) {
            arr[0] = p1.getValueFast(val);
            if (arr[0] == null) {
                arr[0] = "";
            }
        } else {
            arr[0] = value.get(numberKey);
        }
        arr[1] = (p2 = dt.findProperty(nameKey)) != null ? p2.getValueFast(val) : value.get(nameKey);
        if (arr[1] instanceof ILocaleString) {
            arr[1] = arr[1].toString();
        }
        if (arr[1] == null) {
            arr[1] = "";
        }
        if (employees.contains(this.getBaseEntityId()) || depEmps.contains(this.getBaseEntityId())) {
            this.setEditSearchProp(numberKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEditSearchProp())) {
            String number = StringUtils.isBlank((Object)arr[0]) ? "" : arr[0].toString();
            String name = StringUtils.isBlank((Object)arr[1]) ? "" : arr[1].toString();
            arr[2] = StringUtils.replaceEach((String)this.getEditSearchProp(), (String[])new String[]{numberKey, nameKey}, (String[])new String[]{number, name});
        } else {
            arr[2] = arr[0];
        }
        return arr;
    }

    public String getNameKey(String displayProp) {
        return this.getNameKey(null, displayProp);
    }

    public String getNumberKey(String displayProp) {
        return this.getNumberKey(null, displayProp);
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    public String getDisplayValue(Object basedataObj) {
        if (basedataObj == null) {
            return null;
        }
        if (this.getDisplayProp().contains(".")) {
            return ((DynamicObject)basedataObj).getString(this.getDisplayProp());
        }
        return super.getDisplayValue(basedataObj);
    }
}

