/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.ext.hr.web.vo.HrUserSessionVO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.eclipse.jetty.server.Request;

@Deprecated
public class MobileHtmlFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(MobileHtmlFilter.class);
    private static final String ERROR_TIP_ILLEGALPARAM = "Illegal link parameter";
    private static final String ERROR_TIP_EMPTYACCOUNTID = "AccountId is necessary";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!LoginUtils.isIndexHTML((HttpServletRequest)request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            String accountId;
            String userId;
            String loginConfigNumber = HrFilterUtil.xssEncode(request.getParameter("loginConfigNumber"));
            if (StringUtils.isEmpty((String)loginConfigNumber)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String formId = HrFilterUtil.xssEncode(request.getParameter("form"));
            if (StringUtils.isNotEmpty((String)formId) && StringUtils.isNotEmpty((String)(userId = request.getHeader("userId")))) {
                ((Request)request).getMetaData().getFields().remove("userId");
            }
            if (StringUtils.isEmpty((String)(accountId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"accountId")))) {
                response.getWriter().write(ERROR_TIP_EMPTYACCOUNTID);
                response.getWriter().flush();
                return;
            }
            String bizUserId = HrFilterUtil.xssEncode(request.getParameter("bizUserId"));
            if (StringUtils.isEmpty((String)bizUserId)) {
                response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
                response.getWriter().flush();
                return;
            }
            this.createGuestRequestContext(request, null);
            LoginConfigDTO loginConfigDTO = (LoginConfigDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"getHrLoginConfig", (Object[])new Object[]{loginConfigNumber});
            if (loginConfigDTO == null) {
                response.getWriter().write("loginConfig not found,number=" + URLEncoder.encode(loginConfigNumber, StandardCharsets.UTF_8.toString()));
                response.getWriter().flush();
                return;
            }
            RequestContext.set(null);
            if (StringUtils.isEmpty((String)formId)) {
                boolean isLongUrlTimeoutEnable = this.isLongUrlTimeoutEnable(request);
                if (isLongUrlTimeoutEnable && this.isLongUrlTimeout(request, response, loginConfigNumber, accountId)) {
                    return;
                }
                String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
                String url2 = this.getLoginPageUrl(request, loginConfigDTO);
                String url3 = "";
                String finalUrl = url2;
                Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
                if (hrUserCookie != null) {
                    String cookieValue = hrUserCookie.getValue();
                    HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, cookieValue);
                    if (hrUserSessionVO == null) {
                        HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                        finalUrl = url2;
                    } else if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                        HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                        finalUrl = url2;
                    } else {
                        finalUrl = url3 = this.getBizFormPageUrl(request, accountId, loginConfigNumber, hrUserSessionVO.getBizFormId(), bizUserId, bizCustomParam);
                    }
                }
                response.sendRedirect(finalUrl);
                return;
            }
            if (!this.isUserIdValid(request, response)) {
                return;
            }
            if (!this.isNeedResetValid(request, response)) {
                return;
            }
            if (formId.equals("hbss_commonlogin")) {
                String bizFormId = HrFilterUtil.xssEncode(request.getParameter("bizFormId"));
                if (StringUtils.isEmpty((String)bizFormId)) {
                    response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
                    response.getWriter().flush();
                    return;
                }
                boolean isLongUrlTimeoutEnable = this.isLongUrlTimeoutEnable(request);
                if (isLongUrlTimeoutEnable && this.isLongUrlTimeout(request, response, loginConfigNumber, accountId)) {
                    return;
                }
                Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
                if (hrUserCookie != null) {
                    String cookieValue = hrUserCookie.getValue();
                    HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, cookieValue);
                    if (hrUserSessionVO == null) {
                        HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                        filterChain.doFilter(servletRequest, servletResponse);
                        return;
                    }
                    if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                        HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                        filterChain.doFilter(servletRequest, servletResponse);
                        return;
                    }
                    String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
                    String url3 = this.getBizFormPageUrl(request, accountId, loginConfigNumber, hrUserSessionVO.getBizFormId(), bizUserId, bizCustomParam);
                    response.sendRedirect(url3);
                    return;
                }
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (!formId.equals(loginConfigDTO.getRedirectFormId())) {
                response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
                response.getWriter().flush();
                return;
            }
            boolean isLongUrlTimeoutEnable = this.isLongUrlTimeoutEnable(request);
            if (isLongUrlTimeoutEnable && this.isLongUrlTimeout(request, response, loginConfigNumber, accountId)) {
                return;
            }
            Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
            if (hrUserCookie != null) {
                String url2 = this.getLoginPageUrl(request, loginConfigDTO);
                String cookieValue = hrUserCookie.getValue();
                HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, hrUserCookie.getValue());
                if (hrUserSessionVO == null) {
                    HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                    response.sendRedirect(url2);
                    return;
                }
                if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                    HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                    response.sendRedirect(url2);
                    return;
                }
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                String url2 = this.getLoginPageUrl(request, loginConfigDTO);
                response.sendRedirect(url2);
            }
        }
        catch (Exception ex) {
            LOGGER.error("MobileHtmlFilterError:", (Throwable)ex);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01\n", (String)"LoginFilter_3", (String)"bos-login", (Object[])new Object[0]) + ex.getMessage()});
            String resp = LoginUtils.getLoginResponse((String)String.valueOf(kd.getErrorCode().getCode()), (String)kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception var52) {
                throw ex;
            }
        }
    }

    private boolean isLongUrlTimeout(HttpServletRequest request, HttpServletResponse response, String loginConfigNumber, String accountId) throws IOException {
        String safeuriExpiryUrl = HrFilterUtil.getFormUrlByGuest(request, accountId, "hbss_safeuriexpiry", loginConfigNumber) + "&" + "timeout=true";
        SafeUrlDTO safeUrlDTO = this.getSafeUrlDTO(request, response, loginConfigNumber, accountId);
        Date expiryTime = safeUrlDTO.getExpiryTime();
        if (expiryTime == null) {
            response.sendRedirect(safeuriExpiryUrl);
            return true;
        }
        if (safeUrlDTO.getExpiryTime().before(new Date())) {
            response.sendRedirect(safeuriExpiryUrl);
            return true;
        }
        return false;
    }

    private String getBizFormPageUrl(HttpServletRequest request, String accountId, String loginConfigNumber, String formId, String bizUserId, String bizCustomParam) {
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizUserId=" + bizUserId;
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        return HrFilterUtil.getFormUrlByGuest(request, accountId, formId, loginConfigNumber) + queryParam + "&language=" + RequestContext.get().getLang().toString();
    }

    private boolean isNeedResetValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String needReset = LoginUtils.getParamerter((HttpServletRequest)request, (String)"needReset");
        if (StringUtils.isEmpty((String)needReset)) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        if (!needReset.equals("true")) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        return true;
    }

    private boolean isUserIdValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String userId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"userId");
        if (StringUtils.isEmpty((String)userId)) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        if (!userId.equals("Guest")) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        return true;
    }

    private SafeUrlDTO getSafeUrlDTO(HttpServletRequest request, HttpServletResponse response, String loginConfigNumber, String accountId) {
        if (RequestContext.get() == null) {
            this.createGuestRequestContext(request, response);
        }
        String bizUserId = HrFilterUtil.xssEncode(request.getParameter("bizUserId"));
        String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
        String dbMobileHtmlUrl = HrGuestUrlUtil.getMobileHtmlUrl(accountId, loginConfigNumber, bizUserId, bizCustomParam);
        return (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{dbMobileHtmlUrl});
    }

    private boolean isLongUrlTimeoutEnable(HttpServletRequest request) {
        String longUrlTimeoutEnable = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.guest.longurltimeout.enable", (String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (StringUtils.isEmpty((String)longUrlTimeoutEnable)) {
            longUrlTimeoutEnable = "true";
        }
        return Boolean.parseBoolean(longUrlTimeoutEnable);
    }

    private String getLoginPageUrl(HttpServletRequest request, LoginConfigDTO loginConfigDTO) {
        String formId = "hbss_commonlogin";
        String loginConfigNumber = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("loginConfigNumber")));
        String bizUserId = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("bizUserId")));
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizFormId=" + loginConfigDTO.getRedirectFormId() + "&bizUserId=" + bizUserId;
        String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        Account currentCenter = HrFilterUtil.getCurrentAccount(request);
        String langCode = loginConfigDTO.getLangCode();
        String language = HrFilterUtil.xssEncode(request.getParameter("language"));
        if (StringUtils.isNotEmpty((String)language)) {
            langCode = LoginLangUtils.getLoginLanguage((HttpServletRequest)request).toString();
        }
        return HrFilterUtil.getFormUrlByGuest(request, currentCenter.getAccountId(), formId, loginConfigNumber) + queryParam + "&language=" + langCode;
    }

    private void createGuestRequestContext(HttpServletRequest request, HttpServletResponse response) {
        String globalSessionId = HrFilterUtil.getKDGlobalSessionId(request);
        if (StringUtils.isEmpty((String)globalSessionId)) {
            Account currentCenter = HrFilterUtil.getCurrentAccount(request);
            LoginUtils.createGuestRequestContext((HttpServletRequest)request, (Account)currentCenter);
            globalSessionId = RequestContext.get().getGlobalSessionId();
            if (RequestContext.get() == null) {
                HrFilterUtil.createGuestRequestContext(request, globalSessionId);
            }
        } else {
            HrFilterUtil.createGuestRequestContext(request, globalSessionId);
        }
        RequestContext.get().setTraceId(TraceIdUtil.createTraceIdString());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

