/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.func;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSBatchFunction;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.ext.hr.func.helper.DimensionHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetDimensionNumber
implements BOSUDFunction,
BOSBatchFunction {
    private static final Log LOGGER = LogFactory.getLog(GetDimensionNumber.class);
    private ExpressionContext expContext;

    public GetDimensionNumber() {
    }

    public GetDimensionNumber(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext arg0) {
        return new GetDimensionNumber(this.expContext);
    }

    public String getName() {
        return "GetDimensionNumber";
    }

    public Object call(Object ... arg) {
        if (arg == null || arg.length == 0 || arg[0].equals("") || arg[0] == null) {
            return null;
        }
        if (arg.length <= 1) {
            return null;
        }
        long currentEntryId = Long.parseLong(arg[0].toString());
        String index = arg[1].toString();
        LOGGER.info("GetDimensionNumber call ######### currentEntryId : {} and  index : {}", (Object)currentEntryId, (Object)index);
        return this.queryDimensionNumber(currentEntryId, index);
    }

    public Map<BatchFuncRunParam, Object> batchCall(Set<BatchFuncRunParam> param) {
        HashMap<BatchFuncRunParam, Object> resultMap = new HashMap<BatchFuncRunParam, Object>(param.size());
        List<Long> entryIdList = DimensionHelper.getEntryIds(param);
        LOGGER.info("GetDimensionNumber batchCall entryIdList size : {}", (Object)entryIdList.size());
        if (!entryIdList.isEmpty()) {
            Map<Long, Long> costBillEntryAndSetUpConstIdMap = DimensionHelper.getCostBillEntryAndSetUpConstIdMap(entryIdList);
            Collection<Long> values = costBillEntryAndSetUpConstIdMap.values();
            ArrayList<Long> costSetUpConstIdList = new ArrayList<Long>(new HashSet<Long>(values));
            LOGGER.info("GetDimensionNumber batchCall costSetUpConstIdList size : {}", (Object)costSetUpConstIdList.size());
            Map<Long, DynamicObject> costSetUpConstIdMap = DimensionHelper.getCostSetupConstIdMap(costSetUpConstIdList);
            this.putNumberResult(param, resultMap, costBillEntryAndSetUpConstIdMap, costSetUpConstIdMap);
        }
        return resultMap;
    }

    private void putNumberResult(Set<BatchFuncRunParam> param, Map<BatchFuncRunParam, Object> resultMap, Map<Long, Long> costBillEntryAndSetUpConstIdMap, Map<Long, DynamicObject> costSetUpConstIdMap) {
        List<Long> costStruIdList = GetDimensionNumber.getCostStruIdList(costSetUpConstIdMap);
        Map<Long, DynamicObject> costStruIdMap = DimensionHelper.getCostStruIdMap(costStruIdList);
        for (BatchFuncRunParam next : param) {
            Object currentEntryIdObj;
            Object[] paramVal = next.getFuncParamVals();
            if (paramVal == null || paramVal.length <= 1 || ObjectUtils.isEmpty((Object)(currentEntryIdObj = paramVal[0]))) continue;
            long currentEntryId = Long.parseLong(currentEntryIdObj.toString());
            String index = paramVal[1].toString();
            Long costSetupConstId = costBillEntryAndSetUpConstIdMap.get(currentEntryId);
            LOGGER.info("GetDimensionNumber putNumberResult costSetupConstId ######### currentEntryId : {} and  index : {} and costSetupConstId : {}", new Object[]{currentEntryId, index, costSetupConstId});
            DynamicObject costSetUpConstDy = costSetUpConstIdMap.get(costSetupConstId);
            String number = this.getNumberBatch(currentEntryId, index, costSetUpConstDy, costStruIdMap);
            resultMap.put(next, number);
        }
    }

    public static List<Long> getCostStruIdList(Map<Long, DynamicObject> costSetUpConstIdMap) {
        if (CollectionUtils.isEmpty(costSetUpConstIdMap)) {
            return new ArrayList<Long>();
        }
        HashSet<Long> costStruIdSet = new HashSet<Long>(costSetUpConstIdMap.size());
        for (Map.Entry<Long, DynamicObject> next : costSetUpConstIdMap.entrySet()) {
            DynamicObject costSetUpConstDy = next.getValue();
            long costStruId = costSetUpConstDy.getLong("coststru.id");
            costStruIdSet.add(costStruId);
        }
        ArrayList<Long> costStruIdList = new ArrayList<Long>(costStruIdSet);
        return costStruIdList;
    }

    private String queryDimensionNumber(long currentEntryId, String index) {
        long costSetupConstId = DimensionHelper.getcostSetupConstId(currentEntryId);
        LOGGER.info("GetDimensionNumber queryDimensionNumber costSetupConstId ######### currentEntryId : {} and  index : {} and costSetupConstId : {}", new Object[]{currentEntryId, index, costSetupConstId});
        return this.getNumber(currentEntryId, index, costSetupConstId);
    }

    private String getNumber(long currentEntryId, String index, long costSetupConstId) {
        DynamicObject costSetUpConstDy = BusinessDataServiceHelper.loadSingle((String)"pcs_costsetupconst", (String)DimensionHelper.getFileds("2"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costSetupConstId)});
        if (costSetUpConstDy == null) {
            return null;
        }
        long costStruId = costSetUpConstDy.getLong("coststru.id");
        LOGGER.info("GetDimensionNumber getNumber costStruId ######### currentEntryId : {} and  index : {} and costStruId : {}", new Object[]{currentEntryId, index, costStruId});
        DynamicObject costStruObj = BusinessDataServiceHelper.loadSingle((String)"lcs_coststru", (String)"costdimension,storageset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costStruId)});
        if (costStruObj == null) {
            return null;
        }
        DynamicObjectCollection costDimensionColl = costStruObj.getDynamicObjectCollection("dimensionentry");
        long costDimensionId = 0L;
        for (DynamicObject costDimension : costDimensionColl) {
            String stoNumber = costDimension.getString("storageset.number");
            if (!stoNumber.equals(index)) continue;
            costDimensionId = costDimension.getLong("costdimension.id");
            break;
        }
        LOGGER.info("GetDimensionNumber getNumber costDimensionId ######### currentEntryId : {} and  index : {} and costDimensionId : {}", new Object[]{currentEntryId, index, costDimensionId});
        DynamicObject costDimensionObj = BusinessDataServiceHelper.loadSingle((String)"lcs_costdimension", (String)"id,valuesource,assistant,valuetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costDimensionId)});
        if (costDimensionObj == null) {
            return null;
        }
        String entityName = DimensionHelper.getEntityNumber(costDimensionObj);
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        String costSetUpConstVal = DimensionHelper.getCostSetupVal(index, costSetUpConstDy);
        String number = this.queryNumber(entityName, costSetUpConstVal);
        LOGGER.info("GetDimensionNumber getNumber number ######### currentEntryId : {} and  index : {} and number : {} and costSetUpConstVal : {}", new Object[]{currentEntryId, index, number, costSetUpConstVal});
        return number;
    }

    private String getNumberBatch(long currentEntryId, String index, DynamicObject costSetUpConstDy, Map<Long, DynamicObject> costStruIdMap) {
        if (costSetUpConstDy == null) {
            return null;
        }
        long costStruId = costSetUpConstDy.getLong("coststru.id");
        LOGGER.info("GetDimensionNumber getNumberBatch costStruId ######### currentEntryId : {} and  index : {} and costStruId : {}", new Object[]{currentEntryId, index, costStruId});
        DynamicObject costStruObj = costStruIdMap.get(costStruId);
        if (costStruObj == null) {
            return null;
        }
        DynamicObject costDimensionObj = null;
        DynamicObjectCollection costDimensionColl = costStruObj.getDynamicObjectCollection("dimensionentry");
        for (DynamicObject costDimension : costDimensionColl) {
            String stoNumber = costDimension.getString("storageset.number");
            if (!stoNumber.equals(index)) continue;
            costDimensionObj = costDimension;
            break;
        }
        if (costDimensionObj == null) {
            return null;
        }
        String entityName = DimensionHelper.getEntityNumberBatch(costDimensionObj);
        LOGGER.info("GetDimensionNumber getNumberBatch entityName ######### currentEntryId : {} and  index : {} and entityName : {}", new Object[]{currentEntryId, index, entityName});
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        String costSetUpConstVal = DimensionHelper.getCostSetupVal(index, costSetUpConstDy);
        String number = this.queryNumber(entityName, costSetUpConstVal);
        LOGGER.info("GetDimensionNumber getNumberBatch number ######### currentEntryId : {} and  index : {} and number : {} and costSetUpConstVal : {}", new Object[]{currentEntryId, index, number, costSetUpConstVal});
        return number;
    }

    private String queryNumber(String entityName, String costSetUpConstVal) {
        String number = "";
        if (StringUtils.isNotEmpty((CharSequence)costSetUpConstVal) && !StringUtils.equals((CharSequence)costSetUpConstVal, (CharSequence)" ")) {
            Long id = 0L;
            try {
                id = Long.valueOf(costSetUpConstVal);
            }
            catch (NumberFormatException e) {
                LOGGER.error("GetDimensionNumber convertId error :", (Object)e.getMessage());
            }
            if (id == 0L) {
                return null;
            }
            DynamicObject valueSourceObj = QueryServiceHelper.queryOne((String)entityName, (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (valueSourceObj == null) {
                return null;
            }
            number = valueSourceObj.getString("number");
        }
        return number;
    }
}

