/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.bizuniquecode;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class BizUniqueCodeStorageHelper {
    public static void delete(DBRoute dbRoute, List<String> uniqueCodeValue, int billTypeHash) {
        String deleteSql = "delete from T_GBS_BIZUNIQUECODE where fmappingid = ? and funiquecodevalue in (%s) ";
        String exeSql = String.format(deleteSql, BizUniqueCodeStorageHelper.constructPlaceHolder(uniqueCodeValue.size()));
        Object[] parameters = new Object[uniqueCodeValue.size() + 1];
        parameters[0] = billTypeHash;
        for (int i = 1; i <= uniqueCodeValue.size(); ++i) {
            parameters[i] = uniqueCodeValue.get(i - 1);
        }
        DB.execute((DBRoute)dbRoute, (String)exeSql, (Object[])parameters);
    }

    public static void delete(DBRoute dbRoute, String uniqueCodeValue, int billTypeHash) {
        DB.execute((DBRoute)dbRoute, (String)"delete from T_GBS_BIZUNIQUECODE where funiquecodevalue = ? and fmappingid = ?", (Object[])new Object[]{uniqueCodeValue, billTypeHash});
    }

    public static void save(DBRoute dbRoute, int billTypeHash, String propertyValue, Date date) {
        String sql = "insert into T_GBS_BIZUNIQUECODE(funiquecodevalue,fmappingid,fcreatedtime) values (?, ?, ?)";
        Object[] param = new Object[]{propertyValue, billTypeHash, date};
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])param);
    }

    public static Integer loadMappingId(DBRoute dbRoute, String billType) {
        String selectSql = "SELECT fid FROM T_GBS_BIZUNIQUECODEMAPPING WHERE fbillType = ?";
        Integer fid = (Integer)DB.query((DBRoute)dbRoute, (String)selectSql, (Object[])new Object[]{billType}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getInt("fid");
            }
            return null;
        });
        return fid;
    }

    public static int saveMappingTable(DBRoute dbRoute, String billType) {
        try (TXHandle tx = TX.requiresNew();){
            Integer maxId = (Integer)DB.query((DBRoute)dbRoute, (String)"SELECT max(fid)  as maxId FROM T_GBS_BIZUNIQUECODEMAPPING", (Object[])new Object[0], resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getInt("maxId");
                }
                return null;
            });
            int fid = maxId == null ? 1 : maxId + 1;
            String sql = "insert into T_GBS_BIZUNIQUECODEMAPPING(fid,fbillType) values (?, ?)";
            Object[] param = new Object[]{fid, billType};
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])param);
            int n = fid;
            return n;
        }
    }

    public static List<String> getByUniqueCodeValuesAndBillTypeHash(DBRoute dbRoute, List<String> uniqueCodeValues, int billTypeHash) {
        if (uniqueCodeValues == null || uniqueCodeValues.isEmpty()) {
            return Collections.emptyList();
        }
        String selectSql = "SELECT funiquecodevalue FROM T_GBS_BIZUNIQUECODE WHERE fmappingid = ? and funiquecodevalue in (%s)";
        String exeSql = String.format(selectSql, BizUniqueCodeStorageHelper.constructPlaceHolder(uniqueCodeValues.size()));
        Object[] parameters = new Object[uniqueCodeValues.size() + 1];
        parameters[0] = billTypeHash;
        for (int i = 1; i <= uniqueCodeValues.size(); ++i) {
            parameters[i] = uniqueCodeValues.get(i - 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        DB.query((DBRoute)dbRoute, (String)exeSql, (Object[])parameters, resultSet -> {
            if (resultSet.next()) {
                result.add(resultSet.getString("funiquecodevalue"));
            }
            return null;
        });
        return result;
    }

    public static void batchSave(DBRoute dbRoute, List<Object[]> records) {
        String sql = "INSERT INTO T_GBS_BIZUNIQUECODE(funiquecodevalue, fmappingid, fcreatedtime) VALUES (?, ?, ?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sql, records);
    }

    private static String constructPlaceHolder(int len) {
        ArrayList<String> placeHolders = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            placeHolders.add("?");
        }
        return Joiner.on((String)",").join(placeHolders);
    }
}

