/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.metadata.edit;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.bd.common.helper.RequireTypeHelper;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.bd.metadata.edit.RequireTypeEdit")
public class RequireTypeEdit
extends BasedataEdit {
    private static final Log logger = LogFactory.getLog(RequireTypeEdit.class);
    private final QFilter defaultFilter = new QFilter("1", "!=", (Object)1);

    public boolean isF7MultipleSelect() {
        return false;
    }

    public boolean isF7BatchFill() {
        return false;
    }

    protected List<QFilter> getOtherFilters() {
        List otherFilters = super.getOtherFilters();
        QFilter filter = this.buildFilterByConfig();
        if (filter != null) {
            otherFilters.add(filter);
        }
        return otherFilters;
    }

    private QFilter buildFilterByConfig() {
        Object orgValue;
        Object materialValue;
        Object materialInvValue;
        String entityName = this.getModel().getDataEntityType().getName();
        DynamicObject manuStrConfig = RequireTypeHelper.getManuStrConfigFromCache(entityName);
        Map<String, String> dimMap = RequireTypeHelper.parsingManuStrategyDimKey(entityName, manuStrConfig, this.getFieldKey());
        logger.info("\u89e3\u6790\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\uff0c\u5f97\u5230\u7ef4\u5ea6\u6620\u5c04\uff1a{}", dimMap);
        if (dimMap == null || dimMap.isEmpty()) {
            logger.info("\u672a\u627e\u5230\u53ef\u7528\u7684\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e");
            return this.defaultFilter;
        }
        String materialInvKey = dimMap.getOrDefault("materialInvKey", "");
        String materialKey = dimMap.getOrDefault("materialKey", "");
        String orgKey = dimMap.getOrDefault("orgKey", "");
        try {
            materialInvValue = this.getValue(materialInvKey);
            materialValue = this.getValue(materialKey);
            orgValue = this.getValue(orgKey);
        }
        catch (Exception exception) {
            logger.error("\u6839\u636e\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u83b7\u53d6\u7ef4\u5ea6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6709\u8bef", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u83b7\u53d6\u7ef4\u5ea6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6709\u8bef\u3002", (String)"RequireTypeEdit_0", (String)"bos-ext-bd", (Object[])new Object[0]));
        }
        if (materialInvValue != null) {
            long materialInvId = this.getId(materialInvValue);
            HashSet<Long> materialInvSet = new HashSet<Long>(2);
            materialInvSet.add(materialInvId);
            Map<Long, Long> manuStrGroupMap = RequireTypeHelper.queryManuStrGroup(materialInvSet);
            Long manuStrategyGroupId = manuStrGroupMap.get(materialInvId);
            if (manuStrategyGroupId == null) {
                logger.info("\u6839\u636eid\u3010{}\u3011\u672a\u627e\u5230\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f", (Object)materialInvId);
                return this.defaultFilter;
            }
            return this.buildFilterByManuStrGroup(manuStrategyGroupId);
        }
        if (materialValue != null && orgValue != null) {
            long materialId = this.getId(materialValue);
            long orgId = this.getId(orgValue);
            HashSet<Long> materialIdSet = new HashSet<Long>(2);
            materialIdSet.add(materialId);
            Map<String, Long> manuStrGroupMap = RequireTypeHelper.queryManuStrGroup(orgId, materialIdSet);
            String keyStr = RequireTypeHelper.buildMapKey(orgId, materialId);
            Long manuStrategyGroupId = manuStrGroupMap.get(keyStr);
            if (manuStrategyGroupId == null) {
                logger.info("\u6839\u636e\u7ec4\u7ec7\u3010{}\u3011\u3001\u7269\u6599\u3010{}\u3011\u672a\u627e\u5230\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f", (Object)orgId, (Object)materialId);
                return this.defaultFilter;
            }
            return this.buildFilterByManuStrGroup(manuStrategyGroupId);
        }
        logger.info("\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u503c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u5355\u636e\u4e0a\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u4e5f\u53ef\u80fd\u662f\u6ca1\u627e\u5230\u5339\u914d\u7684\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e");
        return this.defaultFilter;
    }

    private QFilter buildFilterByManuStrGroup(long manuStrategyGroupId) {
        HashSet<Long> manuStrGroupIdSet = new HashSet<Long>(2);
        manuStrGroupIdSet.add(manuStrategyGroupId);
        Map<Long, Set<Long>> requireTypeRangeMap = RequireTypeHelper.queryRequireTypeRange(manuStrGroupIdSet);
        Set<Long> requireTypeRange = requireTypeRangeMap.get(manuStrategyGroupId);
        if (requireTypeRange == null || requireTypeRange.isEmpty()) {
            logger.info("\u6839\u636e\u5236\u9020\u7b56\u7565\u7ec4\u3010{}\u3011\u672a\u627e\u5230\u9700\u6c42\u7c7b\u578b\u53ef\u9009\u8303\u56f4\uff0c\u53ef\u80fd\u662f\u672a\u627e\u5230\u5ba1\u6838\u53ef\u7528\u7684\u5236\u9020\u7b56\u7565\u7ec4\u3001\u6216\u8005\u5236\u9020\u7b56\u7565\u3001\u6216\u8005\u9700\u6c42\u7c7b\u578b", (Object)manuStrategyGroupId);
            return this.defaultFilter;
        }
        return new QFilter("id", "in", requireTypeRange);
    }

    private long getId(Object object) {
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    private Object getValue(String fieldKey) {
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            return null;
        }
        DynamicObject parent = this.getModel().getDataEntity(true);
        String dot = ".";
        int i = fieldKey.indexOf(dot);
        while (i != -1) {
            String subFieldKey = fieldKey.substring(0, i);
            Object obj = parent.get(subFieldKey);
            if (obj instanceof DynamicObject) {
                parent = (DynamicObject)obj;
            } else if (obj instanceof DynamicObjectCollection) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(subFieldKey);
                parent = (DynamicObject)((DynamicObjectCollection)obj).get(rowIndex);
            } else {
                if (obj instanceof Long) {
                    return obj;
                }
                if (obj == null) {
                    return null;
                }
            }
            fieldKey = fieldKey.substring(i + 1);
            i = fieldKey.indexOf(dot);
        }
        return parent.get(fieldKey);
    }
}

