/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.operation;

import java.util.HashMap;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BarcodeParser
extends DefaultDynamicFormOperate {
    private static final String MODULE = "bos-ext-bd";
    private static final Log LOGGER = LogFactory.getLog(BarcodeParser.class);

    public boolean needSelectData() {
        return false;
    }

    protected boolean beforeInvokeOperation(OperationResult operationResult) {
        if (!super.beforeInvokeOperation(operationResult)) {
            return false;
        }
        IFormView view = this.getView();
        boolean fListView = view instanceof IListView;
        boolean fBillView = view instanceof IBillView;
        String baseStatus = "status";
        String billStauts = "billstatus";
        boolean fInfoSave = false;
        if (fBillView) {
            DynamicObject bizObj = view.getModel().getDataEntity();
            MainEntityType dataEntityType = view.getModel().getDataEntityType();
            if (dataEntityType.findProperty(billStauts) != null) {
                String billStatus = bizObj.getString(billStauts);
                fInfoSave = "A".equals(billStatus);
            }
            if (!fInfoSave && dataEntityType.findProperty(baseStatus) != null) {
                String status = bizObj.getString(baseStatus);
                fInfoSave = "A".equals(status);
            }
        }
        if (!fInfoSave && !fListView) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u89e3\u6790\u4ec5\u9002\u7528\u4e8e\u53ef\u7f16\u8f91\u72b6\u6001\u7684\u6570\u636e\u6216\u5217\u8868\u754c\u9762\uff01", (String)"NOT_EDITABLE_OR_LIST", (String)MODULE, (Object[])new Object[0]);
            view.showTipNotification(msg);
            LOGGER.warn("barcode parser op, not list, or not edit and billstatus <> A, or it does NOT has billstatus/status");
            return false;
        }
        return true;
    }

    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        String viewPageId = view.getPageId();
        String parsePageId = "barcodeprs_" + viewPageId;
        IFormView parseView = view.getViewNoPlugin(parsePageId);
        if (null != parseView) {
            parseView.activate();
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("barcode_parse");
            parameter.setPageId(parsePageId);
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            IFormView billView = this.getView();
            String entityKey = this.getEntityId();
            Long orgID = this.getMainOrgId(billView);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entityKey", entityKey);
            if (orgID != null) {
                params.put("orgID", orgID);
            }
            if (billView instanceof IListView) {
                params.put("entityId", entityKey);
                params.put("viewBillFormId", entityKey);
                params.put("permissionEntityId", this.getPermissionEntityId());
            }
            parameter.setCustomParams(params);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(entityKey + " barcode parse action, in org: " + orgID);
                this.getOperateLog().info("barcode parse, entity: " + entityKey + ", orgId:" + orgID);
            }
            view.showForm(parameter);
        }
        return super.invokeOperation();
    }

    protected Long getMainOrgId(IFormView billView) {
        Object pkValue;
        DynamicObject orgInfo;
        Long orgId = null;
        String mainOrg = billView.getModel().getDataEntityType().getMainOrg();
        if (StringUtils.isEmpty((String)mainOrg)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the bill does NOT define main org");
            }
        } else if (billView instanceof IBillView && (orgInfo = (DynamicObject)billView.getModel().getValue(mainOrg)) != null && (pkValue = orgInfo.getPkValue()) != null && StringUtils.isNotEmpty((String)pkValue.toString())) {
            try {
                orgId = Long.parseLong(pkValue.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.error("cannot parse orgid to Long", (Throwable)e);
            }
        }
        return orgId;
    }
}

