/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;

public class DapValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> ids = new HashSet<Long>();
        HashMap<Long, ExtendedDataEntity> vchs = new HashMap<Long, ExtendedDataEntity>();
        for (ExtendedDataEntity entity : this.dataEntities) {
            ExtendedDataEntity[] v = entity.getDataEntity();
            if (!"4".equals(v.getString("sourcetype"))) continue;
            ids.add(v.getLong("id"));
            vchs.put(v.getLong("id"), entity);
        }
        if (ids.isEmpty()) {
            return;
        }
        Boolean isNotValidatorEventVoucher = false;
        Boolean isValidatorNotMergeVoucher = false;
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("source_of_bill_operation")) {
            isNotValidatorEventVoucher = Boolean.valueOf((String)variables.get("source_of_bill_operation"));
        }
        if (variables.containsKey("source_of_bill")) {
            isValidatorNotMergeVoucher = Boolean.valueOf((String)variables.get("source_of_bill"));
        }
        if (!isNotValidatorEventVoucher.booleanValue()) {
            DynamicObject v;
            if (isValidatorNotMergeVoucher.booleanValue()) {
                Set<Long> duplicateVchIds = DapVoucherUtil.queryMergeVoucherIds(ids);
                if (!duplicateVchIds.isEmpty()) {
                    for (ExtendedDataEntity entity : this.dataEntities) {
                        v = entity.getDataEntity();
                        if (!duplicateVchIds.contains(v.getLong("id"))) continue;
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u591a\u5f20\u51ed\u8bc1\uff0c\u6682\u4e0d\u652f\u6301\u4ece\u51ed\u8bc1\u5217\u8868\u5220\u9664\u51ed\u8bc1\u3002", (String)"DapValidator_02", (String)"bos-ext-fi", (Object[])new Object[0]));
                    }
                }
            } else {
                Set<Long> voucherIdSet = DapVoucherUtil.getVoucherIdsByVoucherIdSet(ids);
                if (!voucherIdSet.isEmpty()) {
                    for (ExtendedDataEntity entity : this.dataEntities) {
                        v = entity.getDataEntity();
                        if (!voucherIdSet.contains(v.getLong("id"))) continue;
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e8b\u4ef6\u751f\u6210\u7684\u603b\u8d26\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u5728\u603b\u8d26\u5220\u9664\uff0c\u8bf7\u5728\u5355\u636e\u5217\u8868\u64cd\u4f5c\u3002", (String)"DapValidator_01", (String)"bos-ext-fi", (Object[])new Object[0]));
                    }
                }
            }
        }
        String joinids = StringUtils.join((Object[])ids.toArray(), (char)',');
        Map map = (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fvoucherid,fbilltype,fsourcebillid from t_ai_daptracker where fvoucherid in (" + joinids + ")"), (Object[])new Object[0], e -> {
            HashMap<String, List> result = new HashMap<String, List>(8);
            while (e.next()) {
                String billEntityNumber = e.getString("fbilltype");
                Long billID = e.getLong("fsourcebillid");
                Long voucherId = e.getLong("fvoucherid");
                List mapList = result.computeIfAbsent(billEntityNumber, v -> new ArrayList());
                Voucher vch = new Voucher();
                vch.setId(voucherId);
                Boolean dataDone = false;
                for (int i = 0; i < mapList.size(); ++i) {
                    Map longVoucherMap = (Map)mapList.get(i);
                    if (longVoucherMap.containsKey(billID)) continue;
                    longVoucherMap.put(billID, vch);
                    dataDone = true;
                    break;
                }
                if (dataDone.booleanValue()) continue;
                HashMap<Long, Voucher> appendMap = new HashMap<Long, Voucher>(16);
                appendMap.put(billID, vch);
                mapList.add(appendMap);
            }
            return result;
        });
        VoucherOperation operation = null;
        if (this.getOperateKey().equalsIgnoreCase("delete")) {
            operation = VoucherOperation.Delete;
        } else if (this.getOperateKey().equalsIgnoreCase("submit")) {
            operation = VoucherOperation.Submit;
        }
        for (Map.Entry entry : map.entrySet()) {
            for (Map newData : (List)entry.getValue()) {
                Map<Long, String> errors = DapVoucherUtil.validateBizBill(operation, (String)entry.getKey(), newData);
                if (errors == null) continue;
                errors.entrySet().forEach(e -> this.addErrorMessage((ExtendedDataEntity)vchs.get(e.getKey()), (String)e.getValue()));
            }
        }
    }
}

