/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillView;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.IDapWriteBack;
import kd.bos.ext.fi.ai.IDapWriteBackBatch;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapBuildVoucherLocalCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.sdk.annotation.SdkDeprecated;

public class DapVoucherUtil {
    private static final Log log = LogFactory.getLog(DapVoucherUtil.class);
    public static final String HAED_ENTITYNAME = "ai_newbuildreporthead";
    public static final String USERNAME = "username";
    public static final String OPNAME = "opname";
    public static final String OPDESC = "opdesc";
    public static final String OPDATE = "opdate";
    public static final String TRANSID = "transid";
    public static final String GLVOUCHER = "glvoucher";
    public static final String GLVOUCHERNO = "glvoucherno";
    public static final String BIZVOUCHER = "bizvoucher";
    public static final String BIZVOUCHERNO = "bizvoucherno";
    public static final String PERIODID = "periodid";
    public static final String PERIOD = "period";
    public static final String SOURCESYS = "sourcesys";
    public static final String SOURCEBILL = "sourcebill";
    public static final String SOURCEBILLNUMBER = "sourcebillnumber";
    public static final String SOURCEBILLNO = "sourcebillno";
    public static final String SOURCEBILLID = "fsourcebillid";
    public static final String BUILDSTATE = "buildstate";
    public static final String ACCOUNTBOOKID = "accountbookid";
    public static final String ACCOUNTBOOK = "accountbook";
    public static final String VCHTEMPLATEID = "vchtemplateid";
    public static final String VCHTEMPLATENO = "vchtemplateno";
    public static final String VCHTEMPLATE = "vchtemplate";
    public static final String ISEXCEPTIONREPORT = "isexceptionreport";
    public static final String BUILDTYPE = "buildtype";
    public static final String ERRORRESULT = "errorresult";
    public static final String BUILDVOUCHERTYPE = "buildvouchertype";
    public static final String ORGID = "orgid";
    public static final String ORG = "org";
    public static final String EXCEPTIONINFO = "exceptioninfo";
    private static final String BuildreportConfigContainer = "fi-ai-buildreport";
    public static final DBRoute AI = DBRoute.of((String)"ai");

    public static void dapWriteBack(VoucherOperation operation, Map<Long, String> vchID2BillNo) {
        Map<String, List<Map<Long, Voucher>>> map = DapVoucherUtil.getBilltypeAndVoucher(vchID2BillNo);
        for (Map.Entry<String, List<Map<Long, Voucher>>> mapEntry : map.entrySet()) {
            for (Map<Long, Voucher> voucher : mapEntry.getValue()) {
                DapVoucherUtil.writeBackBizBill(operation, mapEntry.getKey(), voucher);
            }
        }
    }

    public static Set<Long> getBuildVchForDelete(Collection<Object> billPks, String billType, Map<Long, Set<Long>> voucherAndBill) {
        int size = billPks.size();
        if (size > 10000) {
            HashSet<Long> vchids = new HashSet<Long>();
            HashSet<Object> cache = new HashSet<Object>(billPks.size());
            int i = 0;
            for (Object billid : billPks) {
                cache.add(billid);
                if (++i % 10000 != 0 && i != size) continue;
                String joinids = StringUtils.join((Object[])cache.toArray(), (char)',');
                Set<Long> vchidsTmp = DapVoucherUtil.getVchidsForDelete(billType, joinids, voucherAndBill);
                vchids.addAll(vchidsTmp);
                cache.clear();
            }
            return vchids;
        }
        String joinids = StringUtils.join((Object[])billPks.toArray(), (char)',');
        return DapVoucherUtil.getVchidsForDelete(billType, joinids, voucherAndBill);
    }

    private static Set<Long> getVchidsForDelete(String billType, String joinids, Map<Long, Set<Long>> voucherAndBill) {
        return (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fvoucherid,fsourcebillid from t_ai_daptracker where fsourcebillid in (" + joinids + ") and fbilltype = ?"), (Object[])new Object[]{billType}, e -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (e.next()) {
                idSet.add(e.getLong("fvoucherid"));
                voucherAndBill.computeIfAbsent(e.getLong("fvoucherid"), m -> new HashSet(8)).add(e.getLong(SOURCEBILLID));
            }
            return idSet;
        });
    }

    public static void dapWriteBackFromDelete(VoucherOperation operation, Map<String, List<Map<Long, Voucher>>> map) {
        for (Map.Entry<String, List<Map<Long, Voucher>>> mapEntry : map.entrySet()) {
            for (Map<Long, Voucher> voucher : mapEntry.getValue()) {
                DapVoucherUtil.writeBackBizBill(operation, mapEntry.getKey(), voucher);
            }
        }
    }

    public static void writeBackBizBill(VoucherOperation operation, String billEntityNumber, long billID, long voucherID) {
        if (billEntityNumber == null) {
            DynamicObject[] trackers;
            for (DynamicObject tracker : trackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"sourcebillid,billtype.id", (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)voucherID)})) {
                billEntityNumber = tracker.get("billtype.id").toString();
                billID = tracker.getLong("sourcebillid");
                DapVoucherUtil.callBillWriteBack(operation, billEntityNumber, billID, voucherID);
            }
        } else {
            DapVoucherUtil.callBillWriteBack(operation, billEntityNumber, billID, voucherID);
        }
    }

    private static void callBillWriteBack(VoucherOperation operation, String billEntityNumber, long billID, long voucherID) {
        Map<String, String> plugins = DapVoucherUtil.getWriteBackPlugins();
        String plugin = plugins.get(billEntityNumber);
        if (StringUtils.isNotEmpty((CharSequence)plugin)) {
            try (TXHandle t = TX.requiresNew((String)"DapVoucherUtil.callBillWriteBack");){
                Object newInstance = Class.forName(plugin.trim()).newInstance();
                if (newInstance instanceof IDapWriteBackBatch) {
                    IDapWriteBackBatch back = (IDapWriteBackBatch)newInstance;
                    HashMap<Long, Voucher> vm = new HashMap<Long, Voucher>();
                    Voucher v = new Voucher();
                    v.setId(voucherID);
                    DynamicObject vch = BusinessDataServiceHelper.loadSingle((Object)voucherID, (String)"gl_voucher", (String)"id,billno");
                    v.setVoucherNo(vch.getString("billno"));
                    vm.put(billID, v);
                    back.writeBack(operation, billEntityNumber, vm);
                } else if (newInstance instanceof IDapWriteBack) {
                    IDapWriteBack back = (IDapWriteBack)newInstance;
                    back.writeBack(operation, billID, voucherID);
                }
            }
            catch (Throwable e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void writeBackBizBill(VoucherOperation operation, Long voucherid) {
        DynamicObject[] trackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"sourcebillid,billtype.id", (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)voucherid)});
        HashMap<String, HashMap<Long, Voucher>> map = new HashMap<String, HashMap<Long, Voucher>>();
        Voucher vch = new Voucher();
        vch.setId(voucherid);
        for (DynamicObject tracker : trackers) {
            String billEntityNumber = tracker.get("billtype.id").toString();
            Long billID = tracker.getLong("sourcebillid");
            HashMap<Long, Voucher> newBillToVch = (HashMap<Long, Voucher>)map.get(billEntityNumber);
            if (newBillToVch == null) {
                newBillToVch = new HashMap<Long, Voucher>();
                map.put(billEntityNumber, newBillToVch);
            }
            newBillToVch.put(billID, vch);
        }
        for (Map.Entry entry : map.entrySet()) {
            DapVoucherUtil.callBillWriteBack(operation, (String)entry.getKey(), (Map)entry.getValue());
        }
    }

    public static void writeBackBizBill(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        DapVoucherUtil.callBillWriteBack(operation, billEntityNumber, billToVch);
    }

    private static void callBillWriteBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        Object object;
        Set vchIds;
        log.info("--DAP--excuteWriteoperation--start--");
        if (VoucherOperation.Submit == operation && !(vchIds = billToVch.values().stream().map(Voucher::getId).collect(Collectors.toSet())).isEmpty()) {
            HashSet<Long> existVchIds = new HashSet<Long>(vchIds.size());
            DataSet rows = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)"gl_voucher", (String)"id", (QFilter[])new QFilter("id", "in", vchIds).toArray(), null);
            object = null;
            try {
                for (Throwable row : rows) {
                    existVchIds.add(row.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rows != null) {
                    if (object != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
            if (existVchIds.isEmpty()) {
                return;
            }
            if (existVchIds.size() < vchIds.size()) {
                HashMap temMap = new HashMap(existVchIds.size());
                for (Map.Entry throwable : billToVch.entrySet()) {
                    if (!existVchIds.contains(((Voucher)throwable.getValue()).getId())) continue;
                    temMap.put(throwable.getKey(), throwable.getValue());
                }
                billToVch = temMap;
            }
        }
        if (VoucherOperation.Create == operation || VoucherOperation.Delete == operation) {
            HashMap result = new HashMap(billToVch.size());
            billToVch.entrySet().forEach(v -> {
                Voucher vch = (Voucher)v.getValue();
                Long sourcebillId = (Long)v.getKey();
                List computeIfAbsent = result.computeIfAbsent(vch.getReoper(), c -> new ArrayList(16));
                computeIfAbsent.add(sourcebillId);
            });
            DapBuildVoucherCommonUtil.executeType c = VoucherOperation.Create == operation ? DapBuildVoucherCommonUtil.executeType.DELETEWRITE : DapBuildVoucherCommonUtil.executeType.INSERTWRITE;
            for (Map.Entry v2 : result.entrySet()) {
                try {
                    Throwable row;
                    TXHandle tXHandle = TX.requiresNew();
                    row = null;
                    try {
                        DapBuildVoucherCommonUtil.executeWriteBillDBOperation(billEntityNumber, (String)v2.getKey(), (List)v2.getValue(), c);
                    }
                    catch (Throwable throwable) {
                        row = throwable;
                        throw throwable;
                    }
                    finally {
                        if (tXHandle == null) continue;
                        if (row != null) {
                            try {
                                tXHandle.close();
                            }
                            catch (Throwable throwable) {
                                row.addSuppressed(throwable);
                            }
                            continue;
                        }
                        tXHandle.close();
                    }
                }
                catch (Throwable throwable) {
                    log.error("DapVoucherUtil.executeWriteBillDBOperation.error:" + throwable.getMessage());
                    throw throwable;
                }
            }
            if (billEntityNumber.equals("ai_event") || billEntityNumber.startsWith("fah_e_")) {
                boolean HasVoucher = VoucherOperation.Create == operation;
                ArrayList eventIds = new ArrayList(billToVch.keySet());
                if (eventIds.size() > 1998) {
                    List prtIds = DapBuildVoucherCommonUtil.splitbatch(eventIds, 999);
                    for (List pIds : prtIds) {
                        SqlBuilder sqlBuilder = new SqlBuilder();
                        sqlBuilder.append("update t_ai_event set fhasvoucher=? where ", new Object[]{HasVoucher}).appendIn(" fid ", pIds.toArray());
                        DB.execute((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
                    }
                } else {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("update t_ai_event set fhasvoucher=? where ", new Object[]{HasVoucher}).appendIn(" fid ", eventIds.toArray());
                    DB.execute((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
                }
            }
        }
        log.info("--DAP--excuteWriteoperation--end--");
        log.info("DapVoucherUtil#callBillWriteBack-start");
        log.info("DapVoucherUtil#callBillWriteBack-start");
        log.info("DapVoucherUtil#operation--value:" + operation.value);
        Map<String, String> plugins = DapVoucherUtil.getWriteBackPlugins();
        String plugin = plugins.get(billEntityNumber);
        log.info("DapVoucherUtil#callBillWriteBack-plugin-" + billEntityNumber + "-" + plugin);
        log.info("DapVoucherUtil#billIds:" + billToVch.keySet());
        if (StringUtils.isNotEmpty((CharSequence)plugin)) {
            try {
                TXHandle t = TX.requiresNew((String)"DapVoucherUtil.callBillWriteBack");
                object = null;
                try {
                    HashMap hashMap = new HashMap();
                    billToVch.forEach((k, v) -> billToVchParam.put(k, SerializationUtils.toJsonString((Object)v)));
                    String key = "dap_ServiceLookup_getServiceAppId_" + billEntityNumber;
                    LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.ACCOUNT_BOOK_VERSION, key);
                    String serviceAppId = DapBuildVoucherLocalCache.get(cacheKey, String.class);
                    if (serviceAppId == null) {
                        MainEntityType et = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
                        serviceAppId = ServiceLookup.getServiceAppId((String)et.getAppId());
                        DapBuildVoucherLocalCache.put(cacheKey, serviceAppId);
                    }
                    DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
                    dispatchService.invoke("kd.bos.ext.fi.servicehelper.ServiceFactory", "DapWriteBackService", "writeBack", new Object[]{plugin.trim(), operation.getValue(), billEntityNumber, hashMap});
                    log.info(billEntityNumber + "-\u63d2\u4ef6:" + plugin.trim());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (t != null) {
                        if (object != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("DapVoucherUtil#callBillWriteBack-error-");
                log.error((Throwable)e);
                DapVoucherUtil.generateExceptionReport(e, billEntityNumber, ResManager.loadKDString((String)"\u53cd\u5199\u5f02\u5e38", (String)"DapVoucherUtil_01", (String)"bos-ext-fi", (Object[])new Object[0]), null);
                throw e;
            }
        }
        log.info("DapVoucherUtil#callBillWriteBack-end");
    }

    public static Map<Long, String> validateBizBill(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        Map<String, String> plugins = DapVoucherUtil.getWriteBackPlugins();
        String plugin = plugins.get(billEntityNumber);
        if (StringUtils.isNotEmpty((CharSequence)plugin)) {
            HashMap billToVchParam = new HashMap();
            billToVch.forEach((k, v) -> billToVchParam.put(k, SerializationUtils.toJsonString((Object)v)));
            MainEntityType et = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
            String serviceAppId = ServiceLookup.getServiceAppId((String)et.getAppId());
            DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
            return (Map)dispatchService.invoke("kd.bos.ext.fi.servicehelper.ServiceFactory", "DapWriteBackService", "validate", new Object[]{plugin.trim(), operation.getValue(), billEntityNumber, billToVchParam});
        }
        return null;
    }

    private static Map<String, String> getWriteBackPlugins() {
        IAppCache cache = AppCache.get((String)"ai");
        HashMap<String, String> plugins = (HashMap<String, String>)cache.get("ai-dap-writebackplugin", Map.class);
        if (plugins == null) {
            plugins = new HashMap<String, String>();
            DynamicObject[] ds = BusinessDataServiceHelper.load((String)"ai_dapconfig", (String)"billentity.id,writebackplugin", null);
            if (ds != null && ds.length > 0) {
                for (DynamicObject d : ds) {
                    String billKey;
                    String plugin = d.getString("writebackplugin");
                    if (!StringUtils.isNotEmpty((CharSequence)plugin) || !StringUtils.isNotEmpty((CharSequence)(billKey = d.getString("billentity.id")))) continue;
                    plugins.put(billKey, plugin);
                }
            }
            cache.put("ai-dap-writebackplugin", plugins);
        }
        return plugins;
    }

    @Deprecated
    @SdkDeprecated
    public static Set<Long> getBuildVch(Collection<Object> billPks) {
        int size = billPks.size();
        if (size > 10000) {
            HashSet<Long> vchids = new HashSet<Long>();
            HashSet<Object> cache = new HashSet<Object>(billPks.size());
            int i = 0;
            for (Object billid : billPks) {
                cache.add(billid);
                if (++i % 10000 != 0 && i != size) continue;
                String joinids = StringUtils.join((Object[])cache.toArray(), (char)',');
                Set<Long> vchidsTmp = DapVoucherUtil.getVchids(joinids);
                vchids.addAll(vchidsTmp);
                cache.clear();
            }
            return vchids;
        }
        String joinids = StringUtils.join((Object[])billPks.toArray(), (char)',');
        return DapVoucherUtil.getVchids(joinids);
    }

    private static Set<Long> getVchids(String joinids) {
        return (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fvoucherid from t_ai_daptracker where fsourcebillid in (" + joinids + ")"), (Object[])new Object[0], e -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (e.next()) {
                idSet.add(e.getLong("fvoucherid"));
            }
            return idSet;
        });
    }

    @SdkDeprecated
    public static Set<Long> getBuildVch(Collection<Object> billPks, String billType) {
        int size = billPks.size();
        if (size > 10000) {
            HashSet<Long> vchids = new HashSet<Long>();
            HashSet<Object> cache = new HashSet<Object>(billPks.size());
            int i = 0;
            for (Object billid : billPks) {
                cache.add(billid);
                if (++i % 10000 != 0 && i != size) continue;
                String joinids = StringUtils.join((Object[])cache.toArray(), (char)',');
                Set<Long> vchidsTmp = DapVoucherUtil.getVchids(billType, joinids);
                vchids.addAll(vchidsTmp);
                cache.clear();
            }
            return vchids;
        }
        String joinids = StringUtils.join((Object[])billPks.toArray(), (char)',');
        return DapVoucherUtil.getVchids(billType, joinids);
    }

    private static Set<Long> getVchids(String billType, String joinids) {
        return (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fvoucherid from t_ai_daptracker where fsourcebillid in (" + joinids + ") and fbilltype = ?"), (Object[])new Object[]{billType}, e -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (e.next()) {
                idSet.add(e.getLong("fvoucherid"));
            }
            return idSet;
        });
    }

    public static Set<Long> getBuildData(Collection<Object> billPks, String billType) {
        int size = billPks.size();
        if (size > 10000) {
            HashSet<Long> vchIdsSet = new HashSet<Long>(billPks.size());
            HashSet<Object> cache = new HashSet<Object>(billPks.size());
            int i = 0;
            for (Object billId : billPks) {
                cache.add(billId);
                if (++i % 10000 != 0 && i != size) continue;
                Set<Long> vchIdsTmp = DapVoucherUtil.getXLAIdAndVchIds(billType, cache);
                vchIdsSet.addAll(vchIdsTmp);
                cache.clear();
            }
            return vchIdsSet;
        }
        return DapVoucherUtil.getXLAIdAndVchIds(billType, new HashSet<Object>(billPks));
    }

    private static Set<Long> getXLAIdAndVchIds(String billType, Set<Object> billIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FVOUCHERID fGlVchId from t_ai_daptracker where", new Object[0]);
        sql.append(" fbilltype =?", new Object[]{billType});
        sql.appendIn(" and FSOURCEBILLID ", billIds.toArray());
        sql.append(" union all", new Object[0]);
        sql.append(" select FGL_HEADER_ID fGlVchId from t_fah_evt_tracker where", new Object[0]);
        sql.append(" fsrc_billtype =?", new Object[]{billType});
        sql.append("  and fstatus =?", new Object[]{"4"});
        sql.appendIn(" and fsrc_billid ", billIds.toArray());
        HashSet<Long> fahAndAiTrackerSet = new HashSet<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdByFahAndAiTracker", (DBRoute)AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                fahAndAiTrackerSet.add(row.getLong("fGlVchId"));
            }
        }
        return fahAndAiTrackerSet;
    }

    public static Map<String, Set<Long>> getBillIdByFahAndAiTracker(String billType, Set<Long> billIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select 'DAP' fDataSrcType, FSOURCEBILLID fSrcBillId from t_ai_daptracker where", new Object[0]);
        sql.appendIn(" FSOURCEBILLID ", billIds.toArray());
        sql.append(" and fbilltype =?", new Object[]{billType});
        sql.append(" union all", new Object[0]);
        sql.append(" select 'EVT' fDataSrcType, FSRC_BILLID fSrcBillId from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" fsrc_billid ", billIds.toArray());
        sql.append(" and fsrc_billtype =?", new Object[]{billType});
        sql.append(" and fstatus =?", new Object[]{"4"});
        HashMap<String, Set<Long>> fahAndAiTrackerMap = new HashMap<String, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdByFahAndAiTracker", (DBRoute)AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                fahAndAiTrackerMap.computeIfAbsent(row.getString("fDataSrcType"), k -> new HashSet()).add(row.getLong("fSrcBillId"));
            }
        }
        return fahAndAiTrackerMap;
    }

    public static Set<Long> getVoucherIdsByVoucherIdSet(Set<Long> vchIdSet) {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select FGL_HEADER_ID from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" FGL_HEADER_ID ", vchIdSet.toArray());
        sql.append(" and fstatus = ?", new Object[]{"4"});
        HashSet<Long> voucherIds = new HashSet<Long>(vchIdSet.size());
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdsByVoucherIdSet", (DBRoute)AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                voucherIds.add(row.getLong("FGL_HEADER_ID"));
            }
        }
        return voucherIds;
    }

    public static Set<Long> queryMergeVoucherIds(Set<Long> vchIds) {
        Long fsrcBillid;
        Row row;
        HashSet<Long> duplicateVchIds = new HashSet<Long>(vchIds.size());
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select FGL_HEADER_ID,fsrc_billid from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" FGL_HEADER_ID ", vchIds.toArray());
        sql.append(" and fstatus = ?", new Object[]{"4"}).append(" order by FGL_HEADER_ID ", new Object[0]);
        HashMap<Long, Set> billIdAndVchIdMap = new HashMap<Long, Set>(vchIds.size());
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdsByVoucherIdSet", (DBRoute)AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                fsrcBillid = row.getLong("fsrc_billid");
                Long fglHeaderId = row.getLong("FGL_HEADER_ID");
                billIdAndVchIdMap.computeIfAbsent(fsrcBillid, k -> new HashSet()).add(fglHeaderId);
            }
        }
        if (!billIdAndVchIdMap.isEmpty()) {
            sql = new SqlBuilder();
            sql.append(" select fsrc_billid from t_fah_evt_tracker where", new Object[0]);
            sql.appendIn(" fsrc_billid ", billIdAndVchIdMap.keySet().toArray());
            sql.append(" and fstatus = ?", new Object[]{"4"}).append(" group by fsrc_billid having count(fsrc_billid) > 1 ", new Object[0]);
            dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdsByVoucherIdSet", (DBRoute)AI, (SqlBuilder)sql);
            var5_5 = null;
            try {
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    fsrcBillid = row.getLong("fsrc_billid");
                    duplicateVchIds.addAll((Collection)billIdAndVchIdMap.get(fsrcBillid));
                }
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (var5_5 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        return duplicateVchIds;
    }

    public static List<Long> getBuildedBill(List<Object> pkIds, String billType) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        QFilter typeFilter = new QFilter("billtype", "=", (Object)billType);
        QFilter idFilter = new QFilter("sourcebillid", "in", pkIds);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter[]{typeFilter, idFilter});
        for (DynamicObject dynamicObject : dys) {
            result.add(dynamicObject.getLong("sourcebillid"));
        }
        return result;
    }

    public static List<Long> getBookdateSourceIds(List<Object> pkIds, String billType) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        QFilter typeFilter = new QFilter("billtype", "=", (Object)billType);
        QFilter idFilter = new QFilter("sourcebillid", "in", pkIds);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"ai_bookdatereconds", (String)"id,sourcebillid", (QFilter[])new QFilter[]{typeFilter, idFilter});
        for (DynamicObject dynamicObject : dys) {
            result.add(dynamicObject.getLong("sourcebillid"));
        }
        return result;
    }

    public static List<HashMap<String, Object>> getBookdateReconds(List<Long> pkIds, String billType) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>(16);
        QFilter typeFilter = new QFilter("billtype", "=", (Object)billType);
        QFilter idFilter = new QFilter("sourcebillid", "in", pkIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.operation.TransBookdateService", (String)"ai_bookdatereconds", (String)"id,sourcebillid,index,oldbookdate", (QFilter[])new QFilter[]{typeFilter, idFilter}, (String)" index desc");){
            for (Row row : ds) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("id", row.getLong("id"));
                map.put("index", row.get("index"));
                map.put("sourcebillid", row.getLong("sourcebillid"));
                map.put("oldbookdate", row.get("oldbookdate"));
                result.add(map);
            }
        }
        return result;
    }

    public static List<Long> getNogenVch(DBRoute route, List<Object> pkIds, String tableName) {
        ArrayList<Long> resultList = new ArrayList<Long>(16);
        String temptable = "%s_dapn";
        boolean result = DB.exitsTable((DBRoute)route, (String)(temptable = String.format(temptable, tableName)));
        if (result) {
            List<List<Object>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(pkIds, 2000);
            for (List<Object> sp : splitbatch) {
                String joinids = StringUtils.join((Object[])sp.toArray(), (char)',');
                String querySql = "select fsourcebillid from %s_dapn where fsourcebillid in (" + joinids + ")";
                querySql = String.format(querySql, tableName);
                DataSet ds = DB.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (DBRoute)route, (String)querySql);
                Throwable throwable = null;
                try {
                    while (ds.hasNext()) {
                        resultList.add(ds.next().getLong(SOURCEBILLID));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
        }
        return resultList;
    }

    private static void saveExceptionReport(DynamicObject[] report, List<DynamicObject> reportNew) {
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])report);
        }
        var3_3 = null;
        try (TXHandle txHandle2 = TX.requiresNew();){
            LogORM logORM2 = LogORM.create();
            logORM2.insert(reportNew);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateExceptionReport(Exception e, String billEntityNumber, String message, String templateId) {
        Class<DapVoucherUtil> clazz = DapVoucherUtil.class;
        synchronized (DapVoucherUtil.class) {
            try {
                String traceId = RequestContext.get().getTraceId();
                String printError = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                log.info(printError);
                DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"ai_buildreport");
                report.set(SOURCEBILL, (Object)billEntityNumber);
                report.set(SOURCEBILLNO, (Object)message);
                report.set(GLVOUCHERNO, (Object)message);
                report.set(BUILDSTATE, (Object)"1");
                report.set("createtime", (Object)new Date());
                report.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                report.set("traceid", (Object)traceId);
                if (StringUtils.isNotBlank((CharSequence)templateId)) {
                    report.set("vchtemplate_id", (Object)templateId);
                }
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                String userName = DapVoucherUtil.getUserNameById(userId);
                ArrayList<DynamicObject> resultNew = new ArrayList<DynamicObject>(1);
                String sourceBillName = DapVoucherUtil.getBillTypeNameById(billEntityNumber);
                DynamicObject queryNew = BusinessDataServiceHelper.newDynamicObject((String)HAED_ENTITYNAME);
                queryNew.set(SOURCEBILL, (Object)sourceBillName);
                queryNew.set(SOURCEBILLNUMBER, (Object)billEntityNumber);
                message = message != null ? (message.length() > 199 ? "" : message) : "";
                queryNew.set(ERRORRESULT, (Object)message);
                queryNew.set(BUILDSTATE, (Object)"1");
                queryNew.set(OPDATE, (Object)new Date());
                queryNew.set(USERNAME, (Object)userName);
                queryNew.set("traceid", (Object)traceId);
                if (templateId != null) {
                    Long tempId = Long.parseLong(templateId);
                    Tuple<String, String> tuple = DapVoucherUtil.getVchTemplateById(tempId);
                    queryNew.set(VCHTEMPLATEID, (Object)templateId);
                    if (tuple != null) {
                        queryNew.set(VCHTEMPLATE, tuple.item1);
                        queryNew.set(VCHTEMPLATENO, tuple.item2);
                    }
                }
                queryNew.set(ISEXCEPTIONREPORT, (Object)"1");
                queryNew.set(EXCEPTIONINFO, (Object)printError);
                resultNew.add(queryNew);
                DynamicObjectCollection collection = report.getDynamicObjectCollection("entryentity");
                int index = 0;
                int seq = 0;
                int times = 0;
                do {
                    DynamicObject entryDo = (DynamicObject)collection.getDynamicObjectType().createInstance();
                    entryDo.set("checkitem", (Object)"5");
                    entryDo.set("errlevel", (Object)"0");
                    entryDo.set("seq", (Object)seq++);
                    index = printError.length() > 1000 ? 1000 : printError.length();
                    entryDo.set("message", (Object)printError.substring(0, index));
                    printError = printError.substring(index);
                    collection.add((Object)entryDo);
                } while (printError.length() > 0 && ++times < 15);
                DapVoucherUtil.saveExceptionReport(new DynamicObject[]{report}, resultNew);
            }
            catch (Exception exc) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            }
            return;
        }
    }

    public static String getEntityIdFromView(IFormView view) {
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            return listView.getBillFormId();
        }
        if (view instanceof IBillView) {
            IBillView billView = (IBillView)view;
            return billView.getEntityId();
        }
        return null;
    }

    public static void addBillTypeFilter(IFormView view, List<QFilter> filterList) {
        String billType = DapVoucherUtil.getEntityIdFromView(view);
        DapVoucherUtil.addBillTypeFilter(billType, filterList);
    }

    public static void addBillTypeFilter(String billType, List<QFilter> filterList) {
        if (billType != null && StringUtils.isNotEmpty((CharSequence)billType)) {
            QFilter billTypeFilter = new QFilter("billType", "=", (Object)billType);
            filterList.add(billTypeFilter);
        }
    }

    public static Map<String, List<Map<Long, Voucher>>> getBilltypeAndVoucher(Map<Long, String> vchID2BillNo) {
        String joinids = StringUtils.join((Object[])vchID2BillNo.keySet().toArray(), (char)',');
        Map billtypeAndVoucher = (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fvoucherid,fbilltype,fsourcebillid,freoper from t_ai_daptracker where fvoucherid in (" + joinids + ")"), (Object[])new Object[0], e -> {
            HashMap mapt = new HashMap();
            while (e.next()) {
                String billEntityNumber = e.getString("fbilltype");
                Long billID = e.getLong(SOURCEBILLID);
                String reoper = e.getString("freoper");
                ArrayList newBillToVch = (ArrayList)mapt.get(billEntityNumber);
                if (newBillToVch == null) {
                    newBillToVch = new ArrayList();
                    mapt.put(billEntityNumber, newBillToVch);
                }
                Voucher vch = new Voucher();
                vch.setId(e.getLong("fvoucherid"));
                vch.setVoucherNo((String)vchID2BillNo.get(vch.getId()));
                vch.setReoper(reoper);
                Map<Long, Voucher> idAndBillno = null;
                for (Map map : newBillToVch) {
                    if (map.containsKey(billID)) continue;
                    idAndBillno = map;
                    break;
                }
                if (idAndBillno == null) {
                    idAndBillno = new HashMap<Long, Voucher>();
                }
                idAndBillno.put(billID, vch);
                if (newBillToVch.contains(idAndBillno)) continue;
                newBillToVch.add(idAndBillno);
            }
            return mapt;
        });
        return billtypeAndVoucher;
    }

    public static void generateExceptionReport(Exception e, String billEntityNumber, List<Object> billids, String message, Object templateId, Object bookId, Boolean eventClass) {
        DapVoucherUtil.generateExceptionReport(e, billEntityNumber, billids, message, templateId, bookId, eventClass, null);
    }

    public static void generateExceptionReport(Exception e, String billEntityNumber, List<Object> billids, String message, Object templateId, Object bookId, Boolean eventClass, Object exceptionstack) {
        DapVoucherUtil.generateExceptionReport(e, billEntityNumber, billids, message, templateId, bookId, eventClass, null, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateExceptionReport(Exception e, String billEntityNumber, List<Object> billids, String message, Object templateId, Object bookId, Boolean eventClass, Object exceptionstack, Date start) {
        if (billids.isEmpty()) {
            DapVoucherUtil.generateNewExceptionReport(e, billEntityNumber, message, templateId == null ? null : String.valueOf(templateId), exceptionstack);
            return;
        }
        String billNo = eventClass != false ? "number" : DapVoucherUtil.getBillNoFormBill(billEntityNumber);
        String selectcol = eventClass != false ? "id, number" : "id," + DapVoucherUtil.getBillNoFormBill(billEntityNumber);
        List collect = billids.stream().limit(2000L).map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
        HashMap<Object, String> idAndNo = new HashMap<Object, String>(collect.size());
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)billEntityNumber, (String)selectcol, (QFilter[])new QFilter("id", "in", collect).toArray(), null);){
            for (Row row : queryDataSet) {
                Object id = row.get("id");
                String no = row.getString(billNo);
                idAndNo.put(id, no);
            }
        }
        Class<DapVoucherUtil> clazz = DapVoucherUtil.class;
        synchronized (DapVoucherUtil.class) {
            try {
                String printError = StringUtils.isBlank((Object)exceptionstack) ? ExceptionUtils.getExceptionStackTraceMessage((Exception)e) : exceptionstack.toString();
                log.info(printError);
                DynamicObject[] result = new DynamicObject[billids.size()];
                ArrayList<DynamicObject> resultNew = new ArrayList<DynamicObject>(billids.size());
                int index = 0;
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                String traceId = RequestContext.get().getTraceId();
                String userName = DapVoucherUtil.getUserNameById(userId);
                String sourceBillName = DapVoucherUtil.getBillTypeNameById(billEntityNumber);
                for (Object id : billids) {
                    DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"ai_buildreport");
                    report.set(SOURCEBILL, (Object)billEntityNumber);
                    report.set(SOURCEBILLNO, idAndNo.get(id));
                    message = message != null ? (message.length() > 199 ? "" : message) : "";
                    report.set(ERRORRESULT, (Object)message);
                    report.set(BUILDSTATE, (Object)"1");
                    report.set("createtime", (Object)new Date());
                    report.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    report.set(VCHTEMPLATE, templateId);
                    report.set(ISEXCEPTIONREPORT, (Object)Boolean.TRUE);
                    if (null != printError && printError.length() > 8000) {
                        printError = printError.substring(0, 8000);
                    }
                    report.set(EXCEPTIONINFO, (Object)printError);
                    report.set(ACCOUNTBOOKID, bookId);
                    report.set(SOURCEBILLID, id);
                    report.set("traceid", (Object)traceId);
                    result[index] = report;
                    ++index;
                    DynamicObject queryNew = BusinessDataServiceHelper.newDynamicObject((String)HAED_ENTITYNAME);
                    queryNew.set(SOURCEBILL, (Object)sourceBillName);
                    queryNew.set(SOURCEBILLNUMBER, (Object)billEntityNumber);
                    message = message != null ? (message.length() > 199 ? "" : message) : "";
                    queryNew.set(ERRORRESULT, (Object)message);
                    queryNew.set(BUILDSTATE, (Object)"1");
                    queryNew.set(OPDATE, (Object)new Date());
                    queryNew.set(USERNAME, (Object)userName);
                    queryNew.set("traceid", (Object)traceId);
                    if (templateId != null) {
                        Long tempId = Long.parseLong((String)templateId);
                        Tuple<String, String> tuple = DapVoucherUtil.getVchTemplateById(tempId);
                        queryNew.set(VCHTEMPLATEID, templateId);
                        if (tuple != null) {
                            queryNew.set(VCHTEMPLATE, tuple.item1);
                            queryNew.set(VCHTEMPLATENO, tuple.item2);
                        }
                    }
                    queryNew.set(ISEXCEPTIONREPORT, (Object)"1");
                    queryNew.set(EXCEPTIONINFO, (Object)printError);
                    queryNew.set(ACCOUNTBOOKID, bookId);
                    queryNew.set(SOURCEBILLID, id);
                    queryNew.set(SOURCEBILLNO, idAndNo.get(id));
                    resultNew.add(queryNew);
                }
                DapVoucherUtil.saveExceptionReport(result, resultNew);
            }
            catch (Exception exc) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateNewExceptionReport(Exception e, String billEntityNumber, String message, String templateId, Object exceptionstack) {
        Class<DapVoucherUtil> clazz = DapVoucherUtil.class;
        synchronized (DapVoucherUtil.class) {
            try {
                String traceId = RequestContext.get().getTraceId();
                String printError = StringUtils.isBlank((Object)exceptionstack) ? ExceptionUtils.getExceptionStackTraceMessage((Exception)e) : exceptionstack.toString();
                log.info(printError);
                DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"ai_buildreport");
                report.set(SOURCEBILL, (Object)billEntityNumber);
                message = message != null ? (message.length() > 199 ? "" : message) : "";
                report.set(ERRORRESULT, (Object)message);
                report.set(BUILDSTATE, (Object)"1");
                report.set("createtime", (Object)new Date());
                report.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                report.set("traceid", (Object)traceId);
                report.set(VCHTEMPLATE, (Object)templateId);
                report.set(ISEXCEPTIONREPORT, (Object)Boolean.TRUE);
                if (null != printError && printError.length() > 8000) {
                    printError = printError.substring(0, 8000);
                }
                report.set(EXCEPTIONINFO, (Object)printError);
                DynamicObject queryNew = BusinessDataServiceHelper.newDynamicObject((String)HAED_ENTITYNAME);
                String sourceBillName = DapVoucherUtil.getBillTypeNameById(billEntityNumber);
                queryNew.set(SOURCEBILL, (Object)sourceBillName);
                queryNew.set(SOURCEBILLNUMBER, (Object)billEntityNumber);
                message = message != null ? (message.length() > 199 ? "" : message) : "";
                queryNew.set(ERRORRESULT, (Object)message);
                queryNew.set(BUILDSTATE, (Object)"1");
                queryNew.set(OPDATE, (Object)new Date());
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                queryNew.set(USERNAME, (Object)DapVoucherUtil.getUserNameById(userId));
                queryNew.set("traceid", (Object)traceId);
                if (StringUtils.isNotEmpty((CharSequence)templateId)) {
                    Long id = Long.parseLong(templateId);
                    Tuple<String, String> tuple = DapVoucherUtil.getVchTemplateById(id);
                    queryNew.set(VCHTEMPLATEID, (Object)templateId);
                    if (tuple != null) {
                        queryNew.set(VCHTEMPLATE, tuple.item1);
                        queryNew.set(VCHTEMPLATENO, tuple.item2);
                    }
                }
                queryNew.set(ISEXCEPTIONREPORT, (Object)"1");
                queryNew.set(EXCEPTIONINFO, (Object)printError);
                ArrayList<DynamicObject> resultNew = new ArrayList<DynamicObject>(1);
                resultNew.add(queryNew);
                DapVoucherUtil.saveExceptionReport(new DynamicObject[]{report}, resultNew);
            }
            catch (Exception exc) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)exc));
            }
            return;
        }
    }

    public static void generateNewExceptionReport(Exception e, String billEntityNumber, String message, String templateId) {
        DapVoucherUtil.generateNewExceptionReport(e, billEntityNumber, message, templateId, "");
    }

    public static String getBillNoFormBill(String billtype) {
        String billno = "billno";
        if (ThreadCache.exists((Object)billtype)) {
            billno = (String)ThreadCache.get((Object)billtype);
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            if (dataEntityType != null) {
                BillEntityType bnt = (BillEntityType)dataEntityType;
                billno = bnt.getBillNo();
            }
            ThreadCache.put((Object)billtype, (Object)billno);
        }
        return billno;
    }

    public static String getUserNameById(Long id) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.USER, BuildreportConfigContainer, id);
        String userName = LocalCacheHelper.get(cacheKey, String.class);
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            return userName;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (object != null) {
            userName = (String)object.get("name");
        }
        LocalCacheHelper.put(cacheKey, userName);
        return userName;
    }

    public static Tuple<String, String> getVchTemplateById(Long id) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.VCHTEMPALTE, BuildreportConfigContainer, id);
        Tuple tuple = LocalCacheHelper.get(cacheKey, Tuple.class);
        if (StringUtils.isNotBlank((Object)tuple)) {
            return tuple;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"ai_vchtemplate", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (object != null) {
            tuple = new Tuple((Object)object.getString("name"), (Object)object.getString("number"));
        }
        LocalCacheHelper.put(cacheKey, tuple);
        return tuple;
    }

    public static String getBillTypeNameById(String id) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.BILLTYPE, BuildreportConfigContainer, id);
        String billTypeName = LocalCacheHelper.get(cacheKey, String.class);
        if (StringUtils.isNotEmpty((CharSequence)billTypeName)) {
            return billTypeName;
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)id)});
        if (object != null) {
            billTypeName = (String)object.get("name");
        }
        LocalCacheHelper.put(cacheKey, billTypeName);
        return billTypeName;
    }

    public static DataSet queryBillId_VchGenerated(String billType, Collection<Long> orgId, Long periodId) {
        return DapVoucherUtil.queryBillIdVchWithLimitId(billType, orgId, periodId, null, null);
    }

    public static DataSet queryBillIdVchWithLimitId(String billType, Collection<Long> orgId, Long periodId, Long smallBillId, Long bigBillId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fsourcebillid billid from t_ai_daptracker where fbilltype = ?", new Object[]{billType});
        sql.appendIn(" and forgid ", orgId.toArray());
        if (null != periodId) {
            sql.append(" and fperiodid = ?", new Object[]{periodId});
        }
        if ("true".equalsIgnoreCase(SysParamConfig.get("ai.dap.open.reverse.voucher"))) {
            sql.append(" and freverseflag = ? ", new Object[]{"0"});
        }
        if (null != smallBillId && null != bigBillId) {
            sql.append(" and fsourcebillid >= ?", new Object[]{smallBillId});
            sql.append(" and fsourcebillid <= ?", new Object[]{bigBillId});
        }
        sql.append(" union ", new Object[0]);
        sql.append("select t1.fsrc_billid billid from t_fah_evt_tracker t1 join t_fah_ae_headers t2 on t1.fxla_header_id = t2.fid", new Object[0]);
        sql.append(" where t1.fsrc_billtype = ? ", new Object[]{billType});
        sql.append(" and t1.fstatus = ?", new Object[]{"4"});
        sql.append(" and t1.fReverseFlag = ?", new Object[]{"0"});
        if (null != periodId) {
            sql.append(" and t2.fperiodid = ?", new Object[]{periodId});
        }
        sql.appendIn(" and t2.forgid ", orgId.toArray());
        if (null != smallBillId && null != bigBillId) {
            sql.append(" and t1.fsrc_billid >= ?", new Object[]{smallBillId});
            sql.append(" and t1.fsrc_billid <= ?", new Object[]{bigBillId});
        }
        return DB.queryDataSet((String)"queryBillId_VchGenerated", (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sql);
    }
}

