/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.ReverseVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class ReverseVoucherService
extends EntityOperateService {
    private static final Log logger = LogFactory.getLog(ReverseVoucherService.class);

    protected void preparePropertys(List<String> fieldKeys) {
        if ("ai_event".equals(this.getBillEntityType().getName())) {
            fieldKeys.add("number");
        }
        super.preparePropertys(fieldKeys);
    }

    public OperationResult excute(Object[] ids) throws Exception {
        OperationResult or = super.excute(ids);
        if (or.getSuccessPkIds().isEmpty()) {
            logger.info(" ReverseVoucherService getSuccessPkIds() isEmpty");
            return or;
        }
        String paramStr = this.getOption().getVariableValue("ai_selectbookdate");
        HashSet<Long> idSet = new HashSet<Long>(ids.length);
        for (Object id : ids) {
            idSet.add(Long.parseLong(id.toString()));
        }
        Set failIdSet = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IReverseValidateService", (String)"validateReverseCondition", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), idSet});
        HashSet residueBillIds = new HashSet(idSet);
        residueBillIds.removeAll(failIdSet);
        Date start = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(start);
        date.set(13, date.get(13) - 1);
        if (residueBillIds.isEmpty()) {
            ReverseVoucherUtil.buildOperateResult(or, failIdSet, date.getTime());
            return or;
        }
        long superStart = System.currentTimeMillis();
        logger.info("ReverseVoucherService start...{}:", residueBillIds);
        String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IReverseVoucherService", (String)"reverseVoucher", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), residueBillIds, paramStr});
        logger.info("ReverseVoucherService end...{}:{}", (Object)errorMsg, (Object)(System.currentTimeMillis() - superStart));
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            for (Object pkId : residueBillIds) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(errorMsg);
                errorInfo.setPkValue(pkId);
                errorInfo.setTitle(ResManager.loadKDString((String)"\u51b2\u9500\u51ed\u8bc1", (String)"ReverseVoucherService_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                or.addErrorInfo(errorInfo);
            }
        } else {
            ReverseVoucherUtil.buildOperateResult(or, idSet, date.getTime());
        }
        return or;
    }

    protected void executeOperate(DynamicObject[] dynamics) {
    }
}

