/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahDeleteVoucherRequestTask;
import kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class FahDeleteVoucherValidator {
    private static final Log logger = LogFactory.getLog(FahDeleteVoucherValidator.class);

    public static List<OperateErrorInfo> newFahVoucherValidate(FahDeleteVoucherRequestTask requestTask) {
        ArrayList<OperateErrorInfo> result = new ArrayList<OperateErrorInfo>();
        if (!requestTask.getBillIds_event().isEmpty() && !LicenseServiceHelper.getLicenseModules().contains("2FMS=8GUFGGN")) {
            for (Long id : requestTask.getBillIds_event().stream().distinct().collect(Collectors.toList())) {
                String errorMessage = String.format(ResManager.loadKDString((String)"%s\uff1a\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahDeleteVoucherValidator_2", (String)"bos-ext-fi", (Object[])new Object[0]), requestTask.getBillIdAndNumberMap().get(id));
                result.add(FahDeleteVoucherValidator.genErrorInfo(errorMessage, id));
            }
            requestTask.removeErrorBillIds_event(result);
        }
        ArrayList<Long> notCompleteBillIds = new ArrayList<Long>();
        HashMap<Long, Integer> billCountMap = new HashMap<Long, Integer>();
        ArrayList<Long> hasReverseBills = new ArrayList<Long>();
        if ("ai_event".equals(requestTask.getBillType())) {
            for (Map.Entry<String, List<Long>> billTypeGroup : ExtDataQueryHelper.groupByBillType(requestTask.getBillIds()).entrySet()) {
                List<Long> subIdList = billTypeGroup.getValue();
                String billType = billTypeGroup.getKey();
                FahDeleteVoucherValidator.getBuildVchedBillInfo(subIdList, billType, notCompleteBillIds, billCountMap, hasReverseBills, requestTask.getNot_pushVoucher());
            }
        } else {
            FahDeleteVoucherValidator.getBuildVchedBillInfo(requestTask.getBillIds(), requestTask.getBillType(), notCompleteBillIds, billCountMap, hasReverseBills, requestTask.getNot_pushVoucher());
        }
        logger.info("--FAH--newFahVoucherValidate-----requestTask.getBillIds():{};requestTask.getBillType():{};notCompleteBillIds:{};hasReverseBills:{}", new Object[]{requestTask.getBillIds(), requestTask.getBillType(), notCompleteBillIds, hasReverseBills});
        logger.info("--FAH--newFahVoucherValidate-----billCountMap:{}", billCountMap);
        for (Long id : requestTask.getBillIds()) {
            String errorMessage;
            if (notCompleteBillIds.contains(id)) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff1a\u8bf7\u52fe\u9009\u5f85\u5220\u9664\u51ed\u8bc1\u5bf9\u5e94\u7684\u6240\u6709\u5355\u636e\uff0c\u672a\u52fe\u9009\u5355\u636e%2$d\u5f20\u3002", (String)"FahDeleteVoucherValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]), requestTask.getBillIdAndNumberMap().get(id), billCountMap.get(id));
                result.add(FahDeleteVoucherValidator.genErrorInfo(errorMessage, id));
                continue;
            }
            if (!hasReverseBills.contains(id)) continue;
            errorMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff1a\u5355\u636e\u5df2\u751f\u6210\u51b2\u9500\u51ed\u8bc1\uff0c\u4ec5\u652f\u6301\u51b2\u9500\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u51ed\u8bc1\u3002", (String)"FahDeleteVoucherValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]), requestTask.getBillIdAndNumberMap().get(id));
            result.add(FahDeleteVoucherValidator.genErrorInfo(errorMessage, id));
        }
        return result;
    }

    private static OperateErrorInfo genErrorInfo(String errorMessage, Long id) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(errorMessage);
        errorInfo.setPkValue((Object)id);
        errorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"DeleteVoucherService_4", (String)"bos-ext-fi", (Object[])new Object[0]));
        return errorInfo;
    }

    private static void getBuildVchedBillInfo(List<Long> billPks, String billType, List<Long> notCompleteBillIds, Map<Long, Integer> billCountMap, List<Long> hasReverseBills, List<Long> not_pushVoucherId) {
        if (billPks.isEmpty()) {
            return;
        }
        ArrayList<Long> newBills = new ArrayList<Long>(billPks);
        List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(newBills, 1000);
        HashMap<Long, Set<Long>> vchIdAndBillIds = new HashMap<Long, Set<Long>>();
        for (List<Long> batch : splitbatch) {
            FahVoucherDao.getVoucherInfo(billType, batch, vchIdAndBillIds, hasReverseBills, not_pushVoucherId);
        }
        logger.info("--FAH--getBuildVchedBillInfo--vchIdAndBillIds:{}", vchIdAndBillIds);
        newBills.removeAll(hasReverseBills);
        vchIdAndBillIds.values().forEach(f -> {
            if (!newBills.containsAll((Collection<?>)f)) {
                ArrayList data = new ArrayList(newBills);
                data.retainAll((Collection<?>)f);
                int i = f.size() - data.size();
                notCompleteBillIds.addAll(data);
                data.forEach(ff -> billCountMap.put((Long)ff, i));
            }
        });
    }
}

