/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class FahRequestTaskDao {
    public static Long createNewRequest(Long taskId, Collection<String> srcBillTypes, Collection<Long> orgIds, String operation, int billCnt, Date startDate, Date endDate) {
        Object[] param;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_request_task");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)obj);
        obj.set("id", (Object)taskId);
        obj.set("taskno", (Object)number);
        obj.set("status", (Object)"0");
        obj.set("requestbillcnt", (Object)billCnt);
        obj.set("tasktype", (Object)operation);
        obj.set("queryStartDate", (Object)startDate);
        obj.set("queryEndDate", (Object)endDate);
        obj.set("createtime", (Object)new Date());
        obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        Object pkValue = ((DynamicObject)result[0]).getPkValue();
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        if (!srcBillTypes.isEmpty()) {
            String sql = "insert into t_fah_request_task_bill (fpkid,fid,fbasedataid) values(?,?,?)";
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[srcBillTypes.size()], "t_fah_request_task_bill", srcBillTypes.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(srcBillTypes.size());
            int index1 = 0;
            for (String billType : srcBillTypes) {
                param = new Object[]{sequences[index1++], pkValue, billType};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)sql, params);
        }
        if (!orgIds.isEmpty()) {
            String sql2 = "insert into t_fah_request_task_org (fpkid,fid,fbasedataid) values(?,?,?)";
            Long[] sequences2 = (Long[])sReader.getSequences((Object[])new Long[orgIds.size()], "t_fah_request_task_org", orgIds.size());
            ArrayList<Object[]> params2 = new ArrayList<Object[]>(orgIds.size());
            int index2 = 0;
            for (Long orgId : orgIds) {
                param = new Object[]{sequences2[index2++], pkValue, orgId};
                params2.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)sql2, params2);
        }
        return (Long)pkValue;
    }

    public static void updateFahRequestTask(Long taskId, String message) {
        try (TXHandle h = TX.requiresNew();){
            try {
                String shortMsg = message.length() > 255 ? message.substring(0, 255) : message;
                DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)"update t_fah_request_task set fstatus = ?, fmsg = ?, fmsg_tag = ?, fexcuteendtime = ? where fid = ? ", (Object[])new Object[]{"8", shortMsg, message, new Date(), taskId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

