/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.botp.enums.AsstActTypeEnum;
import kd.bos.ext.fi.botp.enums.PaymentChannelEnum;
import kd.bos.ext.fi.botp.enums.SettleMentTypeEnum;
import kd.bos.ext.fi.botp.helper.BaseDataHelper;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.botp.helper.OrgHelper;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AgentPayBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(AgentPayBillConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        logger.info("\u6267\u884c\u4e0b\u63a8\u4ee3\u53d1\u5904\u7406BOTP");
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObjectCollection entry;
            DynamicObject org;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            targetBill.set("payeetypelist", targetBill.get("payeetype"));
            this.supplePayeeInfo(targetBill);
            DynamicObject payerAcctBank = targetBill.getDynamicObject("payeracctbank");
            if (payerAcctBank != null && CasHelper.isNotEmpty(payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks"))) {
                this.setValueIfAbsent(targetBill, "payerbank", payerAcctBank.getDynamicObject("bank"));
                this.setValueIfAbsent(targetBill, "openorg", payerAcctBank.getDynamicObject("openorg"));
            }
            if ((org = targetBill.getDynamicObject("org")) != null) {
                DynamicObject dpCurrency;
                DynamicObject currency;
                long orgId = org.getLong("id");
                DynamicObject baseCurrency = OrgHelper.getBaseCurrency(orgId);
                if (baseCurrency != null) {
                    targetBill.set("basecurrency", (Object)baseCurrency);
                }
                if ((currency = targetBill.getDynamicObject("currency")) != null && CasHelper.isNotEmpty(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency"))) {
                    targetBill.set("currency", (Object)currency);
                }
                if ((dpCurrency = targetBill.getDynamicObject("dpcurrency")) != null && CasHelper.isNotEmpty(dpCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)dpCurrency.getPkValue(), (String)"bd_currency"))) {
                    targetBill.set("dpcurrency", (Object)dpCurrency);
                }
                this.setPayCountryValue(targetBill);
                if (CasHelper.isEmpty(targetBill.getDynamicObject("exratetable"))) {
                    this.setDefaultExratetable(targetBill, orgId);
                }
                this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
                BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
                if (CasHelper.isEmpty(exchangeRate)) {
                    exchangeRate = BigDecimal.ONE;
                    String payquotation = "0";
                    if (currency != null && baseCurrency != null) {
                        long destCurrencyId;
                        boolean isCurrencyDifferent;
                        long srcCurrencyId = currency.getLong("id");
                        boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                        if (isCurrencyDifferent) {
                            Date exrateDate = targetBill.getDate("exratedate");
                            DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                            if (CasHelper.isNotEmpty(exrateTable)) {
                                Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                                exchangeRate = (BigDecimal)exchangeRateByTable.getRight();
                                payquotation = (String)exchangeRateByTable.getLeft();
                            }
                        }
                    }
                    targetBill.set("exchangerate", (Object)exchangeRate);
                    targetBill.set("payquotation", (Object)payquotation);
                }
                this.setValueIfAbsent(targetBill, "payquotation", "0");
                if (CasHelper.isEmpty(targetBill.getString("paymentchannel"))) {
                    this.setPaymentChannelValue(targetBill, payerAcctBank);
                }
                this.setDiffPayInfo(targetBill, orgId);
                this.calculateAmt(targetBill);
                DynamicObject paymentType = targetBill.getDynamicObject("paymenttype");
                if (paymentType != null) {
                    paymentType = BusinessDataServiceHelper.loadSingleFromCache((Object)paymentType.getPkValue(), (String)"cas_paymentbilltype", (String)"id,fundflowitem");
                    this.fillFundflowItem(targetBill, paymentType.getDynamicObject("fundflowitem"));
                }
            }
            if ((entry = targetBill.getDynamicObjectCollection("entry")) == null || entry.size() <= 0) continue;
            for (DynamicObject row : entry) {
                row.set("e_originalagententryid", row.get("id"));
                row.set("e_localamt2", (Object)"****");
                row.set("e_amount2", (Object)"****");
            }
        }
    }

    private void setPaymentChannelValue(DynamicObject targetBill, DynamicObject payerAcctBank) {
        String defChannel = "";
        DynamicObject settletype = targetBill.getDynamicObject("settletype");
        if (settletype != null) {
            settletype = BusinessDataServiceHelper.loadSingleFromCache((Object)settletype.getPkValue(), (String)"bd_settlementtype", (String)"settlementtype");
        }
        defChannel = payerAcctBank == null || settletype != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settletype.getString("settlementtype")) ? PaymentChannelEnum.COUNTER.getValue() : (payerAcctBank.getBoolean("isopenbank") ? PaymentChannelEnum.ONLINEBANK.getValue() : (payerAcctBank.getBoolean("issetbankinterface") ? PaymentChannelEnum.BEI.getValue() : PaymentChannelEnum.COUNTER.getValue()));
        targetBill.set("paymentchannel", (Object)defChannel);
    }

    private void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable(orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }

    private void setDiffPayInfo(DynamicObject targetBill, Long orgId) {
        DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
        if (targetBill.getBoolean("isdiffcur") && CasHelper.isNotEmpty(dpCurrency)) {
            BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
            if (CasHelper.isEmpty(dpExchangeRate)) {
                dpExchangeRate = BigDecimal.ONE;
                String dppayquotation = "0";
                DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
                if (CasHelper.isNotEmpty(baseCurrency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = dpCurrency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty(exrateTable)) {
                            Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                            dpExchangeRate = (BigDecimal)exchangeRateByTable.getRight();
                            dppayquotation = (String)exchangeRateByTable.getLeft();
                        }
                    }
                }
                targetBill.set("dpexchangerate", (Object)dpExchangeRate);
                targetBill.set("dppayquotation", (Object)dppayquotation);
            }
            this.setValueIfAbsent(targetBill, "dppayquotation", "0");
            BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
            if (CasHelper.isEmpty(agreedRate)) {
                agreedRate = BigDecimal.ONE;
                String agreedquotation = "0";
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (CasHelper.isNotEmpty(currency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = dpCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty(exrateTable)) {
                            Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                            agreedRate = (BigDecimal)exchangeRateByTable.getRight();
                            agreedquotation = (String)exchangeRateByTable.getLeft();
                        }
                    }
                }
                targetBill.set("agreedrate", (Object)agreedRate);
                targetBill.set("agreedquotation", (Object)agreedquotation);
            }
            this.setValueIfAbsent(targetBill, "agreedquotation", "0");
        } else {
            targetBill.set("dpcurrency", targetBill.get("currency"));
            targetBill.set("dpexchangerate", targetBill.get("exchangerate"));
            targetBill.set("agreedrate", (Object)BigDecimal.ONE);
        }
    }

    private void calculateAmt(DynamicObject targetBill) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        String payquotation = targetBill.getString("payquotation");
        for (DynamicObject rowInfo : entry) {
            if (rowInfo.get("e_amount") == null) continue;
            BigDecimal amount = rowInfo.getBigDecimal("e_amount");
            sumAmt = sumAmt.add(amount);
            BigDecimal localamt = basecurrency != null ? QuotationHelper.callToCurrency(amount, exchangeRate, payquotation, basecurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(amount, exchangeRate, payquotation, 10);
            if (BigDecimal.ZERO.compareTo(rowInfo.getBigDecimal("e_localamt")) == 0) {
                rowInfo.set("e_localamt", (Object)localamt);
            }
            sumLocalAmt = sumLocalAmt.add(localamt);
        }
        targetBill.set("payamount", (Object)sumAmt);
        if (BigDecimal.ZERO.compareTo(targetBill.getBigDecimal("localamt")) == 0) {
            targetBill.set("localamt", (Object)sumLocalAmt);
        }
        this.calculateDpAmt(targetBill);
    }

    private void calculateDpAmt(DynamicObject targetBill) {
        BigDecimal lossAmt;
        BigDecimal srcDplocalAmt;
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        BigDecimal payamount = targetBill.getBigDecimal("payamount");
        String agreedquotation = targetBill.getString("agreedquotation");
        String dppayquotation = targetBill.getString("dppayquotation");
        if (currency != null) {
            payamount = payamount.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = dpcurrency != null ? QuotationHelper.callToCurrency(payamount, agreedRate, agreedquotation, dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(payamount, agreedRate, agreedquotation, 10);
        BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = basecurrency != null ? QuotationHelper.callToCurrency(dpAmt, dpExchangeRate, dppayquotation, basecurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(dpAmt, dpExchangeRate, dppayquotation, 10);
        if (BigDecimal.ZERO.compareTo(targetBill.getBigDecimal("dpamt")) == 0) {
            targetBill.set("dpamt", (Object)dpAmt);
        }
        if (BigDecimal.ZERO.compareTo(srcDplocalAmt = targetBill.getBigDecimal("dplocalamt")) == 0) {
            targetBill.set("dplocalamt", (Object)dpLocalAmt);
            lossAmt = localAmt.subtract(dpLocalAmt);
        } else {
            lossAmt = localAmt.subtract(srcDplocalAmt);
        }
        targetBill.set("lossamt", (Object)lossAmt);
        this.calculateEntryDpAmt(targetBill);
    }

    private void calculateEntryDpAmt(DynamicObject targetBill) {
        Boolean isDiffCur = targetBill.getBoolean("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entry) {
            int rowIdx = row.getInt("seq") - 1;
            BigDecimal amount = row.getBigDecimal("e_amount");
            if (amount == null || amount.compareTo(new BigDecimal(0)) <= 0) continue;
            rowIndexs.add(rowIdx);
        }
        int size = rowIndexs.size();
        if (size <= 0) {
            return;
        }
        BigDecimal dpamt = targetBill.getBigDecimal("dpamt");
        BigDecimal dplocalamt = targetBill.getBigDecimal("dplocalamt");
        BigDecimal dpexchangerate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal agreedrate = targetBill.getBigDecimal("agreedrate");
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        String agreedquotation = targetBill.getString("agreedquotation");
        String dppayquotation = targetBill.getString("dppayquotation");
        BigDecimal sumDpamt = BigDecimal.ZERO;
        BigDecimal sumDpLocalamt = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            BigDecimal edplocalamt;
            BigDecimal edpamt;
            int rowIdx = (Integer)rowIndexs.get(i);
            DynamicObject row = (DynamicObject)entry.get(rowIdx);
            if (i == size - 1) {
                edpamt = dpamt.subtract(sumDpamt);
                edplocalamt = dplocalamt.subtract(sumDpLocalamt);
            } else {
                BigDecimal eamount = row.getBigDecimal("e_amount");
                edpamt = dpcurrency != null ? QuotationHelper.callToCurrency(eamount, agreedrate, agreedquotation, dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(eamount, agreedrate, agreedquotation, 10);
                sumDpamt = sumDpamt.add(edpamt);
                edplocalamt = basecurrency != null ? QuotationHelper.callToCurrency(edpamt, dpexchangerate, dppayquotation, basecurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(edpamt, dpexchangerate, dppayquotation, 10);
                sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
            }
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("e_dpamt")) == 0) {
                row.set("e_dpamt", (Object)edpamt);
            }
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("e_dplocalamt")) != 0) continue;
            row.set("e_dplocalamt", (Object)edplocalamt);
        }
    }

    private void setPayCountryValue(DynamicObject targetBill) {
        DynamicObject payerBank = targetBill.getDynamicObject("payerbank");
        if (payerBank != null && CasHelper.isEmpty(targetBill.getDynamicObject("paycountry")) && CasHelper.isNotEmpty(payerBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerBank.getPkValue(), (String)"bd_finorginfo", (String)"id,country"))) {
            targetBill.set("paycountry", (Object)payerBank.getDynamicObject("country"));
        }
    }

    private void supplePayeeInfo(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        String payeeType = targetBill.getString("payeetype");
        targetBill.set("ispersonpay", (Object)this.isPersonPay(payeeType));
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject rowInfo : entry) {
            DynamicObject bebank;
            DynamicObject payeebank = rowInfo.getDynamicObject("payeebank");
            if (CasHelper.isNotEmpty(payeebank) && CasHelper.isNotEmpty(bebank = BusinessDataServiceHelper.loadSingleFromCache((Object)payeebank.getPkValue(), (String)"bd_bebank"))) {
                this.setValueIfAbsent(rowInfo, "payeebanknumber", bebank.getString("union_number"));
                this.setValueIfAbsent(rowInfo, "reccountry", bebank.getDynamicObject("country") == null ? null : bebank.getDynamicObject("country").getPkValue());
                this.setValueIfAbsent(rowInfo, "recprovince", bebank.getString("provincetxt"));
                this.setValueIfAbsent(rowInfo, "reccity", bebank.getString("citytxt"));
                this.setValueIfAbsent(rowInfo, "recswiftcode", bebank.getString("swift_code"));
                this.setValueIfAbsent(rowInfo, "recroutingnum", bebank.getString("routingnum"));
                this.setValueIfAbsent(rowInfo, "recothercode", bebank.getString("other_code"));
                this.setValueIfAbsent(rowInfo, "recbankaddress", bebank.getString("address_eng"));
            }
            rowInfo.set("importpayeetype", (Object)this.getPayeeType(targetBill));
            DynamicObject payee = rowInfo.getDynamicObject("payee");
            if (!CasHelper.isNotEmpty(payee) || !this.isPayeeCustomer(targetBill) && !this.isPayeeSupplier(targetBill)) continue;
            Map<String, Object> resultMap = this.getPayeeInfo(payee.getPkValue(), this.getPayeeType(targetBill));
            this.setValueIfAbsent(rowInfo, "recemail", resultMap.get("payeeemail"));
            this.setValueIfAbsent(rowInfo, "recaddress", resultMap.get("payeeaddress"));
        }
    }

    private Map<String, Object> getPayeeInfo(Object payeeOrPayer, String payeeType) {
        DynamicObjectCollection addressls;
        DynamicObject supplierCustDO;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if ("bd_supplier".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        } else if ("bd_customer".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        } else {
            return resultMap;
        }
        if (!(CasHelper.isEmpty(entityNameTemp) || CasHelper.isEmpty(payeeOrPayer) || CasHelper.isEmpty(supplierCustDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeOrPayer, (String)entityNameTemp, (String)("entry_address." + addressPropName))) || (addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) == null || addressls.size() <= 0)) {
            HashSet<Object> addressIds = new HashSet<Object>();
            for (DynamicObject a : addressls) {
                addressIds.add(a.get(addressPropName + "_id"));
            }
            DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
            if (addresses != null) {
                for (DynamicObject address : addresses) {
                    if (!address.getBoolean("default")) continue;
                    resultMap.put("payeeemail", address.getString("addemail"));
                    resultMap.put("payeeaddress", address.getString("detailaddress"));
                    break;
                }
            }
        }
        return resultMap;
    }

    private void fillFundflowItem(DynamicObject targetBill, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject row : entry) {
            this.setValueIfAbsent(row, "e_fundflowitem", defaultFundsItem);
        }
    }

    private boolean isPayeeCustomer(DynamicObject targetBill) {
        return "bd_customer".equals(this.getPayeeType(targetBill));
    }

    private boolean isPayeeSupplier(DynamicObject targetBill) {
        return "bd_supplier".equals(this.getPayeeType(targetBill));
    }

    private String getPayeeType(DynamicObject targetBill) {
        return targetBill.getString("payeetypelist");
    }

    public void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty(targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private boolean isPersonPay(String payeeType) {
        logger.info("\u4ee3\u53d1\u5355\u662f\u5426\u5bf9\u79c1\u4ed8\u6b3e\u5224\u65ad\uff1apayeeType={}", (Object)payeeType);
        if (StringUtils.isEmpty((CharSequence)payeeType)) {
            return true;
        }
        if ("bos_user".equals(payeeType)) {
            return true;
        }
        return !"bd_supplier".equals(payeeType) && !"bd_customer".equals(payeeType) && !"bos_org".equals(payeeType) && !"other".equals(payeeType);
    }
}

