/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class CasHelper {
    public static boolean isEmpty(Object obj) {
        if (obj instanceof String && CasHelper.isEmpty((String)obj)) {
            return true;
        }
        if (obj instanceof Long && CasHelper.isEmpty((Long)obj)) {
            return true;
        }
        if (obj instanceof BigDecimal && CasHelper.isEmpty((BigDecimal)obj)) {
            return true;
        }
        if (obj instanceof Integer && CasHelper.isEmpty((Integer)obj)) {
            return true;
        }
        if (obj instanceof DynamicObjectCollection && CasHelper.isEmpty((Collection)((DynamicObjectCollection)obj))) {
            return true;
        }
        if (obj instanceof Collection && CasHelper.isEmpty((Collection)obj)) {
            return true;
        }
        if (obj instanceof Object[] && CasHelper.isEmpty((Object[])obj)) {
            return true;
        }
        return obj == null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Long l) {
        return l == null || l == 0L;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0;
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(DynamicObject info) {
        return info == null;
    }

    public static boolean isEmpty(BigDecimal l) {
        return l == null || l.compareTo(new BigDecimal("0")) == 0;
    }

    public static boolean isEmpty(Integer l) {
        return l == null || l == 0;
    }

    public static boolean isNotEmpty(Object o) {
        return !CasHelper.isEmpty(o);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(CasHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String idListToInClause(List<Long> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append(idList.get(0));
        } else {
            Iterator<Long> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String idsToInClause(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        if (idList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (idList.size() == 1) {
            sb.append('\'');
            sb.append(idList.get(0));
            sb.append('\'');
        } else {
            Iterator<String> it = idList.iterator();
            int n = idList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append('\'');
                sb.append(it.next());
                sb.append('\'');
                sb.append(", \n");
            }
            sb.append('\'');
            sb.append(it.next());
            sb.append('\'');
        }
        return sb.toString();
    }

    public static List<String> getIdList(DynamicObject[] infos) {
        ArrayList<String> idList = new ArrayList<String>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getPkValue().toString());
        }
        return idList;
    }

    public static DynamicObject loadSingleFromCache(Object pk, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
    }

    public static String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        e.printStackTrace(writer);
        writer.flush();
        return sw.toString();
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj2 == null && obj1 instanceof String) {
                return StringUtils.isBlank((Object)obj1);
            }
            if (obj1 == null && obj2 instanceof String) {
                return StringUtils.isBlank((Object)obj2);
            }
            return false;
        }
        if (obj1.getClass().equals(obj2.getClass())) {
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof DynamicObject) {
                return ((DynamicObject)obj1).getPkValue().equals(((DynamicObject)obj2).getPkValue());
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    public static String removeFieldPrefix(String field) {
        int index = field.indexOf(46);
        index = index > 0 ? ++index : 0;
        return field.substring(index);
    }

    public static <T> T[] mergeArrays(T[] t1, T[] t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + t2.length);
        for (int i = 0; i < t2.length; ++i) {
            copyOf[i + t1.length] = t2[i];
        }
        return copyOf;
    }

    public static <T> T[] mergeArrays(T[] t1, T t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + 1);
        copyOf[t1.length] = t2;
        return copyOf;
    }

    public static Long getCurrentUser() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static String getLocalValue(DynamicObject obj, String prop) {
        if (obj == null || CasHelper.isEmpty(prop)) {
            return "";
        }
        String localeValue = obj.getLocaleString(prop).getLocaleValue();
        if (CasHelper.isEmpty(localeValue)) {
            String value = obj.getString(prop);
            return CasHelper.isEmpty(value) ? "" : value;
        }
        return localeValue;
    }
}

