/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class CalFuncBatchBizBillPropPlugin
extends AbstractFuncParamPlugIn {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("entityobject", (Object)"bizentityobject");
        this.getModel().setValue("bizbillentryid", (Object)"entry.bizbillentryid");
    }

    public String getSetting() {
        String entityobject = (String)this.getModel().getValue("entityobject");
        String bizbillentryid = (String)this.getModel().getValue("bizbillentryid");
        String billfield = (String)this.getModel().getValue("billfield");
        String setting = String.format("%s(%s, %s, '%s')", this.getFuncId(), entityobject, bizbillentryid, billfield);
        return setting;
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String entityobject = (String)this.getModel().getValue("entityobject");
        String bizbillentryid = (String)this.getModel().getValue("bizbillentryid");
        String billfield = (String)this.getModel().getValue("billfield");
        if (StringUtils.isEmpty((CharSequence)entityobject) || StringUtils.isEmpty((CharSequence)bizbillentryid) || StringUtils.isEmpty((CharSequence)billfield)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalFuncBatchBizBillPropPlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billfield"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        if ("billfield".equals(key)) {
            MainEntityType mainType = this.getBillEntityType();
            if (mainType == null) {
                return;
            }
            PropTreeBuildOption option = new PropTreeBuildOption();
            new FormTreeBuilder();
            TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(tree, "billfield");
        }
    }

    private MainEntityType getBillEntityType() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            return null;
        }
        String billEntityTypeNumber = billType.getString("number");
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntityTypeNumber);
        return billEntityType;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billfield"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("billfield".equals(sourceFldKey) && returnData != null) {
            this.getModel().setValue("billfield", returnData);
        }
    }
}

