/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.closeperiod;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class RelatedBookQueryServiceHelper {
    public static Set<Long> queryGlAccountBook(String appNumId, long bizAccountBookId, long bizOrgId) {
        DynamicObjectCollection glAccountCols;
        QFilter qFilter;
        if (bizAccountBookId > 0L) {
            qFilter = new QFilter("b_entry.b_app", "=", (Object)appNumId);
            qFilter.and(new QFilter("b_entry.b_relatebook.fbasedataid", "=", (Object)bizAccountBookId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            glAccountCols = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (glAccountCols != null && !glAccountCols.isEmpty()) {
                return glAccountCols.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
        }
        if (bizOrgId > 0L) {
            qFilter = new QFilter("o_entry.o_app", "=", (Object)appNumId);
            qFilter.and(new QFilter("o_entry.o_relateorg.fbasedataid", "=", (Object)bizOrgId));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            glAccountCols = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (glAccountCols != null && !glAccountCols.isEmpty()) {
                return glAccountCols.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
        }
        return new HashSet<Long>();
    }

    public static Map<String, List<Long>> queryAllBizAccountBook(long glAccountBook) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>();
        QFilter qFilter = new QFilter("id", "=", (Object)glAccountBook);
        DynamicObject accountbook = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (QFilter[])new QFilter[]{qFilter});
        if (accountbook == null) {
            return resultMap;
        }
        DynamicObjectCollection bEntry = accountbook.getDynamicObjectCollection("b_entry");
        for (DynamicObject row : bEntry) {
            DynamicObject bApp = row.getDynamicObject("b_app");
            if (bApp == null) continue;
            DynamicObjectCollection relBookCols = row.getDynamicObjectCollection("b_relatebook");
            List bookList = relBookCols.stream().map(r -> r.getLong("fbasedataid_id")).collect(Collectors.toList());
            resultMap.put(bApp.getString("number"), bookList);
        }
        DynamicObjectCollection oEntry = accountbook.getDynamicObjectCollection("o_entry");
        for (DynamicObject row : oEntry) {
            DynamicObject oApp = row.getDynamicObject("o_app");
            if (oApp == null) continue;
            DynamicObjectCollection relOrgCols = row.getDynamicObjectCollection("o_relateorg");
            List orgList = relOrgCols.stream().map(r -> r.getLong("fbasedataid_id")).collect(Collectors.toList());
            resultMap.put(oApp.getString("number"), orgList);
        }
        return resultMap;
    }

    public static Set<Long> getRelatedAccountBookIds(String bizAppNumber, BookVO bizBook) {
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp(bizAppNumber);
        return GLAccountBookGetterFactory.getAccountBookGetter(bookRegisterInfo).getGLAccountBook(bookRegisterInfo, bizBook.getOrgId(), bizBook.getBookTypeId());
    }

    private static class GetAccountBookByBizBook
    implements IGLAccountBookGetter {
        private GetAccountBookByBizBook() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            DynamicObject bizBook = BusinessDataServiceHelper.loadSingle((String)bookRegisterInfo.getBookEntityId(), (String)"id", (QFilter[])new QFilter(bookRegisterInfo.getOrgFieldOnBookEntity(), "=", (Object)bizOrgId).and(bookRegisterInfo.getBookTypeFieldOnBookEntity(), "=", (Object)bizBookTypeId).toArray());
            if (bizBook == null) {
                return Collections.emptySet();
            }
            return RelatedBookQueryServiceHelper.queryGlAccountBook(BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), (Long)bizBook.getPkValue(), 0L);
        }
    }

    private static class GetAccountBookByBizBookWithoutBookType
    implements IGLAccountBookGetter {
        private GetAccountBookByBizBookWithoutBookType() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            DynamicObject bizBook = BusinessDataServiceHelper.loadSingle((String)bookRegisterInfo.getBookEntityId(), (String)"id", (QFilter[])new QFilter(bookRegisterInfo.getOrgFieldOnBookEntity(), "=", (Object)bizOrgId).toArray());
            if (bizBook == null) {
                return Collections.emptySet();
            }
            return RelatedBookQueryServiceHelper.queryGlAccountBook(BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), (Long)bizBook.getPkValue(), 0L);
        }
    }

    private static class GetAccountBookByBizOrg
    implements IGLAccountBookGetter {
        private GetAccountBookByBizOrg() {
        }

        @Override
        public Set<Long> getGLAccountBook(BookRegisterInfo bookRegisterInfo, Long bizOrgId, Long bizBookTypeId) {
            return RelatedBookQueryServiceHelper.queryGlAccountBook(BizAppServiceHelp.getAppIdByAppNumber((String)bookRegisterInfo.getBizApp()), 0L, bizOrgId);
        }
    }

    private static interface IGLAccountBookGetter {
        public Set<Long> getGLAccountBook(BookRegisterInfo var1, Long var2, Long var3);
    }

    private static class GLAccountBookGetterFactory {
        private GLAccountBookGetterFactory() {
        }

        public static IGLAccountBookGetter getAccountBookGetter(BookRegisterInfo bookRegisterInfo) {
            if (StringUtils.isEmpty((String)bookRegisterInfo.getBookEntityId())) {
                return new GetAccountBookByBizOrg();
            }
            if (StringUtils.isEmpty((String)bookRegisterInfo.getBookTypeFieldOnBookEntity())) {
                return new GetAccountBookByBizBookWithoutBookType();
            }
            return new GetAccountBookByBizBook();
        }
    }
}

