/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.invoice;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.invoice.IViewInvoicePlugin;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class PluginRegister {
    private static final Map<String, String> registerMap = new ConcurrentHashMap<String, String>(8);
    private static final Map<String, IViewInvoicePlugin> instanceMap = new ConcurrentHashMap<String, IViewInvoicePlugin>(8);
    private static final String DEFALUT_VIEW_PLUGIN_CLAZZ = "kd.bos.ext.fi.gl.invoice.PluginRegister$DefaultViewVoicePlugin";
    private static final String MC_KEY = String.format("%s_%s", RequestContext.get().getTenantId(), "fi.gl.invoiceconfig");

    private static void register(String appId, String clazz) {
        registerMap.put(appId, clazz);
    }

    private static void registerMCListener() {
        ConfigurationUtil.observeChange((String)MC_KEY, (key, newValue) -> {
            String configJson = System.getProperty(MC_KEY);
            if (StringUtils.isBlank((String)configJson)) {
                return;
            }
            LogFactory.getLog(PluginRegister.class).info("detect invoice config:{}", (Object)configJson);
            Map configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
            registerMap.putAll(configMap);
        });
    }

    public static IViewInvoicePlugin getPluginInstane(String appId) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String clazz = registerMap.getOrDefault(appId, DEFALUT_VIEW_PLUGIN_CLAZZ);
        instanceMap.putIfAbsent(clazz, (IViewInvoicePlugin)Class.forName(clazz).newInstance());
        return instanceMap.get(clazz);
    }

    static {
        PluginRegister.registerMCListener();
        PluginRegister.register("em", "kd.fi.er.mservice.voucher.ErViewInvoicePlugin");
        PluginRegister.register("ap", "kd.fi.ap.business.invoice.GlInvoiceViewImpl");
    }

    public static class DefaultViewVoicePlugin
    implements IViewInvoicePlugin {
        @Override
        public List<InvoiceResult> view(Map<String, List<Long>> billMap) {
            return Collections.emptyList();
        }
    }
}

