/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.dao.BookDAOFactory;
import kd.bos.ext.fi.gl.service.GLClosePeriodService;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.ext.fi.lock.ShareLockResult;
import kd.bos.ext.fi.operation.closeperiod.lock.ClosePeriodLockService;
import kd.bos.util.StringUtils;

public class AntiClosePeriodValidator
extends AbstractValidator {
    private final BookRegisterInfo bookRegisterInfo;
    private final List<ShareLockResult> shareLockResults;

    public AntiClosePeriodValidator(BookRegisterInfo bookRegisterInfo, List<ShareLockResult> shareLockResults) {
        this.bookRegisterInfo = bookRegisterInfo;
        this.shareLockResults = shareLockResults;
    }

    public void validate() {
        String orgProp = this.bookRegisterInfo.getOrgFieldOnCloseEntity();
        String bookTypeProp = this.bookRegisterInfo.getBookTypeFieldOnCloseEntity();
        String bizAppNumber = this.bookRegisterInfo.getBizApp();
        List<Long> orgIds = Arrays.stream(this.getDataEntities()).map(x -> x.getDataEntity().getLong(orgProp + ".id")).collect(Collectors.toList());
        Table<Long, Long, BookVO> books = BookDAOFactory.getBookDAO(bizAppNumber).query(bizAppNumber, orgIds, null);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            long orgId = data.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? data.getLong(bookTypeProp) : 0L;
            BookVO book = (BookVO)books.get((Object)orgId, (Object)bookTypeId);
            if (book == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u201c\u8d26\u7c3f\u201d\u4e0d\u5b58\u5728\u3002", (String)"AntiClosePeriodValidator_0", (String)"bos-ext-fi", (Object[])new Object[]{data.getString(orgProp + ".name")}));
                continue;
            }
            ShareLockResult shareLockResult = ClosePeriodLockService.requireLock(this.bookRegisterInfo.getBizApp(), orgId, bookTypeId, false, 600L);
            if (!shareLockResult.isLocked()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u201c\u8d26\u7c3f\u201d\u6b63\u5728\u201c\u7ed3\u8d26\u201d\u3001\u201c\u53cd\u7ed3\u8d26\u201d\u6216\u64cd\u4f5c\u51ed\u8bc1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AntiClosePeriodValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            } else {
                this.shareLockResults.add(shareLockResult);
            }
            if (!GLClosePeriodService.isRelatedAccountBookClosed(bizAppNumber, book, data.getLong("curperiod"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u201c\u603b\u8d26\u8d26\u7c3f\u201d\u5f53\u671f\u201c\u5df2\u7ed3\u8d26\u201d\uff0c\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u5141\u8bb8\u201c\u53cd\u7ed3\u8d26\u201d\u3002", (String)"AntiClosePeriodValidator_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
    }
}

