/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.ext.fi.gl.dao.BookDAOFactory;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodService;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.util.StringUtils;

public class BookInitialize
extends AbstractClosePeriodValidator {
    private final Table<Long, Long, ClosePeriodService.CloseData> closeDataTable;

    public BookInitialize(Table<Long, Long, ClosePeriodService.CloseData> closeDataTable) {
        this.closeDataTable = closeDataTable;
    }

    @Override
    public void doValidate() {
        Set errorIds = this.getValidateContext().getValidateResults().getValidateErrors().stream().flatMap(x -> x.getAllErrorInfo().stream().map(OperateInfo::getPkValue)).collect(Collectors.toSet());
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String orgProp = this.getBookRegisterInfo().getOrgFieldOnCloseEntity();
        String bookTypeProp = this.getBookRegisterInfo().getBookTypeFieldOnCloseEntity();
        List<Long> orgIdList = Arrays.stream(dataEntities).map(x -> x.getDataEntity().getLong(orgProp + ".id")).collect(Collectors.toList());
        String appNumber = this.getAppNumber();
        Table<Long, Long, BookVO> bookTable = BookDAOFactory.getBookDAO(appNumber).query(appNumber, orgIdList, null);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (errorIds.contains(dataEntity.getBillPkId())) continue;
            DynamicObject data = dataEntity.getDataEntity();
            long orgId = data.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? data.getLong(bookTypeProp + ".id") : 0L;
            BookVO bookVO = (BookVO)bookTable.get((Object)orgId, (Object)bookTypeId);
            if (bookVO == null) {
                this.addFlatError(dataEntity, orgId, bookTypeId, ResManager.loadKDString((String)"\u8d26\u7c3f\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"BookInitialize_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                continue;
            }
            ClosePeriodService.CloseData closeData = new ClosePeriodService.CloseData(bookVO);
            this.closeDataTable.put((Object)orgId, (Object)bookTypeId, (Object)closeData);
        }
    }
}

