/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.PriceTaxTotalCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BillToInvoiceArConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(BillToInvoiceArConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        super.afterConvert(e);
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey("ar_invoice")) {
            logger.info(String.format("ConvertPlugin source[%s]", entity.getValue("sourcebillno")));
            DynamicObject invoice = entity.getDataEntity();
            DynamicObject org = invoice.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            InitConvertHelper.checkExRate(this.getRule(), invoice);
            new InitConvertHelper(org, "ar_init", invoice, srcMainTypeName);
            DynamicObject basecurrency = invoice.getDynamicObject("basecurrency");
            int localprecision = basecurrency.getInt("amtprecision");
            DynamicObject currency = invoice.getDynamicObject("currency");
            int precision = currency.getInt("amtprecision");
            BigDecimal rate = invoice.getBigDecimal("exchangerate");
            boolean includeTax = invoice.getBoolean("isincludetax");
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal recamount = BigDecimal.ZERO;
            BigDecimal reclocalamt = BigDecimal.ZERO;
            DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal qty = entry.getBigDecimal("e_quantity");
                BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
                String discountMode = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
                AbstractPriceCalculator calculator = null;
                if (includeTax) {
                    BigDecimal pricetaxtotal = entry.getBigDecimal("e_recamount");
                    calculator = new PriceTaxTotalCalculator(qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else {
                    BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                }
                PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, rate, localprecision);
                localCalculator.calculate();
                BigDecimal e_tax = localCalculator.getTax();
                BigDecimal e_amount = localCalculator.getAmount();
                BigDecimal e_localamt = localCalculator.getAmountlocal();
                BigDecimal e_recamount = localCalculator.getPricetaxtotal();
                BigDecimal e_reclocalamt = localCalculator.getPricetaxtotallocal();
                entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                entry.set("e_tax", (Object)e_tax);
                entry.set("e_amount", (Object)e_amount);
                entry.set("e_localamt", (Object)e_localamt);
                entry.set("e_recamount", (Object)e_recamount);
                entry.set("e_reclocalamt", (Object)e_reclocalamt);
                entry.set("e_unverifiedwriteoffamt", (Object)e_reclocalamt);
                tax = tax.add(e_tax);
                amount = amount.add(e_amount);
                localamt = localamt.add(e_localamt);
                recamount = recamount.add(e_recamount);
                reclocalamt = reclocalamt.add(e_reclocalamt);
            }
            invoice.set("tax", (Object)tax);
            invoice.set("amount", (Object)amount);
            invoice.set("localamt", (Object)localamt);
            invoice.set("recamount", (Object)recamount);
            invoice.set("reclocalamt", (Object)reclocalamt);
        }
    }
}

