/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.FinPlanRowService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRow;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

@Deprecated
public class FinApDisposeDuePlanPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey("ap_finapbill")) {
            DynamicObject paymentCurrency;
            DynamicObject purorderbill;
            String sourcebillName;
            DynamicObject asstact;
            DynamicObject finAPBill = entity.getDataEntity();
            DynamicObject org = finAPBill.getDynamicObject("org");
            DynamicObject payorg = finAPBill.getDynamicObject("payorg");
            if (!ObjectUtils.isEmpty((Object)payorg) && !payorg.getBoolean("fisbankroll")) {
                finAPBill.set("payorg", null);
            }
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitConvertHelper.checkExRate(this.getRule(), finAPBill);
            new InitConvertHelper(org, "ap_init", finAPBill, srcMainTypeName);
            DynamicObject bascur = finAPBill.getDynamicObject("basecurrency");
            int baseprecision = bascur.getInt("amtprecision");
            int precision = finAPBill.getInt("currency.amtprecision");
            if (StringUtils.isEmpty((String)finAPBill.getString("duedate"))) {
                finAPBill.set("duedate", (Object)new Date());
            }
            DynamicObjectCollection entries = finAPBill.getDynamicObjectCollection("detailentry");
            boolean includeTax = finAPBill.getBoolean("isincludetax");
            BigDecimal exchangeRate = finAPBill.getBigDecimal("exchangerate");
            BigDecimal payableAmount = BigDecimal.ZERO;
            BigDecimal amountbase = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal unVerifyAmount = BigDecimal.ZERO;
            BigDecimal unSettleAmount = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal e_baseunitqty;
                PriceLocalCalculator localCalculator = null;
                AbstractPriceCalculator calculator = null;
                BigDecimal qty = entry.getBigDecimal("quantity");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                String discountMode = entry.getString("discountmode");
                BigDecimal discountRate = entry.getBigDecimal("discountrate");
                if (includeTax) {
                    BigDecimal taxUnitPrice = entry.getBigDecimal("pricetax");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
                } else {
                    BigDecimal unitPrice = entry.getBigDecimal("price");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
                }
                localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision);
                localCalculator.calculate();
                BigDecimal e_amountbase = localCalculator.getAmountlocal();
                BigDecimal e_pricetaxtotalbase = localCalculator.getPricetaxtotallocal();
                BigDecimal e_pricetaxtotal = localCalculator.getPricetaxtotal();
                BigDecimal e_amount = localCalculator.getAmount();
                BigDecimal e_tax = localCalculator.getTax();
                amountbase = amountbase.add(e_amountbase);
                pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
                payableAmount = payableAmount.add(e_pricetaxtotal);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                unVerifyAmount = unVerifyAmount.add(e_amount);
                unSettleAmount = unSettleAmount.add(e_pricetaxtotal);
                entry.set("actprice", (Object)localCalculator.getActunitprice());
                entry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                entry.set("discountamount", (Object)localCalculator.getDiscountamount());
                entry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                entry.set("e_amount", (Object)e_amount);
                entry.set("e_amountbase", (Object)e_amountbase);
                entry.set("e_tax", (Object)e_tax);
                entry.set("e_pricetaxtotal", (Object)e_pricetaxtotal);
                entry.set("unlockamt", (Object)localCalculator.getPricetaxtotal());
                entry.set("unsettleamt", (Object)localCalculator.getPricetaxtotal());
                entry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
                entry.set("e_unverifyamount", (Object)e_amount);
                entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                entry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
                BigDecimal quantity = entry.getBigDecimal("quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                BigDecimal covertRate = entry.getBigDecimal("e_unitconvertrate");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject measureUnit = entry.getDynamicObject("measureunit");
                DynamicObject baseUnit = null;
                if (!ObjectUtils.isEmpty((Object)material)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    covertRate = (covertRate = InitConvertHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"))) == null ? BigDecimal.ONE : covertRate;
                } else {
                    covertRate = BigDecimal.ONE;
                }
                BigDecimal e_unitcoefficient = entry.getBigDecimal("e_unitconvertrate");
                if (e_unitcoefficient == null || e_unitcoefficient.compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_unitconvertrate", (Object)covertRate);
                }
                if ((e_baseunitqty = entry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
                }
                entry.set("unverifyquantity", (Object)quantity);
            }
            finAPBill.set("pricetaxtotal", (Object)payableAmount);
            finAPBill.set("uninvoicedamt", (Object)payableAmount);
            finAPBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            finAPBill.set("amount", (Object)amount);
            finAPBill.set("amountbase", (Object)amountbase);
            finAPBill.set("tax", (Object)tax);
            finAPBill.set("unverifyamount", (Object)unVerifyAmount);
            finAPBill.set("unsettleamount", (Object)unSettleAmount);
            finAPBill.set("unsettleamountbase", (Object)pricetaxtotalbase);
            List<PlanRow> planList = this.calculatePlanRow(finAPBill);
            DynamicObjectCollection planentitys = finAPBill.getDynamicObjectCollection("planentity");
            if (planentitys.size() < 1) {
                this.updateFin(planList, finAPBill, baseprecision, precision);
            }
            if ((asstact = finAPBill.getDynamicObject("asstact")) == null && "pm_purorderbill".equals(sourcebillName = finAPBill.getString("sourcebilltype")) && !ObjectUtils.isEmpty((Object)(purorderbill = BusinessDataServiceHelper.loadSingleFromCache((String)sourcebillName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finAPBill.getString("sourcebillid"))})))) {
                asstact = purorderbill.getDynamicObject("supplier");
                finAPBill.set("asstact", (Object)asstact);
            }
            if (asstact == null) continue;
            String asstactType = asstact.getDataEntityType().getName();
            if (!"bd_supplier".equals(asstactType)) {
                finAPBill.set("paymentcurrency", (Object)finAPBill.getDynamicObject("currency"));
                continue;
            }
            Object asstactPk = asstact.getPkValue();
            DynamicObject asstactFieldValue = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
            if (ObjectUtils.isEmpty((Object)finAPBill.get("payeebanknum"))) {
                DynamicObjectCollection entryBanks = asstactFieldValue.getDynamicObjectCollection("entry_bank");
                String acctBank = null;
                DynamicObject bank = null;
                if (entryBanks.size() == 1) {
                    asstact = (DynamicObject)entryBanks.get(0);
                    acctBank = asstact.getString("bankaccount");
                    bank = asstact.getDynamicObject("bank");
                } else {
                    for (int i = 0; i < entryBanks.size(); ++i) {
                        asstact = (DynamicObject)entryBanks.get(i);
                        if (asstact.getBoolean("isdefault_bank")) {
                            acctBank = asstact.getString("bankaccount");
                            bank = asstact.getDynamicObject("bank");
                            break;
                        }
                        if (i != 0) continue;
                        acctBank = asstact.getString("bankaccount");
                        bank = asstact.getDynamicObject("bank");
                    }
                }
                finAPBill.set("payeebanknum", (Object)acctBank);
                finAPBill.set("bebank", (Object)bank);
            }
            if (!ObjectUtils.isEmpty((Object)finAPBill.get("paymentcurrency")) || ObjectUtils.isEmpty((Object)(paymentCurrency = asstactFieldValue.getDynamicObject("paymentcurrency")))) continue;
            finAPBill.set("paymentcurrency", (Object)paymentCurrency);
        }
    }

    private void updateFin(List<PlanRow> planRows, DynamicObject finAPBill, int baseprecision, int amtprecision) {
        Date planMaxDuedate = null;
        DynamicObject settlementType = finAPBill.getDynamicObject("settlementtype");
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtLoc = BigDecimal.ZERO;
        BigDecimal rate = finAPBill.getBigDecimal("exchangerate");
        for (int i = 0; i < planRows.size(); ++i) {
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ap_finapbill").findProperty("planentity");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            DynamicObject planEntry = new DynamicObject(dt);
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal planAmtLoc = planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP);
            amt = amt.add(planAmt.setScale(amtprecision, 4));
            amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal priceLoc;
                BigDecimal price;
                BigDecimal pricetaxtotal = finAPBill.getBigDecimal("pricetaxtotal");
                BigDecimal pricetaxtotalbase = finAPBill.getBigDecimal("pricetaxtotalbase");
                if (amt.compareTo(pricetaxtotal) > 0) {
                    price = amt.subtract(pricetaxtotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(pricetaxtotal) < 0) {
                    price = pricetaxtotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
                if (amtLoc.compareTo(pricetaxtotalbase) > 0) {
                    priceLoc = amtLoc.subtract(pricetaxtotalbase);
                    planAmtLoc = planAmtLoc.subtract(priceLoc);
                } else if (amtLoc.compareTo(pricetaxtotalbase) < 0) {
                    priceLoc = pricetaxtotalbase.subtract(amtLoc);
                    planAmtLoc = planAmtLoc.add(priceLoc);
                }
            }
            planEntry.set("seq", (Object)(i + 1));
            planEntry.set("planpricetax", (Object)planAmt);
            planEntry.set("unplanlockamt", (Object)planAmt);
            planEntry.set("unplansettleamt", (Object)planAmt);
            planEntry.set("planpricetaxloc", (Object)planAmtLoc);
            planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
            planEntry.set("planduedate", (Object)palnDuedate);
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
            } else if (palnDuedate != null) {
                planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
            }
            finAPBill.getDynamicObjectCollection("planentity").add((Object)planEntry);
        }
        if (planMaxDuedate != null) {
            finAPBill.set("duedate", planMaxDuedate);
        }
    }

    private List<PlanRow> calculatePlanRow(DynamicObject finAPBill) {
        FinPlanRowService planRowService = new FinPlanRowService();
        return planRowService.calculatePlanRows(finAPBill);
    }
}

