/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.SystemParameterHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class LqdLocAmtConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(LqdLocAmtConvertPlugin.class);
    private String targetEntityNumber;
    private final Map<Long, List<DynamicObject>> entriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        QFilter cusFilter;
        QFilter cusFilter2;
        String orgId;
        Map variablesMap;
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        if ("cas_recbill".equals(srcMainTypeName)) {
            variablesMap = this.getOption().getVariables();
            orgId = (String)variablesMap.get("orgId");
            if (!ObjectUtils.isEmpty((Object)orgId)) {
                e.setCustFilterExpression("billstatus ='D' and entry.e_settleorg = " + orgId + " and entry.e_receivingtype.ispartreceivable = true");
                cusFilter2 = new QFilter("entry.e_settleorg", "=", (Object)orgId);
                cusFilter2.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
                cusFilter2.and(new QFilter("billstatus", "=", (Object)"D"));
                e.getCustQFilters().add(cusFilter2);
            } else {
                e.setCustFilterExpression("billstatus ='D' and entry.e_receivingtype.ispartreceivable = true");
                cusFilter2 = new QFilter("billstatus", "=", (Object)"D");
                cusFilter2.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
                e.getCustQFilters().add(cusFilter2);
            }
        }
        if ("cas_paybill".equals(srcMainTypeName)) {
            variablesMap = this.getOption().getVariables();
            orgId = (String)variablesMap.get("orgId");
            if (!ObjectUtils.isEmpty((Object)orgId)) {
                e.setCustFilterExpression("billstatus in ('D','F','I') and entry.settleorg = " + orgId + " and entry.e_paymenttype.ispartpayment = true");
                cusFilter2 = new QFilter("entry.settleorg", "=", (Object)orgId);
                cusFilter2.and(new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}));
                cusFilter2.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
                e.getCustQFilters().add(cusFilter2);
            } else {
                e.setCustFilterExpression("billstatus in ('D','F','I') and entry.e_paymenttype.ispartpayment = true");
                cusFilter2 = new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"});
                cusFilter2.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
                e.getCustQFilters().add(cusFilter2);
            }
        }
        if ("ar_receivedbill".equals(srcMainTypeName)) {
            e.setCustFilterExpression("billstatus ='C' and rectype.ispartreceivable = true");
            cusFilter = new QFilter("billstatus", "=", (Object)"C");
            cusFilter.and(new QFilter("rectype.ispartreceivable", "=", (Object)Boolean.TRUE));
            e.getCustQFilters().add(cusFilter);
        }
        if ("ap_paidbill".equals(srcMainTypeName)) {
            e.setCustFilterExpression("billstatus ='C' and paymenttype.ispartpayment = true");
            cusFilter = new QFilter("billstatus", "=", (Object)"C");
            cusFilter.and(new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
            e.getCustQFilters().add(cusFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.targetEntityNumber);
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(extendEntites.length);
        HashMap<Long, List<DynamicObject>> billByOrgId = new HashMap<Long, List<DynamicObject>>(4);
        for (DynamicObject bill : entities) {
            Long orgId = bill.getLong("org.id");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                srcBillIds.add(entry.getLong("sourcebillid"));
            }
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List bills = billByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            bills.add(bill);
        }
        boolean needCheckClearAmtRange = this.isNeedCheckClearAmtRange(srcMainTypeName);
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> clearAmtRangeOrgMap = new HashMap(billByOrgId.size());
        HashMap<String, BigDecimal> clearAmtTotalBySrcBillNoHistory = new HashMap<String, BigDecimal>(8);
        if (needCheckClearAmtRange) {
            clearAmtRangeOrgMap = this.getclearAmtRangeOrgMap(new ArrayList<Long>(billByOrgId.keySet()));
            QFilter sourceBillFilter = new QFilter("entryentity.sourcebillid", "in", srcBillIds);
            QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"D");
            DataSet apDataSet = QueryServiceHelper.queryDataSet((String)"query-liquidation", (String)this.targetEntityNumber, (String)"entryentity.unsettleamt,entryentity.sourcebillno", (QFilter[])new QFilter[]{sourceBillFilter, billStatusFilter}, (String)"");
            for (Row row : apDataSet) {
                String sourceBillNo = row.getString("entryentity.sourcebillno");
                BigDecimal clearAmt = row.getBigDecimal("entryentity.unsettleamt");
                BigDecimal clearAmtTotal = (BigDecimal)clearAmtTotalBySrcBillNoHistory.get(sourceBillNo);
                if (ObjectUtils.isEmpty((Object)clearAmtTotal)) {
                    clearAmtTotalBySrcBillNoHistory.put(sourceBillNo, clearAmt);
                    continue;
                }
                clearAmtTotalBySrcBillNoHistory.put(sourceBillNo, clearAmtTotal.add(clearAmt));
            }
        }
        String initEntityNumber = this.isAp() ? "ap_init" : "ar_init";
        new InitConvertHelper(initEntityNumber, this.getRule(), billByOrgId);
        for (DynamicObject liquidationBill : entities) {
            DynamicObject org = liquidationBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                String message = ResManager.loadKDString((String)"\u8be5\u7ed3\u7b97\u7ec4\u7ec7\u6ca1\u6709\u751f\u6210\u6e05\u7406\u5355\u7684\u6743\u9650\u3002", (String)"LqdLocAmtConvertPlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]);
                ErrorCode ORG_NOTHAVE_LIQUIDATEPERMISSION = new ErrorCode("ORG_NOTHAVE_LIQUIDATEPERMISSION", message);
                throw new KDBizException(ORG_NOTHAVE_LIQUIDATEPERMISSION, new Object[0]);
            }
            DynamicObject bascur = liquidationBill.getDynamicObject("basecurrency");
            int baseprecision = bascur.getInt("amtprecision");
            BigDecimal exchangeRate = liquidationBill.getBigDecimal("exchangerate");
            String quotation = liquidationBill.getString("quotation");
            if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
                quotation = "0";
            }
            DynamicObjectCollection entry = liquidationBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                DynamicObject material = row.getDynamicObject("material");
                DynamicObject expenseitem = row.getDynamicObject("expenseitem");
                if (material != null) {
                    row.set("itemtype", (Object)"bd_material");
                    row.set("item", (Object)material);
                } else if (expenseitem != null) {
                    row.set("itemtype", (Object)"er_expenseitemedit");
                    row.set("item", (Object)expenseitem);
                }
                BigDecimal unsettleamt = row.getBigDecimal("unsettleamt");
                BigDecimal e_lqdlocalamt = BigDecimal.ZERO;
                e_lqdlocalamt = "1".equals(quotation) ? unsettleamt.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP) : unsettleamt.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP);
                row.set("e_lqdlocalamt", (Object)e_lqdlocalamt);
            }
            if (BOTPHelper.isPushAndSave(this.getRule(), liquidationBill)) {
                List<DynamicObject> entries = this.entriesCache.get(liquidationBill.getLong("id"));
                if (entries == null) {
                    ArrayList liquidateEntries = new ArrayList(8);
                    liquidateEntries.addAll(liquidationBill.getDynamicObjectCollection("entryentity"));
                    this.entriesCache.put(liquidationBill.getLong("id"), liquidateEntries);
                } else {
                    entries.addAll((Collection<DynamicObject>)liquidationBill.getDynamicObjectCollection("entryentity"));
                }
            }
            if (!needCheckClearAmtRange) continue;
            this.checkClearAmtRange(clearAmtRangeOrgMap, liquidationBill, org, clearAmtTotalBySrcBillNoHistory);
        }
        for (DynamicObject liquidationBill : entities) {
            this.setHeadAmtValue(liquidationBill);
        }
    }

    private void checkClearAmtRange(Map<Long, Tuple<BigDecimal, BigDecimal>> clearRangeAmtOrgMap, DynamicObject liquidationBill, DynamicObject org, Map<String, BigDecimal> clearAmtTotalBySrcBillNoHistory) {
        BigDecimal clearAmtTotal;
        String sourceBillNo;
        HashMap<String, BigDecimal> clearAmtTotalBySrcBillNo = new HashMap<String, BigDecimal>(8);
        List<Object> entries = BOTPHelper.isPushAndSave(this.getRule(), liquidationBill) ? this.entriesCache.get(liquidationBill.getLong("id")) : liquidationBill.getDynamicObjectCollection("entryentity");
        Long orgId = org.getLong("id");
        Tuple<BigDecimal, BigDecimal> clearRangeAmt = clearRangeAmtOrgMap.get(orgId);
        BigDecimal clearAmtDownRange = (BigDecimal)clearRangeAmt.item1;
        BigDecimal clearAmtUpRange = (BigDecimal)clearRangeAmt.item2;
        Iterator<Object> iterator = entries.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            sourceBillNo = dynamicObject.getString("sourcebillno");
            clearAmtTotal = (BigDecimal)clearAmtTotalBySrcBillNo.get(sourceBillNo);
            if (ObjectUtils.isEmpty((Object)clearAmtTotal)) {
                clearAmtTotalBySrcBillNo.put(sourceBillNo, dynamicObject.getBigDecimal("unsettleamt"));
                continue;
            }
            clearAmtTotalBySrcBillNo.put(sourceBillNo, clearAmtTotal.add(dynamicObject.getBigDecimal("unsettleamt")));
        }
        for (Map.Entry entry : clearAmtTotalBySrcBillNo.entrySet()) {
            sourceBillNo = (String)entry.getKey();
            clearAmtTotal = (BigDecimal)entry.getValue();
            if (clearAmtTotal.compareTo(clearAmtUpRange) <= 0 && clearAmtTotal.compareTo(clearAmtDownRange) >= 0) continue;
            BillEntityType srcMainType = this.getSrcMainType();
            String displayName = srcMainType.getDisplayName().getLocaleValue();
            if (this.isAp()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6e05\u7406\u5931\u8d25\uff1a\u672a\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u6e05\u7406\u8303\u56f4\uff0c\u5982\u9700\u7ee7\u7eed\u6e05\u7406\uff0c\u8bf7\u4fee\u6539\u7cfb\u7edf\u53c2\u6570-\u5e94\u4ed8-\u4ed8\u6b3e\u6e05\u7406\u8303\u56f4\u3002", (String)"LqdLocAmtConvertPlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]), displayName, sourceBillNo));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6e05\u7406\u5931\u8d25\uff1a\u672a\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u6e05\u7406\u8303\u56f4\uff0c\u5982\u9700\u7ee7\u7eed\u6e05\u7406\uff0c\u8bf7\u4fee\u6539\u7cfb\u7edf\u53c2\u6570-\u5e94\u6536-\u6536\u6b3e\u6e05\u7406\u8303\u56f4\u3002", (String)"LqdLocAmtConvertPlugin_2", (String)"bos-ext-fi", (Object[])new Object[0]), displayName, sourceBillNo));
        }
        for (Map.Entry entry : clearAmtTotalBySrcBillNo.entrySet()) {
            String srcBillNo = (String)entry.getKey();
            clearAmtTotal = ((BigDecimal)entry.getValue()).add(clearAmtTotalBySrcBillNoHistory.getOrDefault(srcBillNo, BigDecimal.ZERO));
            if (clearAmtTotal.compareTo(clearAmtUpRange) <= 0 && clearAmtTotal.compareTo(clearAmtDownRange) >= 0) continue;
            BillEntityType srcMainType = this.getSrcMainType();
            String displayName = srcMainType.getDisplayName().getLocaleValue();
            if (this.isAp()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6e05\u7406\u5931\u8d25\uff1a\u672a\u7ed3\u7b97\u91d1\u989d+\u5355\u636e\u5df2\u5173\u8054\u672a\u6e05\u9879\u6e05\u7406\u5355\u7684\u6e05\u7406\u91d1\u989d\u5408\u8ba1\uff0c\u4e0d\u5728\u6e05\u7406\u8303\u56f4\u5185\uff0c\u5982\u9700\u7ee7\u7eed\u6e05\u7406\uff0c\u8bf7\u4fee\u6539\u7cfb\u7edf\u53c2\u6570-\u5e94\u4ed8-\u4ed8\u6b3e\u6e05\u7406\u8303\u56f4\u3002", (String)"LqdLocAmtConvertPlugin_3", (String)"bos-ext-fi", (Object[])new Object[0]), displayName, srcBillNo));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s%2$s\u6e05\u7406\u5931\u8d25\uff1a\u672a\u7ed3\u7b97\u91d1\u989d+\u5355\u636e\u5df2\u5173\u8054\u672a\u6e05\u9879\u6e05\u7406\u5355\u7684\u6e05\u7406\u91d1\u989d\u5408\u8ba1\uff0c\u4e0d\u5728\u6e05\u7406\u8303\u56f4\u5185\uff0c\u5982\u9700\u7ee7\u7eed\u6e05\u7406\uff0c\u8bf7\u4fee\u6539\u7cfb\u7edf\u53c2\u6570-\u5e94\u6536-\u6536\u6b3e\u6e05\u7406\u8303\u56f4\u3002", (String)"LqdLocAmtConvertPlugin_4", (String)"bos-ext-fi", (Object[])new Object[0]), displayName, srcBillNo));
        }
    }

    public boolean isAp() {
        return this.targetEntityNumber.contains("ap_");
    }

    private boolean isNeedCheckClearAmtRange(String srcMainTypeName) {
        return "cas_paybill".equals(srcMainTypeName) || "ap_paidbill".equals(srcMainTypeName) || "cas_recbill".equals(srcMainTypeName) || "ar_receivedbill".equals(srcMainTypeName);
    }

    private Map<Long, Tuple<BigDecimal, BigDecimal>> getclearAmtRangeOrgMap(List<Long> orgIds) {
        Map<Long, Object> clearAmtDownRangeOrgMap;
        Map<Long, Object> clearAmtUpRangeOrgMap;
        HashMap<Long, Tuple<BigDecimal, BigDecimal>> clearAmtRangeOrgMap = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>(orgIds.size());
        if (this.isAp()) {
            clearAmtUpRangeOrgMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, orgIds, "ap_036");
            clearAmtDownRangeOrgMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, orgIds, "ap_037");
        } else {
            clearAmtUpRangeOrgMap = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, orgIds, "ar_033");
            clearAmtDownRangeOrgMap = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, orgIds, "ar_037");
        }
        for (Long orgId : orgIds) {
            BigDecimal clearAmtDownRange = new BigDecimal(clearAmtDownRangeOrgMap.get(orgId).toString());
            BigDecimal clearAmtUpRange = new BigDecimal(clearAmtUpRangeOrgMap.get(orgId).toString());
            clearAmtRangeOrgMap.put(orgId, (Tuple<BigDecimal, BigDecimal>)Tuple.create((Object)clearAmtDownRange, (Object)clearAmtUpRange));
        }
        return clearAmtRangeOrgMap;
    }

    private void setHeadAmtValue(DynamicObject liquidationBill) {
        logger.info("LqdLocAmtConvertPlugin.setHeadAmtValue start");
        BigDecimal liquidationAmt = BigDecimal.ZERO;
        BigDecimal liquidationlLocalAmt = BigDecimal.ZERO;
        Object entries = BOTPHelper.isPushAndSave(this.getRule(), liquidationBill) ? this.entriesCache.get(liquidationBill.getLong("id")) : liquidationBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            liquidationAmt = liquidationAmt.add(entry.getBigDecimal("unsettleamt"));
            liquidationlLocalAmt = liquidationlLocalAmt.add(entry.getBigDecimal("e_lqdlocalamt"));
        }
        liquidationBill.set("liquidationamt", (Object)liquidationAmt);
        liquidationBill.set("liquidationlocalamt", (Object)liquidationlLocalAmt);
        logger.info("LqdLocAmtConvertPlugin.setHeadAmtValue end");
    }
}

