/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.util.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class PriceTaxTotalCalculator
extends AbstractPriceCalculator {
    public PriceTaxTotalCalculator(BigDecimal quantity, BigDecimal pricetaxtotal, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.pricetaxtotal = pricetaxtotal.setScale(currencyPrecision, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    public PriceTaxTotalCalculator(BigDecimal quantity, BigDecimal pricetaxtotal, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.pricetaxtotal = pricetaxtotal.setScale(currencyPrecision, RoundingMode.HALF_UP);
        this.adjustamt = adjustamt;
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    public PriceTaxTotalCalculator(BigDecimal quantity, BigDecimal pricetaxtotal, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt, BigDecimal discountAmt) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.pricetaxtotal = pricetaxtotal.setScale(currencyPrecision, RoundingMode.HALF_UP);
        this.adjustamt = adjustamt;
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        if ("TOTAL".equals(discountmode)) {
            this.discountamount = discountAmt;
        }
    }

    public PriceTaxTotalCalculator(BigDecimal quantity, BigDecimal pricetaxtotal, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision, BigDecimal adjustamt, boolean isTax, BigDecimal discountAmt) {
        this.isTax = isTax;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.pricetaxtotal = pricetaxtotal.setScale(currencyPrecision, RoundingMode.HALF_UP);
        this.adjustamt = adjustamt;
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
        if ("TOTAL".equals(discountmode)) {
            this.discountamount = discountAmt;
        }
    }

    @Override
    public void calculate() {
        if (BigDecimal.ZERO.compareTo(this.quantity) == 0) {
            return;
        }
        BigDecimal actPriceTaxTotal = this.pricetaxtotal.subtract(this.adjustamt);
        this.tax = actPriceTaxTotal.multiply(this.taxrate).divide(ONE.add(this.taxrate), this.currencyPrecision, RoundingMode.HALF_UP);
        this.amount = actPriceTaxTotal.subtract(this.tax);
        if ("PERCENT".equals(this.discountmode)) {
            BigDecimal discountRate = this.discountrate.divide(ONE_HUNDRED);
            if (ONE.compareTo(discountRate) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387\uff08%\uff09\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PriceTaxTotalCalculator_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            this.taxunitprice = actPriceTaxTotal.divide(this.quantity, 10, RoundingMode.HALF_UP).divide(ONE.subtract(discountRate), 10, RoundingMode.HALF_UP);
            this.discountamount = this.taxunitprice.multiply(this.quantity).multiply(discountRate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.taxunitprice = actPriceTaxTotal.divide(this.quantity, 10, RoundingMode.HALF_UP).add(this.discountrate);
            this.discountamount = this.discountrate.multiply(this.quantity).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else {
            this.taxunitprice = actPriceTaxTotal.add(this.discountamount).divide(this.quantity, 10, RoundingMode.HALF_UP);
        }
        this.unitprice = this.taxunitprice.divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP);
        if (BigDecimal.ZERO.compareTo(this.discountamount) == 0) {
            this.actunitprice = this.unitprice;
            this.acttaxunitprice = this.taxunitprice;
        } else {
            this.actunitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP);
            this.acttaxunitprice = actPriceTaxTotal.divide(this.quantity, 10, RoundingMode.HALF_UP);
        }
    }
}

