/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.iep.info.IntellExecDetailLog;
import kd.fi.iep.info.IntellOperSumLog;

public class MessageServiceNew {
    private static final Log logger = LogFactory.getLog((String)"MessageServiceNew");

    public static void sendIntellShemaExecMessage(Long intelschemaId, Long sumLogId, List<IntellOperSumLog> operSumLogs, List<IntellExecDetailLog> intellexecdetaillogs) {
        QFilter fintelschemaidFilter = new QFilter("id", "=", (Object)intelschemaId);
        DynamicObject schemaSum = BusinessDataServiceHelper.loadSingle((String)"gl_intellexecschema", (String)StringUtils.join((Object[])new String[]{"id,number,name,executor", "notificationtypes", "notificationusers", "notificationconditions"}, (String)","), (QFilter[])new QFilter[]{fintelschemaidFilter});
        DynamicObjectCollection receivers = schemaSum.getDynamicObjectCollection("notificationusers");
        String name = schemaSum.getString("name");
        String msgSendTypes = schemaSum.getString("notificationtypes");
        if (receivers.isEmpty() || StringUtils.isEmpty((CharSequence)msgSendTypes)) {
            return;
        }
        long schemaId = schemaSum.getLong("id");
        long failLogCnt = intellexecdetaillogs.stream().filter(s -> Objects.equals(s.getExecstatus(), "3")).count();
        String sendConditions = schemaSum.getString("notificationconditions");
        logger.info(String.format("startFromSendMessagePlanExecutionSummarySendTask: %s-%s[%s], failLogCnt:%s, operSumLogs.size:%s", schemaId, sumLogId, sendConditions, failLogCnt, operSumLogs.size()));
        if (MessageServiceNew.isNeedSendNotification(sendConditions, failLogCnt, operSumLogs)) {
            String schemaName = schemaSum.getLocaleString("name").getLocaleValue();
            String[] channelStrs = msgSendTypes.split(",");
            ArrayList<MessageChannels> effectiveChannels = new ArrayList<MessageChannels>();
            for (String channleItem : channelStrs) {
                Optional<MessageChannels> validatedChannel = MessageServiceNew.channelNumberOf(channleItem);
                validatedChannel.ifPresent(effectiveChannels::add);
            }
            if (effectiveChannels.isEmpty()) {
                logger.warn(String.format("for intell schema: %s[%s], No effective message channel available.", schemaName, schemaId));
            }
            List<Long> userIds = receivers.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
            MessageInfo waitingMessage = MessageServiceNew.buildMessage(schemaId, MessageServiceNew.buildMessageContent(operSumLogs, name, intellexecdetaillogs), userIds, effectiveChannels);
            waitingMessage.setSenderId(Long.valueOf(schemaSum.getLong("executor_id")));
            List<MessageInfo> waitingMessageList = Collections.singletonList(waitingMessage);
            try {
                Map sendMsgResult = MessageCenterServiceHelper.batchSendMessages(waitingMessageList);
                boolean success = (Boolean)sendMsgResult.get("success");
                String description = (String)sendMsgResult.get("description");
                logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask: waitingMessageList.size: %s, success: %s, description: %s", waitingMessageList.size(), success, description));
                Map data = sendMsgResult.getOrDefault("data", new HashMap());
                if (!data.isEmpty()) {
                    List successMsgIds = data.getOrDefault("successMsgIds", new ArrayList());
                    for (Long successMsgId : successMsgIds) {
                        logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask-success: %s, messageID: %s", null, successMsgId));
                    }
                    Map failMsgs = data.getOrDefault("failMsgs", new HashMap());
                    for (Map.Entry failMsg : failMsgs.entrySet()) {
                        MessageInfo failMessageInfo = (MessageInfo)failMsg.getKey();
                        String failDescription = (String)failMsg.getValue();
                        logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask-fail: %s, messageID: %s, description: %s", JSONUtils.toString((Object)failMessageInfo), failMessageInfo.getId(), failDescription));
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.error("FailedSendMessagePlanExecutionSummarySendTask: " + JSONUtils.toString(waitingMessageList));
                }
                catch (IOException ex) {
                    logger.error("Failed to parse message: " + waitingMessageList);
                }
            }
        }
    }

    private static String buildMessageContent(List<IntellOperSumLog> operSumLogs, String name, List<IntellExecDetailLog> intellexecdetaillogs) {
        boolean allSuccess = MessageServiceNew.isAllSuccess(operSumLogs);
        if (allSuccess) {
            return MessageServiceNew.buildSuccessMessageContent(name, operSumLogs);
        }
        return MessageServiceNew.buildFailMessageContent(name, intellexecdetaillogs);
    }

    private static String buildSuccessMessageContent(String planName, List<IntellOperSumLog> operSumLogs) {
        StringBuilder successMsg = new StringBuilder();
        successMsg.append(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u3010%1$s\u3011\u7684", (String)"PlanExecutionSummarySendTask_4", (String)"bos-ext-fi", (Object[])new Object[0]), planName));
        String success = operSumLogs.stream().filter(s -> Objects.equals(s.getExecstatus(), "2")).map(IntellOperSumLog::getOpername).collect(Collectors.joining(","));
        successMsg.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"PlanExecutionSummarySendTask_6", (String)"bos-ext-fi", (Object[])new Object[0]), success));
        return successMsg.toString();
    }

    private static String buildFailMessageContent(String name, List<IntellExecDetailLog> intellexecdetaillogs) {
        StringBuilder msgContent = new StringBuilder();
        msgContent.append(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u3010%1$s\u3011\u7684", (String)"PlanExecutionSummarySendTask_4", (String)"bos-ext-fi", (Object[])new Object[0]), name));
        Map groupByOper = intellexecdetaillogs.stream().limit(1000L).filter(s -> Objects.equals(s.getExecstatus(), "3")).collect(Collectors.groupingBy(IntellExecDetailLog::getOpername, Collectors.toList()));
        for (Map.Entry entry : groupByOper.entrySet()) {
            String opername = entry.getKey();
            List value = entry.getValue();
            msgContent.append(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c", (String)"PlanExecutionSummarySendTask_5", (String)"bos-ext-fi", (Object[])new Object[0]), opername));
            Map collect = value.stream().collect(Collectors.groupingBy(IntellExecDetailLog::getExecdetail, Collectors.toList()));
            for (Map.Entry e : collect.entrySet()) {
                String execdetail = e.getKey();
                List v = e.getValue();
                String operFailReason = String.format(ResManager.loadKDString((String)"%1$s%2$s\u56e0\u4e3a\u3010%3$s\u3011\u6267\u884c\u5931\u8d25\uff0c", (String)"PlanExecutionSummarySendTask_7", (String)"bos-ext-fi", (Object[])new Object[0]), ((IntellExecDetailLog)v.get(0)).getBussinessName(), "\u3010" + v.stream().map(IntellExecDetailLog::getSrcbillnumber).collect(Collectors.joining("\uff0c")) + "\u3011", execdetail);
                msgContent.append(operFailReason);
            }
        }
        msgContent.append(ResManager.loadKDString((String)"\u8bf7\u5904\u7406\u3002", (String)"PlanExecutionSummarySendTask_8", (String)"bos-ext-fi", (Object[])new Object[0]));
        return msgContent.toString();
    }

    private static MessageInfo buildMessage(Long schemaId, String msgContent, List<Long> receiveUserIds, List<MessageChannels> sendChannels) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u6267\u884c\u63d0\u9192", (String)"PlanExecutionSummarySendTask_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        message.setContent(msgContent);
        LocaleString tag = new LocaleString();
        message.setMessageTag((ILocaleString)tag);
        message.setTag(ResManager.loadKDString((String)"\u7d27\u6025", (String)"PlanExecutionSummarySendTask_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        message.setUserIds(receiveUserIds);
        message.setType("alarm");
        message.setEntityNumber("gl_intellexecschema");
        message.setOperation("modify");
        message.setBizDataId(schemaId);
        message.setPubaccNumber("flowassist");
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=base&&pkId=%s&caption=%s", "gl_intellexecschema", schemaId, ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u65b9\u6848", (String)"PlanExecutionSummarySendTask_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        message.setContentUrl(contentUrl);
        message.setNotifyType(StringUtils.join((Object[])sendChannels.stream().map(MessageChannels::getNumber).distinct().toArray(), (String)","));
        return message;
    }

    private static boolean isNeedSendNotification(String sendConditions, long failedCnt, List<IntellOperSumLog> operSumLogs) {
        if (StringUtils.isEmpty((CharSequence)sendConditions)) {
            return false;
        }
        List<String> conditionList = Arrays.asList(sendConditions.split(","));
        if (failedCnt > 0L && conditionList.contains("fail")) {
            return true;
        }
        return conditionList.contains("success") && operSumLogs.stream().filter(s -> "2".equals(s.getExecstatus())).count() == (long)operSumLogs.size();
    }

    private static boolean isAllSuccess(List<IntellOperSumLog> operSumLogs) {
        return operSumLogs.stream().filter(s -> "2".equals(s.getExecstatus())).count() == (long)operSumLogs.size();
    }

    private static Optional<MessageChannels> channelNumberOf(String number) {
        for (MessageChannels channel : MessageChannels.values()) {
            if (!channel.getNumber().equals(number)) continue;
            return Optional.of(channel);
        }
        return Optional.empty();
    }
}

