/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;

public class IntellExecuteUtil {
    public static void removeStopFlag(long schemaId) {
        IAppCache cache = AppCache.get((String)"iep");
        cache.remove(IntellExecuteUtil.getCacheKey(schemaId));
    }

    public static boolean isStopExcute(IntellSchemeExecInfo schemeExecInfo) {
        IntellExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        if (exceOperInfo.isStopRuning()) {
            return true;
        }
        boolean isManualStop = "stop".equals(IntellExecuteUtil.getSchemaFlag(exceOperInfo.getSchemaId()));
        if (ExecuteType.AUTO == exceOperInfo.getExecuteType()) {
            boolean isStop = isManualStop || IntellExecuteUtil.getSecondByTime() >= exceOperInfo.getStopStartTime() && IntellExecuteUtil.getSecondByTime() <= exceOperInfo.getStopEndTime();
            exceOperInfo.setStopRuning(isStop);
        }
        if (ExecuteType.MANUAL == exceOperInfo.getExecuteType()) {
            exceOperInfo.setStopRuning(isManualStop);
        }
        if (exceOperInfo.isStopRuning()) {
            IntellAccountSchemaExecLogDao.stopExecuteSchema(schemeExecInfo);
            schemeExecInfo.setExecuteStatus(ExecuteStatus.STOP);
        }
        return exceOperInfo.isStopRuning();
    }

    public static Integer getSecondByTime() {
        Date d = new Date();
        SimpleDateFormat sbf = new SimpleDateFormat("HH:mm:ss");
        String format = sbf.format(d);
        String[] split = format.split(":");
        return Integer.parseInt(split[0]) * 3600 + Integer.parseInt(split[1]) * 60 + Integer.parseInt(split[2]);
    }

    public static String getSchemaFlag(long schemaId) {
        IAppCache cache = AppCache.get((String)"iep");
        return (String)cache.get(IntellExecuteUtil.getCacheKey(schemaId), String.class);
    }

    public static String getCacheKey(long schemaId) {
        return "iep-intllaccountschema-" + schemaId + "stop-flag";
    }
}

