/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.atomop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.mmc.atomop.IAtomServLightHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;

public abstract class AtomServLightAbstractHandler
implements IAtomServLightHandler {
    private static final String CLASS_NAME = "AtomServLightHandler";
    private static final Log logger = LogFactory.getLog(AtomServLightAbstractHandler.class);

    @Override
    public List<IOperationServicePlugIn> createWorker(String billid, String opnum) {
        try {
            return this.create(billid, opnum);
        }
        catch (Exception ex) {
            TXHandle tx = TX.requiresNew((String)"mpdm_atomserv");
            Throwable var = this.logTry(ex, tx);
            if (var != null) {
                throw new KDException(var, new ErrorCode(CLASS_NAME, var.getMessage() != null ? var.getMessage() : var.toString()), new Object[0]);
            }
            throw new KDException((Throwable)ex, new ErrorCode(CLASS_NAME, ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable logTry(Exception ex, TXHandle tx) {
        Exception var = null;
        try {
            this.log(ex);
        }
        catch (Exception var35) {
            tx.markRollback();
            ex.addSuppressed(var35);
            var = ex;
        }
        finally {
            if (var != null) {
                try {
                    tx.close();
                }
                catch (Exception var34) {
                    var.addSuppressed(var34);
                }
            } else {
                tx.close();
            }
        }
        return var;
    }

    protected abstract List<IOperationServicePlugIn> create(String var1, String var2);

    private void log(Exception ex) {
        String title = ex.getCause() == null ? (ex.getMessage() != null ? ex.getMessage() : ex.toString()) : ex.getCause().toString();
        String detail = ex instanceof KDException ? ((KDException)ex).getStackTraceMessage() : ex.toString() + "\n" + Arrays.toString(ex.getStackTrace());
        this.log(title, ResManager.loadKDString((String)"\u5806\u6808\u4fe1\u606f", (String)"AtomServLightAbstractHandler_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), detail);
    }

    protected void log(String title, String detailHead, String detail) {
        StringBuilder sf = new StringBuilder();
        sf.append("mmc_box_ext.AtomServLightAbstractHandler.log: ");
        sf.append("status=error").append("\r\n");
        sf.append("org=").append(RequestContext.get().getOrgId()).append("\r\n");
        sf.append("user=").append(RequestContext.get().getCurrUserId()).append("\r\n");
        sf.append("occurtime=").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).append("\r\n");
        sf.append("stacktrace=").append(detailHead.length() > 250 ? detailHead.substring(0, 250) : detailHead).append("\r\n");
        sf.append("title=").append(title.length() > 250 ? title.substring(0, 250) : title).append("\r\n");
        sf.append("stacktrace_tag=").append(detail).append("\r\n");
        logger.info(sf.toString());
    }

    protected void setInparam(String inparam, IOperationServicePlugIn plugin) {
        if (!StringUtils.isBlank((CharSequence)inparam)) {
            try {
                Map params = (Map)JSON.parseObject((String)inparam, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                for (Map.Entry entry : params.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    plugin.getOption().setVariableValue(key, val);
                }
            }
            catch (Exception e) {
                String msg = String.format(ResManager.loadKDString((String)"\u53c2\u6570\uff1a\u201c%1$s\u201d\u4e3a\u65e0\u6cd5\u89e3\u6790\u4e3a\u5408\u6cd5\u5b57\u7b26\u4e32\u3002", (String)"AtomServLightAbstractHandler_3", (String)"bos-ext-mmc", (Object[])new Object[0]), inparam);
                throw new KDBizException((Throwable)e, new ErrorCode(CLASS_NAME, msg + " [ " + (e.getMessage() != null ? e.getMessage() : e.toString()) + " ]"), new Object[0]);
            }
        }
    }

    private long getLogNum() {
        ORM orm = ORM.create();
        return orm.genLongId("mpdm_atmolog");
    }
}

