/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.func;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CheckRequireTypeTraceWay
implements BOSUDFunction {
    private static final Log logger = LogFactory.getLog(CheckRequireTypeTraceWay.class);
    private ExpressionContext expContext;
    public static final String BD_REQUIRETYPE = "bd_requiretype";

    public CheckRequireTypeTraceWay() {
    }

    public CheckRequireTypeTraceWay(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public String getName() {
        return "CheckRequireTypeTraceWay";
    }

    public BOSUDFunction getInstance(ExpressionContext arg0) {
        return new CheckRequireTypeTraceWay(this.expContext);
    }

    public Object call(Object ... arg0) {
        boolean exist = false;
        if (arg0[0] == null || arg0[0].equals("") || arg0[1] == null || arg0[1].equals("")) {
            return exist;
        }
        Object requireTypeObj = arg0[0];
        String traceWayNumber = arg0[1].toString();
        Long requireTypeId = null;
        if (requireTypeObj instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)requireTypeObj;
            requireTypeId = org.getLong("id");
        } else if (requireTypeObj instanceof Long) {
            requireTypeId = (Long)requireTypeObj;
        }
        logger.info("[CheckRequireTypeTraceWay]requireTypeId:" + String.valueOf(requireTypeId) + "traceWayNumber:" + traceWayNumber);
        exist = this.checkRequireTypeTraceWay(requireTypeId, traceWayNumber);
        return exist;
    }

    private boolean checkRequireTypeTraceWay(Long requireTypeId, String traceWayNumber) {
        DynamicObject requireType = BusinessDataServiceHelper.loadSingleFromCache((String)BD_REQUIRETYPE, (String)"id,traceway", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)requireTypeId)});
        Optional<DynamicObject> optional = Optional.ofNullable(requireType);
        if (optional.isPresent()) {
            DynamicObjectCollection traceWayCols = optional.get().getDynamicObjectCollection("traceway");
            for (DynamicObject traceWayCol : traceWayCols) {
                Optional<DynamicObject> optionalTraceWay = Optional.ofNullable(traceWayCol.getDynamicObject("fbasedataid"));
                if (!optionalTraceWay.isPresent() || !traceWayNumber.equals(optionalTraceWay.get().getString("number"))) continue;
                return true;
            }
        }
        return false;
    }
}

