/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.ext.mmc.cache.ManustrConfigCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class AutoGenTrackNumberOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(AutoGenTrackNumberOpAction.class);
    private Set<String> delTrackNumbers = new HashSet<String>(16);
    private boolean isFromListOP = false;
    private List<DynamicObject[]> listBills = new ArrayList<DynamicObject[]>(16);
    private Map<String, Object> sns;
    private Map<String, Object> params;
    private DynamicObject rule;
    private static final String BILLS = "bills";
    private static final String BILL_NUMBER = "billNumber";
    private static final String BILL_TYPE = "billType";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTRYNAME = "entryName";
    private static final String RULE = "rule";
    private static final String COL_MATERIAL = "materialColName";
    private static final String COL_SEQ = "seqColName";
    private static final String COL_TRACKNUMBER = "tracknumberColName";
    private static final String COL_REQUIRETYPE = "requiretypeColName";
    public static final String GZ001 = "GZ001";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        this.rule = this.getRule();
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(this.billEntityType.getName());
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        if (this.rule == null || manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return;
        }
        if (this.params == null) {
            this.params = this.getBillParamsNew(fieldMapList, this.rule, this.billEntityType.getName());
        }
        if (this.params != null) {
            e.getFieldKeys().add(this.params.get(COL_TRACKNUMBER).toString());
            e.getFieldKeys().add(this.params.get(COL_SEQ).toString());
            e.getFieldKeys().add(this.params.get(COL_MATERIAL).toString());
            e.getFieldKeys().add(this.params.get(COL_REQUIRETYPE).toString());
        }
        this.isFromListOP = true;
    }

    private Map<String, Object> getBillParamsNew(List<Map<String, String>> fieldMapList, DynamicObject rule, String entityName) {
        String entryName = "";
        String materialColName = "";
        String tracknumberColName = "";
        String billNumber = "billno";
        String seqColName = "seq";
        String requiretypeColName = "";
        Map propertyMap = this.billEntityType.getAllEntities();
        HashMap<String, Object> returnParams = new HashMap<String, Object>(16);
        for (Map<String, String> fieldMap : fieldMapList) {
            if (!fieldMap.containsKey(GZ001)) continue;
            for (Map.Entry<String, String> fieldEntry : fieldMap.entrySet()) {
                String key = fieldEntry.getKey();
                String[] fields = fieldEntry.getValue().split("\\.");
                if (fields.length <= 0) continue;
                boolean isEntryField = this.isEntryField(propertyMap, fields);
                String colName = "";
                if (isEntryField) {
                    colName = fields[0] + '.' + fields[1];
                    entryName = fields[0];
                } else {
                    colName = fields[0];
                }
                switch (key) {
                    case "GZ001": {
                        tracknumberColName = colName;
                        break;
                    }
                    case "GZ005": {
                        materialColName = colName;
                        break;
                    }
                    case "GZ009": {
                        requiretypeColName = colName;
                        break;
                    }
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)materialColName) || StringUtils.isBlank((CharSequence)tracknumberColName) || StringUtils.isBlank((CharSequence)requiretypeColName)) {
            return null;
        }
        returnParams.put(ENTITYNAME, entityName);
        returnParams.put(ENTRYNAME, entryName);
        returnParams.put(COL_SEQ, seqColName);
        returnParams.put(COL_MATERIAL, materialColName);
        returnParams.put(COL_TRACKNUMBER, tracknumberColName);
        returnParams.put(BILL_NUMBER, billNumber);
        returnParams.put(COL_REQUIRETYPE, requiretypeColName);
        returnParams.put(RULE, rule);
        return returnParams;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        e.getDataEntities();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        Map<String, Object> manustrConfigFieldMap = null;
        if (this.params == null) {
            this.rule = this.getRule();
            manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(this.billEntityType.getName());
        }
        if (this.rule == null || manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return;
        }
        this.params = this.getBillParamsNew(fieldMapList, this.rule, this.billEntityType.getName());
        if (this.params == null) {
            return;
        }
        if (this.params.get(BILL_TYPE) == null) {
            this.params.put(BILL_TYPE, this.getBillType(bills[0], this.billEntityType.getName()));
        }
        long timer1 = System.currentTimeMillis();
        this.params.put(BILLS, bills);
        long timer2 = System.currentTimeMillis();
        log.info(String.format("AutoGenTrackNumberOpAction-beginOperationTransaction-92: %s\u6beb\u79d2", timer2 - timer1));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.sns = this.invokeTrackNumberService(this.params);
            }
            catch (Exception exc) {
                txHandle.markRollback();
                throw exc;
            }
        }
        long timer3 = System.currentTimeMillis();
        log.info(String.format("AutoGenTrackNumberOpAction-beginOperationTransaction-105: %s\u6beb\u79d2", timer3 - timer2));
        if (this.sns == null || this.sns.size() == 0) {
            return;
        }
        if (this.sns.get("ERROR") != null) {
            throw new KDBizException(this.sns.get("ERROR") == null ? "" : this.sns.get("ERROR").toString());
        }
        this.delTrackNumbers.clear();
        this.delTrackNumbers = (Set)this.sns.get("DELTRACKNUMBER");
        String[] trackCols = this.params.get(COL_TRACKNUMBER).toString().split("\\.");
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject dataEntity = bills[i];
            if (dataEntity == null) continue;
            if (trackCols.length == 1) {
                if (this.sns.get(dataEntity.getPkValue().toString()) == null) continue;
                dataEntity.set(trackCols[0], this.sns.get(dataEntity.getPkValue().toString()));
                continue;
            }
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection(this.params.get(ENTRYNAME).toString());
            if (billEntry == null) continue;
            for (DynamicObject dynamicObject : billEntry) {
                if (this.sns.get(dynamicObject.getPkValue().toString()) == null) continue;
                dynamicObject.set(trackCols[1], this.sns.get(dynamicObject.getPkValue().toString()));
            }
        }
        long timer4 = System.currentTimeMillis();
        log.info(String.format("AutoGenTrackNumberOpAction-beginOperationTransaction-133: %s\u6beb\u79d2", timer4 - timer3));
    }

    private Map<String, Object> invokeTrackNumberService(Map params) {
        String operationKey = (String)this.operateMeta.get("key");
        return (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"TrackNumberService", (String)"autoGenerateTrackNumber", (Object[])new Object[]{params});
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationResult op = this.getOperationResult();
        Object bills = null;
        if (this.params == null) {
            return;
        }
        if (this.delTrackNumbers != null && this.delTrackNumbers.size() > 0) {
            ArrayList<String> billEntrys = new ArrayList<String>(this.delTrackNumbers);
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"TrackNumberService", (String)"deleteTrackNumber", (Object[])new Object[]{billEntrys});
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        DynamicObject[] bills = e.getDataEntitys();
        if (this.params == null || bills == null || bills.length <= 0) {
            return;
        }
        this.params.put(BILLS, bills);
        String[] trackCols = this.params.get(COL_TRACKNUMBER).toString().split("\\.");
        ArrayList<String> EntryIds = new ArrayList<String>(16);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            if (bill == null) continue;
            if (trackCols.length == 1) {
                EntryIds.add(bill.getPkValue().toString());
                continue;
            }
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection(this.params.get(ENTRYNAME).toString());
            if (billEntrys == null || billEntrys.size() <= 0) continue;
            for (DynamicObject billEntry : billEntrys) {
                EntryIds.add(billEntry.getPkValue().toString());
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"TrackNumberService", (String)"deleteTrackNumber", (Object[])new Object[]{EntryIds});
            }
            catch (Exception exc) {
                txHandle.markRollback();
                throw exc;
            }
        }
    }

    private boolean isEntryField(Map<String, EntityType> propertyMap, String[] fields) {
        if (fields.length > 1) {
            EntityType property = propertyMap.get(fields[0]);
            return property instanceof EntryType;
        }
        return false;
    }

    private DynamicObject getRule() {
        QFilter qFilter3;
        DynamicObject rule = null;
        QFilter qFilter2 = new QFilter("useintracknumber", "=", (Object)Character.valueOf('1'));
        Map mapRule = BusinessDataServiceHelper.loadFromCache((String)"bd_lotcoderule", (QFilter[])new QFilter[]{qFilter2, qFilter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (mapRule == null || mapRule.size() < 1) {
            return null;
        }
        for (Object value : mapRule.values()) {
            rule = (DynamicObject)value;
        }
        return rule;
    }

    private DynamicObject getBillType(DynamicObject bill, String entityName) {
        DynamicObject billType = null;
        if (bill != null) {
            MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)entityName);
            DataEntityPropertyCollection entityPro = appBillMainType.getProperties();
            for (IDataEntityProperty en : entityPro) {
                if (!(en instanceof BasedataProp) || !"bos_billtype".equals(((BasedataProp)en).getBaseEntityId())) continue;
                billType = bill.get(en.getName()) == null ? null : (DynamicObject)bill.get(en.getName());
                break;
            }
        }
        if (billType == null) {
            billType = BillTypeQueryHelper.getBillTypesCache(entityName);
        }
        return billType;
    }
}

