/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.func;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class GetSSCVoucherHandler
implements BOSUDFunction {
    private static final Log log = LogFactory.getLog(GetSSCVoucherHandler.class);

    public GetSSCVoucherHandler() {
    }

    public GetSSCVoucherHandler(ExpressionContext expContext) {
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSSCVoucherHandler(expContext);
    }

    public String getName() {
        return "GetSSCVoucherHandler";
    }

    public Object call(Object ... params) {
        String entityName = params[0].toString();
        String billId = params[1].toString();
        String entityId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((String)entityId)) {
            log.error("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u4e0d\u5b58\u5728\u6807\u8bc6\u4e3a" + entityName + "\u7684\u5143\u6570\u636e");
            return null;
        }
        QFilter billFilter = new QFilter("bindbill", "=", (Object)entityId);
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"task_taskbill", (String)"id", (QFilter[])billFilter.toArray());
        if (billTypes.isEmpty()) {
            log.info("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u8868\u5355" + entityName + "\u672a\u521b\u5efa\u5171\u4eab\u4e1a\u52a1\u5355\u636e");
            return null;
        }
        List billTypeIds = billTypes.stream().map(item -> item.get("id")).collect(Collectors.toList());
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection inSSCProTasks = QueryServiceHelper.query((String)"task_task", (String)"id,state", (QFilter[])new QFilter[]{billIdFilter}, (String)"completetime desc");
        if (inSSCProTasks.size() > 0) {
            return null;
        }
        QFilter billTypeFilter = new QFilter("billtype", "in", billTypeIds);
        DynamicObjectCollection taskDyos = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,billid,tasktypeid,billtype,personid", (QFilter[])new QFilter[]{billIdFilter, billTypeFilter}, (String)"completetime desc");
        if (taskDyos.isEmpty()) {
            log.info("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u8868\u5355" + entityName + "\u7684\u5355\u636e" + billId + "\u4e0d\u5b58\u5728\u5df2\u5b8c\u6210\u7684\u5171\u4eab\u4efb\u52a1");
            return null;
        }
        Long billTypeId = ((DynamicObject)taskDyos.get(0)).getLong("billtype");
        QFilter billTypeIdFilter = new QFilter("id", "=", (Object)billTypeId);
        DynamicObjectCollection billTypeChilds = QueryServiceHelper.query((String)"task_taskbill", (String)"isneedvoucher,entryentity.childpkid", (QFilter[])new QFilter[]{billTypeIdFilter});
        if (billTypeChilds.size() <= 0) {
            return null;
        }
        boolean isNeedVoucher = ((DynamicObject)billTypeChilds.get(0)).getBoolean("isneedvoucher");
        if (!isNeedVoucher) {
            log.info("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u8868\u5355" + entityName + "\u7684\u5355\u636e" + billId + "\u7684\u6700\u65b0\u5171\u4eab\u4efb\u52a1\u6240\u5c5e\u4e1a\u52a1\u5355\u636e" + billTypeId + "\u4e0d\u5728\u5171\u4eab\u751f\u6210\u51ed\u8bc1");
            return null;
        }
        List childpkids = billTypeChilds.stream().map(item -> item.get("entryentity.childpkid")).collect(Collectors.toList());
        QFilter filter1 = new QFilter("id", "in", childpkids);
        QFilter filter2 = new QFilter("isvoucherhandler", "=", (Object)"1");
        DynamicObject voucherHandlerChild = QueryServiceHelper.queryOne((String)"task_taskbill_child", (String)"id,tasktype", (QFilter[])new QFilter[]{filter1, filter2});
        if (voucherHandlerChild == null) {
            log.info("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u8868\u5355" + entityName + "\u7684\u5355\u636e" + billId + "\u7684\u6700\u65b0\u5171\u4eab\u4efb\u52a1\u6240\u5c5e\u4e1a\u52a1\u5355\u636e" + billTypeId + "\u672a\u914d\u7f6e\u201d\u51ed\u8bc1\u5236\u5355\u4eba\u201c\u7684\u5355\u636e\u4efb\u52a1\u8282\u70b9");
            return null;
        }
        Long voucherHandlerTaskTypeId = voucherHandlerChild.getLong("tasktype");
        List re = taskDyos.stream().filter(item -> item.get("billtype").equals(billTypeId) && item.get("tasktypeid").equals(voucherHandlerTaskTypeId)).collect(Collectors.toList());
        if (re.size() == 0) {
            log.info("kd.bos.ext.ssc.func.GetSSCVoucherHandler.call:\u8868\u5355" + entityName + "\u7684\u5355\u636e" + billId + "\u7684\u6700\u65b0\u5171\u4eab\u4efb\u52a1\u6240\u5c5e\u4e1a\u52a1\u5355\u636e" + billTypeId + "\u7684\u201d\u51ed\u8bc1\u5236\u5355\u4eba\u201c\u5355\u636e\u4efb\u52a1\u8282\u70b9\u4e0d\u5b58\u5728\u5386\u53f2\u4efb\u52a1");
            return null;
        }
        return ((DynamicObject)re.get(0)).getLong("personid");
    }
}

