/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.ssc.enums.MsgTypeEnum;
import kd.bos.ext.ssc.enums.TaskPoolTypeEnum;
import kd.bos.ext.ssc.enums.TaskStateEnum;
import kd.bos.ext.ssc.helper.QualityApprovalPendingHelper;
import kd.bos.ext.ssc.helper.TaskApproveHelper;
import kd.bos.ext.ssc.helper.TaskApproveSuccessHelper;
import kd.bos.ext.ssc.pojo.TaskModifyPriority;
import kd.bos.ext.ssc.util.ArtiCheckPointUtil;
import kd.bos.ext.ssc.util.CirculateUtil;
import kd.bos.ext.ssc.util.LogBuildUtil;
import kd.bos.ext.ssc.util.QualityCheckSchemeUtil;
import kd.bos.ext.ssc.util.TaskApprevalPluginUtil;
import kd.bos.ext.ssc.util.TaskQueryServiceHelper;
import kd.bos.ext.ssc.util.ViewFlowchartUtil;
import kd.bos.ext.ssc.util.VoucherUtil;
import kd.bos.ext.ssc.util.WithdrawalSelectorUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;
import org.apache.commons.lang3.ArrayUtils;

public class TaskListButtonPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener {
    private static final Log log = LogFactory.getLog(TaskListButtonPlugin.class);
    private static final String FORM_APPROVALDECISIONITEMRELATION = "task_approvaldecisionitem";
    private static final String FORM_DHC_INQUIRYBILL = "dhc_inquirybill";
    private static final String OPERATIONKEY_PASS = "bar_pass";
    private static final String OPERATIONKEY_NOPASS = "bd_nopass";
    private static final String FORM_APPROVALWITHDRAWAL = "task_approvalwithdrawal";
    private static final int BATCHCOUNT = 20;
    private static final String FORM_APPROVALPENDING = "task_approvalpending";
    private static final int PARAM_PASS = 0;
    private static final int PARAM_NOT_PASS = 1;
    List<?> billTypeClass;
    Long billType;
    private static final String SELECTED_TASK_INFO = "selectedTaskInfo";
    private static final String[] itemClickName = new String[]{"tk_viewphoto", "tk_rescan", "", "tk_cancelrescan", "tk_mytask_pass", "tk_mytask_nopass", "tk_mytask_pause", "tk_cancelpause", "tk_mytask_modifypriority", "tk_mytask_viewflowchart", "tk_checkvoucherbtn", "tk_mytask_statetracker", "tk_btncirculation", "tk_circulatelog"};
    private static final String[] opperationName = new String[]{"refresh", "exportlistbyselectfields", "view", "close", "viewphoto", "rescan", "cancelrescan", "pass", "nopass", "repulse_both", "repulse", "pause", "cancelpause", "modifypriority", "ask", "viewflowchart", "checkvoucherbtn", "qingview", "statetracker", "donothingcir", "donothinglog"};
    private static final String OPKEY_PASS = "tk_mytask_pass";
    private static final String OPKEY_PAUSE = "tk_mytask_pause";
    private static final String OPKEY_CANCELPAUSE = "tk_cancelpause";
    private static final String OPKEY_MODIFYPRIORITY = "tk_mytask_modifypriority";
    private static final String OPKEY_ASK = "tk_mytask_ask";
    private static final String ACTION_BILLHANDLING1 = "action_billhandling1";
    private static final String ACTION_PASS = "action_pass";
    private static final String ACTION_NOPASS = "bd_nopass";
    private static final String ACTION_REPENDING = "action_repending";
    private static final String ACTION_QC_REPENDING = "action_qc_repending";
    private static final String ACTION_MODIFYPRIORITY = "action_modifypriority";
    private static final String ACTION_ASKTASK = "action_asktask";
    private static final String ACTION_DECISIONITEMDIALOG = "action_decisionitemdialog";
    private static final String ACTION_REWITHDRAWAL = "action_reWithdrawal";
    private static final String ACTION_BATCHAUDIT = "action_batchAudit";

    public void initialize() {
        String showpooltype;
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        this.billTypeClass = (List)customParams.get("showbillclassid");
        this.billType = (Long)customParams.get("showbilltype");
        Object sscIdObject = customParams.get("showsscid");
        if (sscIdObject != null) {
            this.getPageCache().put("sscid.id", sscIdObject.toString());
        }
        if ((showpooltype = (String)customParams.get("showpooltype")) != null) {
            if ("process".equals(showpooltype)) {
                this.getPageCache().put("pooltype", TaskPoolTypeEnum.PROCESSING.getValue());
            } else if ("completed".equals(showpooltype)) {
                this.getPageCache().put("pooltype", TaskPoolTypeEnum.COMPLETE.getValue());
            } else {
                log.error("\u5904\u7406\u73af\u8282\u5165\u53c2\u9519\u8bef\uff0cprocess\uff1a\u5904\u7406\u4e2d\uff1bcompleted\uff1a\u5df2\u5b8c\u6210");
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String state = this.getPageCache().get("state");
        String poolType = this.getPageCache().get("pooltype");
        if (!TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType) && !TaskStateEnum.AUDIT_PASSED.getValue().equals(state) && !TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state) && ArrayUtils.contains((Object[])itemClickName, (Object)itemKey)) {
            ListSelectedRowCollection selected = ((BillList)this.getControl("billlistap")).getSelectedRows();
            for (int i = 0; i < selected.size(); ++i) {
                Long id = Long.valueOf(selected.get(i).getPrimaryKeyValue() + "");
                if (!TaskQueryServiceHelper.isTaskforcurrentperson(id)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u7ecf\u91cd\u5206\u914d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"MytaskListPlugin_0", (String)"bos-ext-ssc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        if ("tk_close".equals(itemKey)) {
            evt.setCancel(true);
            this.invokeParentOperation("close", null);
        }
    }

    private void noPass(String operationKey) {
        this.getPageCache().put("action", operationKey);
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (this.checkTaskState(selectedRows, operationKey)) {
            List<Long> relationList;
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u5904\u7406\u3002", (String)"MytaskListPlugin_6", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            String itemKey = "bd_nopass";
            Long id = Long.valueOf(selectedRows.get(0).getPrimaryKeyValue().toString());
            List<Long> idList = Collections.singletonList(id);
            DynamicObjectCollection taskObjs = VoucherUtil.getTaskVoucherInfos(idList, "task_task");
            if (!CollectionUtils.isEmpty((Collection)taskObjs)) {
                for (DynamicObject task : taskObjs) {
                    String billnumber = task.getString("billnumber");
                    if (!FORM_DHC_INQUIRYBILL.equals(billnumber)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u62ec\u5171\u4eab\u95ee\u8be2\u5de5\u5355\u4efb\u52a1\uff0c\u8bf7\u9009\u62e9\u975e\u5171\u4eab\u95ee\u8be2\u5de5\u5355\u4efb\u52a1\u8fdb\u884c\u5904\u7406\u3002", (String)"MytaskListPlugin_63", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return;
                }
            }
            if ((relationList = TaskApprevalPluginUtil.getDecisionItemId(itemKey, idList)) == null || relationList.size() == 0) {
                this.openWithDrawalDialog(this.getView(), itemKey, idList, null, null, null, null, null);
            } else {
                this.openDecisionItemDialog(this.getView(), itemKey, idList, null, null, null, null);
            }
        }
    }

    protected void noPassAction(Map<String, Object> params) {
        String opinion = params.get("opinion") == null ? null : params.get("opinion").toString();
        String innermsg = params.get("innermsg") == null ? null : params.get("innermsg").toString();
        String btnKey = params.get("btnkey") == null ? null : params.get("btnkey").toString();
        List taskids = (List)params.get("taskids");
        List decisionitemids = (List)params.get("decisionitemids");
        String nodeItemId = (String)params.get("nodeItemId");
        this.getView().getPageCache().put("nodeItemId", nodeItemId);
        List withDrawalIds = (List)params.get("withdrawalids");
        List<Long> pkIds = this.getSelectedRowIds();
        if (opinion == null || innermsg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5ba1\u6279\u610f\u89c1", (String)"MytaskListPlugin_51", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        List<String> notExistList = this.getNotExistsTaskData(pkIds);
        if (!CollectionUtils.isEmpty(notExistList)) {
            String join = StringUtils.join((Object[])notExistList.toArray(), (String)",");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u5355\u636e\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u548c\u63d0\u5355\u4eba\u5904\u7406\u3002", (String)"MytaskListPlugin_59", (String)"bos-ext-ssc", (Object[])new Object[]{join}));
            return;
        }
        if ("btnup".equalsIgnoreCase(btnKey)) {
            this.openWithDrawalDialog(this.getView(), "bd_nopass", taskids, decisionitemids, withDrawalIds, opinion, innermsg, nodeItemId);
            return;
        }
        if (taskids == null || taskids.size() == 0) {
            return;
        }
        String withdrawal = "";
        JSONArray jsonArray = (JSONArray)params.get("withdrawalids");
        List rejectIds = jsonArray.toJavaList(Long.class);
        DynamicObjectCollection rejectInfos = QueryServiceHelper.query((String)"task_withdrawal", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rejectIds)});
        if (rejectIds != null && rejectInfos.size() > 0) {
            withdrawal = String.join((CharSequence)";", rejectInfos.stream().map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList()));
        }
        int totalSuccessCount = this.getTaskAndApprevalNew("bd_nopass", pkIds, opinion, innermsg, decisionitemids, withdrawal, withDrawalIds, this.getView());
        if (!CollectionUtils.isEmpty(pkIds) && totalSuccessCount == pkIds.size()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskApproveHelper_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
        this.refreshBillListAp(true);
    }

    protected void pass() {
        String billnumber = "";
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        this.getPageCache().put("action", null);
        if (this.checkTaskState(selectedRows, "pass")) {
            Object[] ids;
            ArrayList<Long> taskIdList = new ArrayList<Long>(10);
            for (Object item : ids = selectedRows.getPrimaryKeyValues()) {
                taskIdList.add((Long)item);
            }
            if (!TaskApprevalPluginUtil.beforeApprovalValidateBillType(taskIdList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e0d\u540c\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\u636e,\u8bf7\u9009\u62e9\u540c\u4e00\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\u636e\u6570\u636e\u3002", (String)"MytaskListPlugin_7", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            if (!TaskApprevalPluginUtil.beforeApprovalValidateTaskType(taskIdList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e0d\u540c\u79cd\u7c7b\u7684\u4efb\u52a1\u7c7b\u578b,\u8bf7\u9009\u62e9\u540c\u4e00\u79cd\u7c7b\u7684\u4efb\u52a1\u7c7b\u578b\u6570\u636e\u3002", (String)"MytaskListPlugin_8", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection taskObjs = VoucherUtil.getTaskVoucherInfos(taskIdList, "task_task");
            if (taskObjs != null && taskObjs.size() > 0) {
                for (DynamicObject task : taskObjs) {
                    billnumber = task.getString("billnumber");
                    if (!FORM_DHC_INQUIRYBILL.equals(billnumber)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u62ec\u5171\u4eab\u95ee\u8be2\u5de5\u5355\u4efb\u52a1\uff0c\u8bf7\u9009\u62e9\u975e\u5171\u4eab\u95ee\u8be2\u5de5\u5355\u4efb\u52a1\u8fdb\u884c\u5904\u7406\u3002", (String)"MytaskListPlugin_63", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return;
                }
            }
            if (!ArtiCheckPointUtil.isArtiCheckPointSelectedOfList(this.getView(), taskIdList)) {
                return;
            }
            this.openOpinionsAndInnerMsg4Pass();
        }
    }

    private void passAction(Map<String, Object> params) {
        String opinion = params.get("opinion") == null ? null : params.get("opinion").toString();
        String innermsg = params.get("innermsg") == null ? null : params.get("innermsg").toString();
        List taskids = (List)params.get("taskids");
        List<Long> pkIds = this.getSelectedRowIds();
        if (opinion == null || innermsg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5ba1\u6279\u610f\u89c1", (String)"MytaskListPlugin_51", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        List<String> notExistList = this.getNotExistsTaskData(pkIds);
        if (!CollectionUtils.isEmpty(notExistList)) {
            String join = StringUtils.join((Object[])notExistList.toArray(), (String)",");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u53f7 %s \u7684\u5355\u636e\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6838\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u548c\u63d0\u5355\u4eba\u5904\u7406\u3002", (String)"MytaskListPlugin_59", (String)"bos-ext-ssc", (Object[])new Object[]{join}));
            return;
        }
        if (pkIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (this.isBatchProcessing(pkIds, taskids)) {
            this.batchProcessing(OPERATIONKEY_PASS, opinion, innermsg, pkIds, taskids, null, null);
            return;
        }
        int totalSuccessCount = this.getTaskAndApprevalNew(OPERATIONKEY_PASS, pkIds, opinion, innermsg, null, null, null, this.getView());
        if (!CollectionUtils.isEmpty(pkIds) && totalSuccessCount == pkIds.size()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskApproveHelper_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
        this.refreshBillListAp(true);
    }

    private List<String> getNotExistsTaskData(List<Long> taskIds) {
        QFilter filter = new QFilter("id", "in", taskIds);
        String selector = "id,billtype,billid,pooltype,billnumber";
        DynamicObject[] taskList = BusinessDataServiceHelper.load((String)"task_task", (String)selector, (QFilter[])filter.toArray());
        Map<Long, String> billTypeMap = this.buildTypeMap();
        ArrayList<String> notExistList = new ArrayList<String>(20);
        for (DynamicObject dyo : taskList) {
            Object billId;
            QFilter idFilters;
            String metaNum = billTypeMap.get(dyo.getLong("billtype.id"));
            boolean exists = QueryServiceHelper.exists((String)metaNum, (QFilter[])new QFilter[]{idFilters = new QFilter("id", "=", billId = kd.bos.util.StringUtils.isNumeric((String)dyo.getString("billid")) ? Long.valueOf(dyo.getLong("billid")) : dyo.getString("billid"))});
            if (exists) continue;
            notExistList.add(dyo.getString("billnumber"));
        }
        return notExistList;
    }

    private boolean checkTaskState(ListSelectedRowCollection selectedRows, String operationKey) {
        String state = this.getPageCache().get("state");
        String entityName = this.getTaskEntityFromCache();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return false;
        }
        if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state) || TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u4e0d\u5728\u8fdb\u884c\u5ba1\u6279", (String)"MytaskListPlugin_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return false;
        }
        for (int m = 0; m < selectedRows.size(); ++m) {
            Long id = Long.valueOf(selectedRows.get(m).getPrimaryKeyValue() + "");
            DynamicObjectCollection col = TaskQueryServiceHelper.getDataMyTasklist(id, false);
            for (int i = 0; i < col.size(); ++i) {
                String taskProperty = ((DynamicObject)col.get(i)).getString("tasktypeid.qualityjudge");
                if ("1".equals(taskProperty)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u542b\u201c\u8d28\u68c0\u4efb\u52a1\u201d\uff0c\u8bf7\u9009\u62e9\u975e\u201c\u8d28\u68c0\u4efb\u52a1\u201d\u8fdb\u884c\u5904\u7406\u3002", (String)"MytaskListPlugin_3", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return false;
                }
                if ("4".equals(taskProperty)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u542b\u201c\u529e\u7406\u4efb\u52a1\u201d\uff0c\u8bf7\u9009\u62e9\u975e\u201c\u529e\u7406\u4efb\u52a1\u201d\u8fdb\u884c\u5904\u7406\u3002", (String)"TaskListButtonPlugin_5", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return false;
                }
                String tempState = ((DynamicObject)col.get(i)).getString("state");
                boolean displayImage = ((DynamicObject)col.get(i)).getBoolean("billtype.isuseimage");
                if ("repulse".equals(operationKey) || "repulse_both".equals(operationKey)) {
                    if (!(TaskStateEnum.TO_BE_AUDIT.getValue().equals(tempState) || TaskStateEnum.RESCAN.getValue().equals(tempState) || TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(tempState))) {
                        if (displayImage) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u3001\u201c\u9000\u56de\u91cd\u626b\u201d\u3001\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u8fdb\u884c\u201c\u4e0d\u901a\u8fc7\u201d\u64cd\u4f5c\u3002", (String)"TaskListButtonPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u8fdb\u884c\u201c\u4e0d\u901a\u8fc7\u201d\u64cd\u4f5c\u3002", (String)"TaskListButtonPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        }
                        return false;
                    }
                } else if ("pass".equals(operationKey) && !TaskStateEnum.TO_BE_AUDIT.getValue().equals(tempState) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(tempState)) {
                    if (displayImage) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u548c\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u8fdb\u884c\u201c\u901a\u8fc7\u201d\u64cd\u4f5c\u3002", (String)"TaskListButtonPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u80fd\u8fdb\u884c\u201c\u901a\u8fc7\u201d\u64cd\u4f5c\u3002", (String)"TaskListButtonPlugin_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    }
                    return false;
                }
                if (((DynamicObject)col.get(i)).get("billid") != null && ((DynamicObject)col.get(i)).get("billtype") != null && ((DynamicObject)col.get(i)).get("tasktypeid") != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u6570\u636e\u6709\u8bef\u3002", (String)"MytaskListPlugin_5", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void openOpinionsAndInnerMsg4Pass() {
        ListSelectedRow selectedRowInfo = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
        long taskId = Long.parseLong(String.valueOf(selectedRowInfo.getPrimaryKeyValue()));
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId("task_taskapprevalmessage");
        parameEdit.setCustomParam("taskids", Collections.singletonList(taskId));
        parameEdit.setCustomParam("ispass", (Object)0);
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_PASS);
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private void openOpinionsAndInnerMsg4Repulse(String key, List<Object> decisionItemIds, List<Long> taskids, List<Object> withDrawalIds, String opinion, String innermsg, String nodeItemId) {
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId("task_taskapprevalmessage");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        parameEdit.setCloseCallBack(closeCallBack);
        if (decisionItemIds == null) {
            decisionItemIds = new ArrayList<Object>();
        }
        if (taskids == null) {
            taskids = new ArrayList<Long>();
        }
        if (withDrawalIds == null) {
            withDrawalIds = new ArrayList<Object>();
        }
        parameEdit.setCustomParam("decisionitemids", decisionItemIds);
        parameEdit.setCustomParam("nodeItemId", (Object)nodeItemId);
        parameEdit.setCustomParam("taskids", taskids);
        parameEdit.setCustomParam("withdrawalids", withDrawalIds);
        parameEdit.setCustomParam("opinion", (Object)opinion);
        parameEdit.setCustomParam("innermsg", (Object)innermsg);
        parameEdit.setCustomParam("key", (Object)key);
        parameEdit.setCustomParam("ispass", (Object)1);
        this.getView().showForm(parameEdit);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String sscId = this.getPageCache().get("sscid.id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscId)) {
            String key;
            switch (key = afterDoOperationEventArgs.getOperateKey()) {
                case "viewflowchart": {
                    this.viewFlowchart();
                    break;
                }
                case "qingview": {
                    this.qingView();
                    break;
                }
                case "statetracker": {
                    this.stateTracker();
                    break;
                }
                case "refresh": {
                    this.refreshBillListAp(true);
                    break;
                }
                case "donothingcir": {
                    this.circulate();
                    break;
                }
                case "donothinglog": {
                    this.circulatelog();
                    break;
                }
                case "pass": {
                    this.pass();
                    break;
                }
                case "repulse": 
                case "nopass": {
                    this.noPass("repulse");
                    break;
                }
                case "repulse_both": {
                    this.noPass("repulse_both");
                    break;
                }
                case "pause": {
                    this.pauseOp();
                    break;
                }
                case "cancelpause": {
                    this.cancelPauseOp();
                    this.refreshBillListAp(true);
                    break;
                }
                case "modifypriority": {
                    this.modifyTaskPriorityOp();
                    break;
                }
                case "ask": {
                    this.askTaskOp();
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (kd.bos.util.StringUtils.isNotEmpty((String)operationKey) && ArrayUtils.contains((Object[])opperationName, (Object)operationKey)) {
            return;
        }
        String sscId = this.getPageCache().get("sscid.id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscId)) {
            String key;
            switch (key = evt.getItemKey()) {
                case "tk_mytask_viewflowchart": {
                    this.viewFlowchart();
                    break;
                }
                case "tk_qingviewlist": {
                    this.qingView();
                    break;
                }
                case "tk_mytask_statetracker": {
                    this.stateTracker();
                    break;
                }
                case "tk_mytask_exportexcel": {
                    this.getView().invokeOperation("exportlistbyselectfields");
                    break;
                }
                case "tk_refresh": {
                    this.refreshBillListAp(true);
                    break;
                }
                case "tk_btncirculation": {
                    this.circulate();
                    break;
                }
                case "tk_circulatelog": {
                    this.circulatelog();
                    break;
                }
                case "tk_mytask_pass": {
                    this.pass();
                    break;
                }
                case "tk_mytask_nopass": {
                    this.noPass("repulse");
                    break;
                }
                case "tk_mytask_pause": {
                    this.pauseOp();
                    break;
                }
                case "tk_cancelpause": {
                    this.cancelPauseOp();
                    this.refreshBillListAp(true);
                    break;
                }
                case "tk_mytask_modifypriority": {
                    this.modifyTaskPriorityOp();
                    break;
                }
                case "tk_mytask_ask": {
                    this.askTaskOp();
                    break;
                }
            }
        }
    }

    private void circulate() {
        String entityName = this.getTaskEntityFromCache();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (ListSelectedRow selectedRow : selectedRows) {
            taskIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        if (taskIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SlaInitListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> result = CirculateUtil.checkTaskAndCirculateParam((Long)taskIds.get(0), entityName);
        if (!((Boolean)result.get("canCirculate")).booleanValue()) {
            this.getView().showTipNotification((String)result.get("msg"));
            return;
        }
        Long wfTaskId = (Long)result.get("wfTaskId");
        this.showCirculationPage(wfTaskId);
    }

    private boolean getCirculateParam(DynamicObject taskDyn, String entityName) {
        Long sscId = taskDyn.getLong("sscid");
        QFilter idFilter = new QFilter("sscorg", "=", (Object)sscId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"ssc_dutymanage", (String)"sscbusinesstype", (QFilter[])idFilter.toArray());
        String sscType = dyn == null ? "1" : dyn.getString("sscbusinesstype");
        String wfTaskId = taskDyn.getString("assignid");
        log.info("sscId = {}\u7684\u5171\u4eab\u4e2d\u5fc3\u7c7b\u578b\u4e3a\uff1a{}", (Object)sscId, (Object)sscType);
        if ("1".equals(sscType) || "2".equals(sscType)) {
            return this.getWfSscTaskNodeCirculate(Long.valueOf(wfTaskId), "task_taskhistory".equals(entityName));
        }
        QFilter filter1 = new QFilter("bizextcase.number", "=", (Object)"004");
        QFilter filter2 = new QFilter("sscbusinesstype", "=", (Object)sscType);
        QFilter filter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject bizExtServiceDo = QueryServiceHelper.queryOne((String)"ssc_bizextservice", (String)"id,servicename,methodname,cloudid.number,appid.number", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        if (bizExtServiceDo == null) {
            log.info("MyTaskListPlugin.getCirculateParam()\u672a\u627e\u5230\u76f8\u5173\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\uff0c\u53c2\u6570\u503c\u9ed8\u8ba4\u4e3afalse\u3002 sscType = {}\uff0ccaseNumber = 004", (Object)sscType);
            return false;
        }
        String serviceName = bizExtServiceDo.getString("servicename");
        String methodName = bizExtServiceDo.getString("methodname");
        String cloudId = bizExtServiceDo.getString("cloudid.number");
        String appId = bizExtServiceDo.getString("appid.number");
        log.info("\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u6570\u636e\uff1aserviceName = {}, methodName = {}, cloudId = {}, appId = {}", new Object[]{serviceName, methodName, cloudId, appId});
        if (kd.bos.util.StringUtils.isEmpty((String)serviceName) || kd.bos.util.StringUtils.isEmpty((String)methodName) || kd.bos.util.StringUtils.isEmpty((String)cloudId) || kd.bos.util.StringUtils.isEmpty((String)appId)) {
            return false;
        }
        cloudId = cloudId.toLowerCase();
        boolean canCirculate = false;
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{String.valueOf(wfTaskId)});
            log.info("\u5fae\u670d\u52a1\u8c03\u7528\u7ed3\u679c\uff1a" + result);
            if (result != null) {
                canCirculate = (Boolean)result;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return canCirculate;
    }

    private boolean getWfSscTaskNodeCirculate(Long wfTaskId, boolean isHistoryTask) {
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
        if (taskInfo != null && StringUtils.isNotBlank((CharSequence)taskInfo.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)taskInfo.getControl(), Map.class);
            String circulate = (String)map.get("circulate");
            return Boolean.parseBoolean(circulate);
        }
        if (taskInfo == null && isHistoryTask) {
            DynamicObject[] control = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"control", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wfTaskId)});
            String circulate = null;
            for (DynamicObject controlValue : control) {
                circulate = (String)controlValue.get("control");
            }
            if (!kd.bos.util.StringUtils.isEmpty(circulate)) {
                String circulateResult = "false";
                String regex = "\"circulate\":\"(.*?)\"";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(circulate);
                if (matcher.find()) {
                    circulateResult = matcher.group(1);
                }
                return !"false".equals(circulateResult);
            }
        }
        return false;
    }

    private void showCirculationPage(Long assignId) {
        HashMap<String, Long> customParams = new HashMap<String, Long>();
        customParams.put("taskid", assignId);
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("task_taskcirculation");
        para.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u4f20\u9605", (String)"TaskCirculationPlugin_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
        para.setCustomParams(customParams);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showCirculationPage"));
        this.getView().showForm(para);
    }

    private void circulatelog() {
        String entityName = this.getTaskEntityFromCache();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> taskIds = new ArrayList<Long>(8);
        for (ListSelectedRow selectedRow : selectedRows) {
            taskIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        if (taskIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SlaInitListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (QualityCheckSchemeUtil.isQualityCheckTask(ids, entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u5355\u4efb\u52a1\u67e5\u8be2\u4f20\u9605\u8bb0\u5f55\u3002", (String)"TaskCirculationPlugin_8", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (!taskIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "=", taskIds.get(0));
            DynamicObject dynamicObject = entityName.equals("task_task") ? QueryServiceHelper.queryOne((String)"task_task", (String)"assignid", (QFilter[])new QFilter[]{qFilter}) : QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"assignid", (QFilter[])new QFilter[]{qFilter});
            Long assignId = 0L;
            String assignIdStr = dynamicObject.getString("assignid");
            try {
                assignId = Long.valueOf(assignIdStr);
            }
            catch (Exception e) {
                log.warn("\u9519\u8bef\u7684assignId\uff1a" + assignId);
            }
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setFormId("task_taskcirculationlog");
            if (assignId != 0L) {
                para.setCustomParam("taskid", (Object)assignId);
            }
            para.setCaption(ResManager.loadKDString((String)"\u4f20\u9605\u8bb0\u5f55", (String)"MytaskListPlugin_77", (String)"bos-ext-ssc", (Object[])new Object[0]));
            this.getView().showForm(para);
        }
    }

    private void viewFlowchart() {
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MytaskListPlugin_12", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DynamicObjectCollection col = null;
        boolean isHistory = TaskPoolTypeEnum.COMPLETE.getValue().equals(this.getPageCache().get("pooltype"));
        col = TaskQueryServiceHelper.getDataMyTasklist(id, isHistory);
        DynamicObject dynamicObject = (DynamicObject)col.get(0);
        String billid = (String)dynamicObject.get("billid");
        long billtypeid = (Long)dynamicObject.get("billtype");
        String qualityjudge = dynamicObject.getString("tasktypeid.qualityjudge");
        if ("4".equals(qualityjudge)) {
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)TaskQueryServiceHelper.findParentBillId(id, !isHistory));
        } else if ("EAS".equalsIgnoreCase(TaskQueryServiceHelper.getErpNumber(billtypeid))) {
            ViewFlowchartUtil.viewFlowchart(log, this.getView(), billid);
        } else {
            WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)billid);
        }
    }

    private void doQuaTaskMsgAction(String msg) {
        if ("submit".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"MytaskListPlugin_30", (String)"bos-ext-ssc", (Object[])new Object[0]), Integer.valueOf(5000));
        } else if ("haschecked".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u53d1\u9001\u7ed9\u6574\u6539\u4eba\u8fdb\u884c\u6574\u6539\u3002", (String)"MytaskListPlugin_31", (String)"bos-ext-ssc", (Object[])new Object[0]), Integer.valueOf(5000));
        } else if ("hasreturnorignalperson".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u53d1\u9001\u7ed9\u8d28\u68c0\u5458\u8fdb\u884c\u590d\u6838\u3002", (String)"MytaskListPlugin_32", (String)"bos-ext-ssc", (Object[])new Object[0]), Integer.valueOf(5000));
        } else if ("returncheck".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u9000\u56de\u7ed9\u6574\u6539\u4eba\u8fdb\u884c\u518d\u6b21\u6574\u6539\u3002", (String)"MytaskListPlugin_33", (String)"bos-ext-ssc", (Object[])new Object[0]), Integer.valueOf(5000));
        } else if ("hasreviewd".equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u8d28\u68c0\u5b8c\u6210\u3002", (String)"MytaskListPlugin_34", (String)"bos-ext-ssc", (Object[])new Object[0]), Integer.valueOf(5000));
        }
        this.refreshBillListAp(true);
    }

    private void askTaskOp() {
        FormShowParameter parameEdit = new FormShowParameter();
        String sscIDStr = this.getPageCache().get("sscid.id");
        if (sscIDStr == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u5171\u4eab\u4e2d\u5fc3\u4e0d\u80fd\u83b7\u53d6\u4efb\u52a1", (String)"MytaskListPlugin_13", (String)"bos-ext-ssc", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        parameEdit.setFormId("task_taskask");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        parameEdit.setCustomParam("sscid.id", (Object)sscIDStr);
        parameEdit.setCustomParam("taskbillType", this.billTypeClass);
        parameEdit.setCustomParam("taskbill", (Object)this.billType);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_ASKTASK);
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private void askTaskAction(Map<String, StringBuffer> dataMap) {
        if (dataMap != null) {
            if (dataMap.containsKey("success")) {
                StringBuffer successRsMap = dataMap.get("success");
                this.getView().showSuccessNotification(successRsMap.toString(), Integer.valueOf(3000));
            } else if (dataMap.containsKey("parent")) {
                StringBuffer sucessMsg = dataMap.get("parent");
                this.getView().showTipNotification(sucessMsg.toString(), Integer.valueOf(3000));
            } else if (dataMap.containsKey("local")) {
                StringBuffer local = dataMap.get("local");
                this.getView().showTipNotification(local.toString(), Integer.valueOf(3000));
            }
            AppLogInfo logInfo = LogBuildUtil.buildLogInfo(this.getView(), ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u64cd\u4f5c\u3002", (String)"MytaskListPlugin_70", (String)"bos-ext-ssc", (Object[])new Object[0]), null, "task_task", ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1", (String)"MytaskListPlugin_71", (String)"bos-ext-ssc", (Object[])new Object[0]));
            LogServiceHelper.addLog((AppLogInfo)logInfo);
        }
        this.refreshBillListAp(true);
    }

    private void stateTracker() {
        String entityName = this.getTaskEntityFromCache();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> taskIds = new HashSet<Long>(8);
        for (ListSelectedRow selectedRow : selectedRows) {
            taskIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        if (taskIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MytaskListPlugin_12", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (QualityCheckSchemeUtil.isQualityCheckTask(taskIds.toArray(), entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u542b\u201c\u8d28\u68c0\u4efb\u52a1\u201d\uff0c\u8bf7\u9009\u62e9\u975e\u201c\u8d28\u68c0\u4efb\u52a1\u201d\u8fdb\u884c\u5904\u7406\u3002", (String)"MytaskListPlugin_3", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        ArrayList taskidList = new ArrayList(taskIds);
        FormShowParameter parameterEdit = new FormShowParameter();
        parameterEdit.setFormId("task_statechangeshow");
        parameterEdit.setCustomParam("taskdis", taskidList);
        parameterEdit.setCustomParam("state_trace_pooltype", (Object)this.getPageCache().get("pooltype"));
        parameterEdit.setCustomParam("state_trace_invoke_from", (Object)"state_trace_from_mytask");
        parameterEdit.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameterEdit);
    }

    private void openPendingDialog(List<Long> taskIds) {
        IFormView view = this.getView();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("task_pendingreasonsel");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.getOpenStyle().setTargetKey("tabap");
        para.setHasRight(true);
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        Long sscid = billInfo.get("sscid").get(0);
        para.setCustomParam("sscid", (Object)String.valueOf(sscid));
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_REPENDING));
        view.showForm(para);
    }

    private void qingView() {
        FormShowParameter showParameter = new FormShowParameter();
        String pageId = this.getView().getPageId();
        BillList list = (BillList)this.getControl("billlistap");
        String poolType = this.getPageCache().get("pooltype");
        String entityName = this.getTaskEntityFromCache(poolType);
        showParameter.setCustomParam("billFormId", (Object)entityName);
        String qFilter = TaskQueryServiceHelper.getGeneralFiler(list.getFilterParameter().getQFilters(), false);
        IFormView view = this.getView();
        showParameter.setFormId("task_administrateqing");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParam("qFilter", (Object)qFilter);
        showParameter.setCustomParam("pageId", (Object)pageId);
        showParameter.setCustomParam("personid", (Object)RequestContext.get().getUserId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1\u8f7b\u5206\u6790", (String)"MytaskListPlugin_20", (String)"bos-ext-ssc", (Object[])new Object[0]));
        FormShowParameter parent = this.getView().getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm(showParameter);
    }

    private void pauseOp() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        boolean hasQualityTask = false;
        int abnormalQualityTask = 0;
        boolean hasAuditTask = false;
        int abnormalAuditTask = 0;
        HashSet<Long> taskList = new HashSet<Long>(8);
        boolean isuseimage = false;
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long selectedRowId = (Long)listSelectedRow.getPrimaryKeyValue();
            taskList.add(selectedRowId);
            DynamicObjectCollection selectedRowData = TaskQueryServiceHelper.getDataMyTasklist(selectedRowId, false);
            DynamicObject taskDo = (DynamicObject)selectedRowData.get(0);
            boolean isQualityTask = taskDo.getLong("qualitysamplelibrary") > 0L;
            String state = taskDo.getString("state");
            boolean bl = isuseimage = isuseimage || taskDo.getBoolean("billtype.isuseimage");
            if (isQualityTask) {
                hasQualityTask = true;
                if (QualityApprovalPendingHelper.isPause(state)) continue;
                ++abnormalQualityTask;
                continue;
            }
            hasAuditTask = true;
            if (TaskStateEnum.TO_BE_AUDIT.getValue().equals(state) || TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(state)) continue;
            ++abnormalAuditTask;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(taskList);
        if (hasQualityTask && hasAuditTask) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u540c\u65f6\u9009\u62e9\u5ba1\u6838\u4efb\u52a1\u53ca\u8d28\u68c0\u4efb\u52a1\u3002", (String)"MytaskListPlugin_67", (String)"bos-ext-ssc", (Object[])new Object[0]));
        } else if (hasQualityTask) {
            if (taskIds.size() == abnormalQualityTask) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u8d28\u68c0\u3001\u5f85\u6574\u6539\u3001\u5f85\u590d\u6838\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"MytaskListPlugin_66", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            this.openQualityPendingDialog(taskIds);
        } else if (hasAuditTask) {
            if (abnormalAuditTask > 0) {
                if (isuseimage) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u6682\u6302\u3002", (String)"MytaskListPlugin_25", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u6682\u6302\u3002", (String)"MytaskListPlugin_79", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            this.openPendingDialog(taskIds);
        }
    }

    private void openQualityPendingDialog(List<Long> taskIds) {
        if (!CollectionUtils.isEmpty(taskIds)) {
            IFormView view = this.getView();
            FormShowParameter para = new FormShowParameter();
            para.setFormId("task_qcpendingreasonsel");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.getOpenStyle().setTargetKey("tabap");
            para.setHasRight(true);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_QC_REPENDING));
            para.setCustomParam("taskIds", taskIds);
            view.showForm(para);
        }
    }

    private void pauseActionNew(Map<String, Object> dataMap) {
        List<Long> selectedRowIds = this.getSelectedRowIds();
        List pendingids = (List)dataMap.get("pendingids");
        String pending = (String)dataMap.get("reason");
        if (!CollectionUtils.isEmpty(selectedRowIds)) {
            for (Long taskId : selectedRowIds) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("taskId", taskId);
                long currUserId = RequestContext.get().getCurrUserId();
                paramMap.put("pendingOpinionList", pendingids);
                paramMap.put("currentPersonId", currUserId);
                paramMap.put("reason", pending);
                paramMap.put("origin", "2");
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveByPend", (Object[])new Object[]{paramMap});
                String success = (String)resultMap.get("success");
                if (!"false".equals(success)) continue;
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (kd.bos.util.StringUtils.isEmpty((String)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.refreshBillListAp(true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"MytaskListPlugin_49", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
    }

    private void cancelPauseOp() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        boolean hasQualityTask = false;
        int abnormalQualityTask = 0;
        boolean hasAuditTask = false;
        int abnormalAuditTask = 0;
        HashSet<Long> taskIdSet = new HashSet<Long>(8);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long selectedRowId = (Long)listSelectedRow.getPrimaryKeyValue();
            taskIdSet.add(selectedRowId);
            DynamicObjectCollection selectedRowData = TaskQueryServiceHelper.getDataMyTasklist(selectedRowId, false);
            DynamicObject taskDo = (DynamicObject)selectedRowData.get(0);
            boolean isQualityTask = taskDo.getLong("qualitysamplelibrary") > 0L;
            String state = taskDo.getString("state");
            if (isQualityTask) {
                hasQualityTask = true;
                if (QualityApprovalPendingHelper.isCancelPause(state)) continue;
                ++abnormalQualityTask;
                continue;
            }
            hasAuditTask = true;
            if (state.equals(TaskStateEnum.PAUSE.getValue())) continue;
            ++abnormalAuditTask;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(taskIdSet);
        if (hasQualityTask && hasAuditTask) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u540c\u65f6\u9009\u62e9\u5ba1\u6838\u4efb\u52a1\u53ca\u8d28\u68c0\u4efb\u52a1\u3002", (String)"MytaskListPlugin_67", (String)"bos-ext-ssc", (Object[])new Object[0]));
        } else if (hasQualityTask) {
            if (taskIds.size() == abnormalQualityTask) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u6682\u6302\u3001\u6574\u6539\u6682\u6302\u3001\u590d\u6838\u6682\u6302\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"MytaskListPlugin_68", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> returnData = QualityApprovalPendingHelper.qualityCancelPending(taskIds);
            QualityApprovalPendingHelper.qualityCancelPauseAction(this.getView(), returnData);
        } else if (hasAuditTask) {
            if (abnormalAuditTask > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u6302\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u53d6\u6d88\u6682\u6302", (String)"MytaskListPlugin_27", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            for (Long taskId : taskIds) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("taskId", taskId);
                long currUserId = RequestContext.get().getCurrUserId();
                paramMap.put("currentPersonId", currUserId);
                paramMap.put("origin", "2");
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveByCancelPend", (Object[])new Object[]{paramMap});
                String success = (String)resultMap.get("success");
                if (!"false".equals(success)) continue;
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (kd.bos.util.StringUtils.isEmpty((String)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"MytaskListPlugin_48", (String)"bos-ext-ssc", (Object[])new Object[0]));
        }
    }

    private void modifyTaskPriorityOp() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String form = (String)parameter.getCustomParam("formId");
        if ("task_administrate".equals(form)) {
            return;
        }
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        String entityName = this.getTaskEntityFromCache();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        if (QualityCheckSchemeUtil.isQualityCheckTask(ids, entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u4e2d\u5305\u542b\u201c\u8d28\u68c0\u4efb\u52a1\u201d\uff0c\u8bf7\u9009\u62e9\u975e\u201c\u8d28\u68c0\u4efb\u52a1\u201d\u8fdb\u884c\u5904\u7406\u3002", (String)"MytaskListPlugin_3", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        Set<Long> selectedRowIds = selectedRows.stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue() + "")).collect(Collectors.toSet());
        HashMap<Long, Boolean> isuseimageMap = new HashMap<Long, Boolean>(selectedRowIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TaskListButtonPlugin#modifyTaskPriorityOp", (String)"task_task", (String)"id,billtype.isuseimage", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedRowIds)}, null);){
            for (Row row : dataSet) {
                isuseimageMap.put(row.getLong("id"), row.getBoolean("billtype.isuseimage"));
            }
        }
        List<Map<String, Object>> myTaskListInfo = TaskQueryServiceHelper.getMyTaskListInfoByPkIds(selectedRowIds);
        HashSet<Long> priorityIdSet = new HashSet<Long>(myTaskListInfo.size());
        for (Map<String, Object> map : myTaskListInfo) {
            String state = (String)map.get("state");
            Long id = (Long)map.get("id");
            if (!state.equals(TaskStateEnum.TO_BE_AUDIT.getValue()) && !state.equals(TaskStateEnum.REUPLOAD_IMAGE.getValue())) {
                if (((Boolean)isuseimageMap.get(id)).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u5f71\u50cf\u91cd\u4f20\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u4fee\u6539\u4f18\u5148\u7ea7\u3002", (String)"MytaskListPlugin_28", (String)"bos-ext-ssc", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u4fee\u6539\u4f18\u5148\u7ea7\u3002", (String)"MytaskListPlugin_80", (String)"bos-ext-ssc", (Object[])new Object[0]));
                return;
            }
            Long priority = (Long)map.get("priority");
            priorityIdSet.add(priority);
        }
        this.getPageCache().put(SELECTED_TASK_INFO, SerializationUtils.toJsonString(myTaskListInfo));
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("task_tasklevel");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(false);
        para.setHasRight(true);
        para.setShowTitle(false);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_MODIFYPRIORITY));
        para.setIsolationOrg(false);
        ListFilterParameter filter = new ListFilterParameter();
        QFilter idFilter = new QFilter("id", "in", priorityIdSet);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        filter.setFilter(idFilter.and(enableFilter));
        para.setListFilterParameter(filter);
        this.getView().showForm((FormShowParameter)para);
    }

    private void modifyPriorityAction(ListSelectedRowCollection selRowCollection) {
        ListSelectedRow returnData = selRowCollection.get(0);
        Long taskLevelId = (Long)returnData.getPrimaryKeyValue();
        TaskModifyPriority taskModifyPriority = new TaskModifyPriority();
        List taskListInfo = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(SELECTED_TASK_INFO), Map.class);
        taskModifyPriority.modifyPriorityNew(taskListInfo, taskLevelId, this.getView(), "1");
        this.refreshBillListAp(true);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (ACTION_BILLHANDLING1.equalsIgnoreCase(actionId)) {
            this.refreshBillListAp(true);
            return;
        }
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (ACTION_ASKTASK.equalsIgnoreCase(actionId)) {
            this.askTaskAction((Map)returnData);
        } else if (ACTION_MODIFYPRIORITY.equalsIgnoreCase(actionId)) {
            this.modifyPriorityAction((ListSelectedRowCollection)returnData);
        } else if (ACTION_REPENDING.equals(actionId)) {
            this.pauseActionNew((Map)returnData);
        } else if (ACTION_PASS.equals(actionId)) {
            this.passAction((Map)returnData);
        } else if ("bd_nopass".equals(actionId)) {
            this.noPassAction((Map)returnData);
        } else if (ACTION_REWITHDRAWAL.equalsIgnoreCase(actionId)) {
            this.withDrawalDialogAction((Map)returnData);
        } else if (ACTION_DECISIONITEMDIALOG.equalsIgnoreCase(actionId)) {
            this.decisionItemDialogAction((Map)returnData);
        } else if (ACTION_BATCHAUDIT.equalsIgnoreCase(actionId)) {
            this.batchProcessedAction((Map)returnData);
        } else if (ACTION_QC_REPENDING.equals(actionId)) {
            QualityApprovalPendingHelper.qualityPauseAction(this.getView(), (Map)returnData);
            this.refreshBillListAp(true);
        } else if ("showCirculationPage".equalsIgnoreCase(e.getActionId())) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u4f20\u9605\u81f3%s\u540d\u8054\u7cfb\u4eba\u3002", (String)"TaskCirculationPlugin_6", (String)"bos-ext-ssc", (Object[])new Object[0]), e.getReturnData()));
        }
    }

    private Map<Long, String> buildTypeMap() {
        DynamicObject[] billTypeDyObjs = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"bindbill.number", null);
        HashMap<Long, String> billTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject billType : billTypeDyObjs) {
            long billTypeID = billType.getLong("id");
            String billTypeNum = billType.getString("bindbill.number");
            if (kd.bos.util.StringUtils.isEmpty((String)billTypeNum)) continue;
            billTypeMap.put(billTypeID, billTypeNum);
        }
        return billTypeMap;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    private List<Long> getSelectedRowIds() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> selectedRowIds = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long selectedRowId = Long.valueOf(listSelectedRow.getPrimaryKeyValue() + "");
            selectedRowIds.add(selectedRowId);
        }
        return selectedRowIds;
    }

    private void openDecisionItemDialog(IFormView view, String operationKey, List<Long> taskIds, List<Object> selectRows, List<Object> selectWithDrawals, String opinion, String innermsg) {
        ListShowParameter para = new ListShowParameter();
        para.setFormId(FORM_APPROVALDECISIONITEMRELATION);
        para.setMultiSelect(false);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.getOpenStyle().setTargetKey("tabap");
        para.setHasRight(true);
        List<Long> relationIds = TaskApprevalPluginUtil.getDecisionItemId(operationKey, taskIds);
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        if (!CollectionUtils.isEmpty(relationIds)) {
            ListFilterParameter filter = new ListFilterParameter();
            filter.setFilter(new QFilter("id", "in", relationIds));
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_decisionitem", (Long)billInfo.get("sscid").get(0));
            filter.setFilter(baseDataFilter);
            para.setListFilterParameter(filter);
            if (CollectionUtils.isEmpty(selectRows)) {
                para.setSelectedRow((Object)relationIds.get(0));
            } else {
                para.setSelectedRow(selectRows.get(0));
            }
        }
        if ("bd_nopass".equalsIgnoreCase(operationKey) && !CollectionUtils.isEmpty(selectRows)) {
            para.setSelectedRows(selectRows.toArray());
        }
        para.setCustomParam("taskids", taskIds);
        para.setCustomParam("operationkey", (Object)operationKey);
        para.setCustomParam("withdrawalids", selectWithDrawals);
        para.setCustomParam("opinion", (Object)opinion);
        para.setCustomParam("innermsg", (Object)innermsg);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_DECISIONITEMDIALOG);
        para.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)para);
    }

    private void decisionItemDialogAction(Map<String, Object> dataMap) {
        String nodeItemId;
        List decisionItemIds = (List)dataMap.get("decisionitemids");
        List withdrawalids = (List)dataMap.get("withdrawalids");
        List taskids = (List)dataMap.get("taskids");
        String operationkey = (String)dataMap.get("operationkey");
        String opinion = dataMap.get("opinion") == null ? null : dataMap.get("opinion").toString();
        String innermsg = dataMap.get("innermsg") == null ? null : dataMap.get("innermsg").toString();
        String string = nodeItemId = dataMap.get("nodeItemId") == null ? null : dataMap.get("nodeItemId").toString();
        if ("bd_nopass".equalsIgnoreCase(operationkey)) {
            this.openWithDrawalDialog(this.getView(), operationkey, taskids, decisionItemIds, withdrawalids, opinion, innermsg, nodeItemId);
        }
    }

    public void openWithDrawalDialog(IFormView view, String operationKey, List<Long> taskIds, List<Object> decisionItemIds, List<Object> withdrawalids, String opinion, String innermsg, String nodeItemId) {
        ListShowParameter para = new ListShowParameter();
        para.setFormId(FORM_APPROVALWITHDRAWAL);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.getOpenStyle().setTargetKey("tabap");
        para.setHasRight(true);
        Map<String, List<Long>> billInfo = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        List<Long> billTypeList = billInfo.get("billtype");
        List<Long> taskTypeList = billInfo.get("tasktypeid");
        if (billTypeList == null || billTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5355\u6b64\u4efb\u52a1\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"MytaskListPlugin_46", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (taskTypeList == null || taskTypeList.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u6279\u9000\u539f\u56e0\u5217\u8868\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5355\u6b64\u4efb\u52a1\u7684\u4efb\u52a1\u7c7b\u578b\u3002", (String)"MytaskListPlugin_47", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return;
        }
        if (withdrawalids != null && withdrawalids.size() > 0) {
            para.setSelectedRows(withdrawalids.toArray());
        }
        WithdrawalSelectorUtil withdrawalSelector = new WithdrawalSelectorUtil();
        Set<Long> idSet = withdrawalSelector.getWithdrawalIdBybilltypeAndTasktype(billTypeList.get(0), taskTypeList.get(0));
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", idSet));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_withdrawal", (Long)billInfo.get("sscid").get(0));
        filter.setFilter(baseDataFilter);
        para.setListFilterParameter(filter);
        para.setCustomParam("opinion", (Object)opinion);
        para.setCustomParam("innermsg", (Object)innermsg);
        para.setCustomParam("operationkey", (Object)operationKey);
        para.setCustomParam("taskids", taskIds);
        para.setCustomParam("decisionitemids", decisionItemIds);
        para.setCustomParam("nodeItemId", (Object)nodeItemId);
        para.setCustomParam("bf", (Object)"task_task");
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_REWITHDRAWAL));
        view.showForm((FormShowParameter)para);
    }

    private void withDrawalDialogAction(Map<String, Object> dataMap) {
        String nodeItemId;
        String btnKey = dataMap.get("btnkey") == null ? null : dataMap.get("btnkey").toString();
        List taskids = (List)dataMap.get("taskids");
        List decisionItemIds = (List)dataMap.get("decisionitemids");
        List withdrawalids = (List)dataMap.get("withdrawalids");
        String opinion = dataMap.get("opinion") == null ? null : dataMap.get("opinion").toString();
        String innermsg = dataMap.get("innermsg") == null ? null : dataMap.get("innermsg").toString();
        String string = nodeItemId = dataMap.get("nodeItemId") == null ? null : dataMap.get("nodeItemId").toString();
        if ("btnup".equalsIgnoreCase(btnKey)) {
            this.openDecisionItemDialog(this.getView(), "bd_nopass", taskids, decisionItemIds, withdrawalids, opinion, innermsg);
        } else if ("btndown".equalsIgnoreCase(btnKey)) {
            this.openOpinionsAndInnerMsg4Repulse("bd_nopass", decisionItemIds, taskids, withdrawalids, opinion, innermsg, nodeItemId);
        } else {
            this.saveUnPassResion(withdrawalids, (Long)taskids.get(0));
        }
    }

    private void saveUnPassResion(List<Object> withdrawalids, Long taskid) {
        if (withdrawalids.size() > 0) {
            WithdrawalSelectorUtil utils = new WithdrawalSelectorUtil();
            ArrayList<Long> pkList = new ArrayList<Long>(10);
            for (Object item : withdrawalids) {
                pkList.add((Long)item);
            }
            try (TXHandle th = TX.requiresNew();){
                try {
                    utils.deleteTaskWithdrawalUnpassById(taskid);
                    utils.saveTaskWithdrawalUnpass(pkList, taskid);
                    utils.saveTaskUnpass(pkList, taskid);
                }
                catch (Exception excption) {
                    th.markRollback();
                }
            }
        }
    }

    private void batchProcessing(String opKey, String opinion, String innerMsg, List<Long> pkIds, List<Long> taskIds, List<Object> decisionItemIds, List<Object> withdrawalIds) {
        FormShowParameter showParameter = this.getBatchForm(opKey, opinion, innerMsg, pkIds, taskIds, decisionItemIds, withdrawalIds);
        this.getView().showForm(showParameter);
    }

    private void batchProcessedAction(Map<String, Object> params) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6279\u5b8c\u6210", (String)"MytaskListPlugin_50", (String)"bos-ext-ssc", (Object[])new Object[0]));
        this.refreshBillListAp(true);
    }

    private FormShowParameter getBatchForm(String opKey, String opinion, String innerMsg, List<Long> pkIds, List<Long> taskIds, List<Object> decisionItemIds, List<Object> withdrawalIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_approval_progress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("opkey", opKey);
        showParameter.getCustomParams().put("opinion", opinion);
        showParameter.getCustomParams().put("innerMsg", innerMsg);
        showParameter.getCustomParams().put("pkIds", SerializationUtils.toJsonString(pkIds));
        showParameter.getCustomParams().put("taskIds", SerializationUtils.toJsonString(taskIds));
        showParameter.getCustomParams().put("decisionitemids", SerializationUtils.toJsonString(decisionItemIds));
        showParameter.getCustomParams().put("withdrawalids", SerializationUtils.toJsonString(withdrawalIds));
        showParameter.getCustomParams().put("batchcount", 20);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_BATCHAUDIT);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    private boolean isBatchProcessing(List<Long> pkIds, List<Long> taskIds) {
        return pkIds != null && pkIds.size() >= 20 || taskIds != null && taskIds.size() >= 20;
    }

    private String getTaskEntityFromCache() {
        String poolType = this.getPageCache().get("pooltype");
        return this.getTaskEntityFromCache(poolType);
    }

    private String getTaskEntityFromCache(String poolType) {
        return TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType) ? "task_taskhistory" : "task_task";
    }

    private void refreshBillListAp(boolean isClearSelRows) {
        ((IListView)this.getView()).refresh();
        if (isClearSelRows) {
            BillList list = (BillList)this.getControl("billlistap");
            list.clearSelection();
        }
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("shownodeid");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("nodeid", customParam);
        this.invokeParentOperation("refreshtree", operateOption);
    }

    public int getTaskAndApprevalNew(String key, List<Long> pkIds, String opinion, String innerMsg, List<Object> decisionItemIds, String withdrawal, List<Object> withdrawalIdList, IFormView formView) {
        int totalSuccessCount = 0;
        for (Long taskId : pkIds) {
            String operation = "";
            if (OPERATIONKEY_PASS.equals(key)) {
                operation = "1";
            } else if ("bd_nopass".equals(key)) {
                operation = "2";
            }
            String decisionItem = "";
            String action = formView.getPageCache().get("action");
            if ("repulse".equals(action)) {
                decisionItem = "2";
            } else if ("repulse_both".equals(action)) {
                decisionItem = "4";
            }
            Long curDecisionItem = null;
            if (!CollectionUtils.isEmpty(decisionItemIds)) {
                curDecisionItem = (Long)decisionItemIds.get(0);
            }
            String withdrawalId = "";
            if (!CollectionUtils.isEmpty(withdrawalIdList)) {
                withdrawalId = SerializationUtils.toJsonString(withdrawalIdList);
            }
            String nodeItemId = this.getPageCache().get("nodeItemId");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("taskId", taskId);
            paramMap.put("operation", operation);
            long currUserId = RequestContext.get().getCurrUserId();
            paramMap.put("currentPersonId", currUserId);
            paramMap.put("decisionItem", decisionItem);
            paramMap.put("curDecisionItem", curDecisionItem);
            paramMap.put("opinion", opinion);
            paramMap.put("withdrawal", withdrawal);
            if (kd.bos.util.StringUtils.isNotEmpty((String)withdrawalId)) {
                paramMap.put("withdrawalIdList", withdrawalIdList);
            }
            paramMap.put("innerMsg", innerMsg);
            paramMap.put("nodeItemId", nodeItemId);
            paramMap.put("origin", "2");
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskApproveSubmit", (Object[])new Object[]{paramMap});
            String success = (String)resultMap.get("success");
            if ("false".equals(success)) {
                String msg = (String)resultMap.get("msg");
                String msgType = (String)resultMap.get("msgType");
                if (kd.bos.util.StringUtils.isEmpty((String)msgType) || MsgTypeEnum.WARN.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.ERROR.getValue().equals(msgType)) {
                    this.getView().showTipNotification(msg);
                } else if (MsgTypeEnum.POP.getValue().equals(msgType)) {
                    String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519", (String)"TaskApproveFormPlugin_14", (String)"bos-ext-ssc", (Object[])new Object[0]);
                    this.getView().showMessage(errorInfo, msg, MessageTypes.Default);
                }
                return totalSuccessCount;
            }
            if (!"true".equals(success)) continue;
            this.afterApproveSuccess(taskId, operation, withdrawalId);
            ++totalSuccessCount;
        }
        return totalSuccessCount;
    }

    private void afterApproveSuccess(Long taskId, String operation, String withdrawalId) {
        DynamicObject taskHistoryDo = TaskApproveSuccessHelper.getTaskHistoryDo(taskId);
        TaskApproveSuccessHelper.saveArtiCheckPointInfo(taskId, null, operation);
        HashMap<String, String> creditMap = new HashMap<String, String>();
        creditMap.put("withdrawalids", withdrawalId);
        String operationKey = "";
        if ("1".equals(operation)) {
            operationKey = OPERATIONKEY_PASS;
        } else if ("2".equals(operation)) {
            operationKey = "bd_nopass";
        }
        TaskApproveHelper.creditSetWfVariable(operationKey, creditMap, taskId);
        TaskApproveSuccessHelper.creditSubScore(operation, taskHistoryDo, creditMap);
    }

    private void invokeParentOperation(String operateKey, OperateOption operateOption) {
        if (kd.bos.util.StringUtils.isBlank((String)operateKey)) {
            return;
        }
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        String appId = parentView.getServiceAppId(parentView.getPageId());
        if (parentView != null) {
            Map resultMap;
            List actionResult;
            HashMap<String, String> variable = new HashMap<String, String>();
            variable.put("ishasright", String.valueOf(true));
            if (operateOption != null) {
                Map operateOptionMap = operateOption.getVariables();
                variable.putAll(operateOptionMap);
            }
            if (!CollectionUtils.isEmpty((Collection)(actionResult = (List)(resultMap = (Map)DispatchServiceHelper.invokeBOSService((String)appId, (String)FormService.class.getSimpleName(), (String)"invokeOperationFromService", (Object[])new Object[]{parentPageId, operateKey, variable})).get("actionResult")))) {
                HashMap<String, Object> arg = new HashMap<String, Object>(3);
                arg.put("pageId", parentPageId);
                arg.put("actions", actionResult);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg);
            }
        }
    }
}

