/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.bizrule;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;

public class BillSaveOrSubmitControlOpAction
extends AbstractOpBizRuleAction {
    private static final String Interaction_Sponore = "kd.bos.ext.data.idi.bizrule.BillSaveOrSubmitControlOpAction";
    private static final Log logger = LogFactory.getLog(BillSaveOrSubmitControlOpAction.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new IDIControlValidator());
    }

    static class IDIControlValidator
    extends AbstractValidator {
        IDIControlValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            logger.info("\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u51c6\u5907\u6821\u9a8c\u5355\u636e\uff0c\u5355\u636e\u6761\u6570" + dataEntities.length);
            if (dataEntities != null && dataEntities.length > 0) {
                List dataEntityList = Arrays.asList(dataEntities).stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                List result = null;
                try {
                    result = (List)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"batchBillControl", (Object[])new Object[]{dataEntityList, new HashMap(1)});
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        this.valid(dataEntity);
                    }
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == dataEntities.length) {
                    for (int index = 0; index < result.size(); ++index) {
                        String resultStr = (String)result.get(index);
                        ExtendedDataEntity dataEntity = dataEntities[index];
                        if (StringUtils.isBlank((CharSequence)resultStr)) continue;
                        Map map = (Map)JSON.parseObject((String)resultStr, Map.class);
                        this.valid(dataEntity, map);
                    }
                }
            }
            logger.info("\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u6821\u9a8c\u5b8c\u6210");
        }

        private void valid(ExtendedDataEntity extendedDataEntity) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Map<?, ?> map = this.mserviceCall(dataEntity);
            this.valid(extendedDataEntity, map);
        }

        private void valid(ExtendedDataEntity extendedDataEntity, Map<?, ?> map) {
            String controlStatus = (String)map.get("controlStatus");
            String status = (String)map.get("status");
            String title = (String)map.get("title");
            List content = (List)map.get("content");
            if ("success".equals(status) && !this.isEmpty(title, content)) {
                String contentMsg;
                if ("force".equals(controlStatus)) {
                    contentMsg = this.parseToString(content, true, 4);
                    contentMsg = title + ":\r\n" + contentMsg + "\r\n";
                    this.addMessage(extendedDataEntity, title, contentMsg, ErrorLevel.Error);
                }
                if ("confirm".equals(controlStatus)) {
                    contentMsg = this.parseToString(content, false);
                    boolean yes = this.showInteractionForm(title, content);
                    if (!yes) {
                        contentMsg = contentMsg + "\r\n";
                        this.addMessage(extendedDataEntity, title, contentMsg, ErrorLevel.Warning);
                        ValidateResultCollection all = this.getValidateContext().getValidateResults();
                        ValidateResult current = this.getValidateResult();
                        List errors = all.getValidateErrors();
                        if (!errors.contains(current)) {
                            all.addValidateError(this.getOperationName(), current);
                            for (int index = errors.size() - 2; index >= 0; --index) {
                                ValidateResult preObj = (ValidateResult)errors.get(index);
                                errors.set(index + 1, preObj);
                            }
                            errors.set(0, current);
                        }
                    }
                }
            }
        }

        private String parseToString(List<String> content, boolean wrap, int indent) {
            StringBuilder blank = new StringBuilder();
            String spit = "";
            if (wrap) {
                for (int i = 0; i < indent; ++i) {
                    blank.append(" ");
                }
                spit = "\r\n";
            }
            StringBuilder sb = new StringBuilder();
            String prefixed = blank.toString();
            for (int i = 0; i < content.size(); ++i) {
                String msgLine = content.get(i);
                sb.append(prefixed);
                sb.append(msgLine);
                sb.append(spit);
            }
            return sb.toString();
        }

        private String parseToString(List<String> content, boolean wrap) {
            return this.parseToString(content, wrap, 0);
        }

        private boolean isEmpty(String title, List<?> content) {
            return title == null || "".equals(title) || content == null || content.isEmpty();
        }

        private Map<?, ?> mserviceCall(DynamicObject dataEntity) {
            String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"billControl", (Object[])new Object[]{dataEntity});
            return (Map)JSON.parseObject((String)result, Map.class);
        }

        private boolean showInteractionForm(String title, List<String> content) {
            String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
            InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
            if (confirmResult.getResults().containsKey(BillSaveOrSubmitControlOpAction.Interaction_Sponore)) {
                String newFieldValue = (String)confirmResult.getResults().get(BillSaveOrSubmitControlOpAction.Interaction_Sponore);
                return !StringUtils.isBlank((CharSequence)newFieldValue);
            }
            return false;
        }
    }
}

