/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class AnalysisAssistantFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(AnalysisAssistantFormPlugin.class);
    private static final String CONTROL_ASSISTANTCC = "customcontrolap_sce";
    private static final String EVENT_ANALYSIS = "analysis";
    private static final String KEY_TAB_SELECTED = "assistant_tab_selected";
    private static final String EVENT_QINGANALYSISDATA = "qinganalysisdata";
    private static final String EVENT_LOADCOSMICMESSAGE = "loadcosmicmessage";
    private static final IAppCache IBA = AppCache.get((String)"iba");

    public void initialize() {
        Tab tab;
        AnalysisAssistantFormParam formParam = this.parseFormParam();
        if (StringUtils.isNotEmpty((CharSequence)formParam.tabParentKey) && (tab = (Tab)this.getControl(formParam.tabParentKey)) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        if (CONTROL_ASSISTANTCC.equals(controlKey)) {
            this.processAssistantEvent(e);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        AnalysisAssistantFormParam formParam = this.parseFormParam();
        if (evt.getTabKey().equals(formParam.tabKey)) {
            this.processAssistantEvent(new CustomEventArgs((Object)this, CONTROL_ASSISTANTCC, EVENT_ANALYSIS, ""));
        }
    }

    private void processAssistantEvent(CustomEventArgs eventArgs) {
        String eventName = eventArgs.getEventName();
        if (eventName.equals(EVENT_ANALYSIS)) {
            boolean tabSelected = "true".equals(this.getPageCache().get(KEY_TAB_SELECTED));
            if (!tabSelected) {
                CustomControl customControl = (CustomControl)this.getControl(CONTROL_ASSISTANTCC);
                if (customControl != null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("version", System.currentTimeMillis());
                    data.put("analysisResult", this.execAnalysisSchema());
                    customControl.setData(data);
                }
                this.getPageCache().put(KEY_TAB_SELECTED, "true");
            }
        } else if (EVENT_QINGANALYSISDATA.equals(eventName)) {
            this.getAssistantData(eventArgs.getEventArgs());
        } else if (EVENT_LOADCOSMICMESSAGE.equals(eventName)) {
            this.loadCosmicMessage(eventArgs.getEventArgs());
        }
    }

    private void getAssistantData(String requestJson) {
        try {
            String serviceResult = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"iba", (String)"IBAAssistantService", (String)"cosmicChat", (Object[])new Object[]{requestJson});
            logger.info("[AnalysisAssistantFormPlugin_getAssistantData_result]" + serviceResult);
            Map map = (Map)SerializationUtils.fromJsonString((String)serviceResult, Map.class);
            String result = (String)map.get("result");
            if ("SUCCESS".equals(result)) {
                Map dataResult = (Map)map.get("data");
                if (dataResult != null && dataResult.get("sessionId") != null && dataResult.get("chartId") != null && dataResult.get("schemaId") != null) {
                    String sessionId = (String)dataResult.get("sessionId");
                    String chartId = (String)dataResult.get("chartId");
                    String schemaId = (String)dataResult.get("schemaId");
                    IPageCache pageCache = this.getPageCache();
                    pageCache.put("schemaId:" + schemaId + "||chartId:" + chartId, sessionId);
                }
            } else {
                Map dataResult = (Map)map.get("data");
                HashMap<String, String> cosmicMap = new HashMap<String, String>(4);
                cosmicMap.put("data", map.get("errorMsg") == null ? "" : map.get("errorMsg").toString());
                cosmicMap.put("code", "ERROR");
                if (dataResult != null) {
                    cosmicMap.put("chartId", dataResult.get("chartId") == null ? "" : (String)dataResult.get("chartId"));
                    cosmicMap.put("schemaId", dataResult.get("schemaId") == null ? "" : (String)dataResult.get("schemaId"));
                }
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(CONTROL_ASSISTANTCC, "cosmicmessage", new Object[]{cosmicMap});
            }
        }
        catch (Exception e) {
            logger.error("getAssistantData error", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void loadCosmicMessage(String requestJson) {
        JSONArray data = JSON.parseArray((String)requestJson);
        if (data != null && !data.isEmpty()) {
            ArrayList resultList = new ArrayList(data.size());
            IPageCache pageCache = this.getPageCache();
            for (Object datum : data) {
                HashMap<String, String> cosmicMap;
                JSONObject object = (JSONObject)datum;
                String schemaId = object.getString("schemaId");
                String chartId = object.getString("chartId");
                String sessionId = pageCache.get("schemaId:" + schemaId + "||chartId:" + chartId);
                logger.info("[AnalysisAssistantFormPlugin_getAssistantData]: sessionId: " + sessionId + " chartId: " + chartId + " schemaId: " + schemaId);
                if (!StringUtils.isNotBlank((CharSequence)sessionId)) continue;
                String cosmicMessage = (String)IBA.get("Cosmic_" + sessionId, String.class);
                String streamMessage = (String)IBA.get("Stream_" + sessionId, String.class);
                if (StringUtils.isNotBlank((CharSequence)cosmicMessage)) {
                    cosmicMap = new HashMap<String, String>(6);
                    cosmicMap.put("chartId", chartId);
                    cosmicMap.put("schemaId", schemaId);
                    cosmicMap.put("code", cosmicMessage.startsWith("error\uff1a") ? "ERROR" : "SUCCESS");
                    cosmicMap.put("data", cosmicMessage);
                    cosmicMap.put("isDone", "true");
                    resultList.add(cosmicMap);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)streamMessage)) continue;
                cosmicMap = new HashMap(6);
                cosmicMap.put("chartId", chartId);
                cosmicMap.put("schemaId", schemaId);
                cosmicMap.put("code", "SUCCESS");
                cosmicMap.put("data", streamMessage);
                cosmicMap.put("isDone", "false");
                resultList.add(cosmicMap);
            }
            logger.info("[AnalysisAssistantFormPlugin_loadCosmicMessage_result]:" + resultList);
            if (!resultList.isEmpty()) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(CONTROL_ASSISTANTCC, EVENT_LOADCOSMICMESSAGE, new Object[]{resultList});
            }
        }
    }

    private Map execAnalysisSchema() {
        HashMap<String, String> result = new HashMap<String, String>(8);
        try {
            AnalysisAssistantFormParam formParam = this.parseFormParam();
            if (StringUtils.isEmpty((CharSequence)formParam.entityNumber) || StringUtils.isEmpty((CharSequence)formParam.billId)) {
                return null;
            }
            HashMap<String, String> request = new HashMap<String, String>(8);
            request.put("srcEntityNumber", formParam.entityNumber);
            request.put("billId", formParam.billId);
            request.put("viewType", "1");
            String requestJson = SerializationUtils.toJsonString(request);
            List<Object> schemaNums = new ArrayList(8);
            if (StringUtils.isNotEmpty((CharSequence)formParam.schemaNumbers)) {
                schemaNums = Arrays.asList(formParam.schemaNumbers.split(","));
            }
            String schemaNumJson = SerializationUtils.toJsonString(schemaNums);
            String serviceResult = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"iba", (String)"IBAAssistantService", (String)"executeSpecifiedSchema", (Object[])new Object[]{requestJson, schemaNumJson});
            return (Map)SerializationUtils.fromJsonString((String)serviceResult, Map.class);
        }
        catch (Exception e) {
            logger.error("execAnalysisSchema error", (Throwable)e);
            result.put("result", "NOSCHEMA");
            return result;
        }
    }

    private AnalysisAssistantFormParam parseFormParam() {
        IPageCache pageCache = this.getPageCache();
        AnalysisAssistantFormParam formParam = new AnalysisAssistantFormParam();
        formParam.tabParentKey = pageCache.get("schemetab");
        formParam.tabKey = pageCache.get("schemetabSceAnal");
        formParam.entityNumber = pageCache.get("entitynumber");
        formParam.billId = pageCache.get("businesskey");
        formParam.schemaNumbers = pageCache.get("scAnalSchemeNumber");
        return formParam;
    }

    private static class AnalysisAssistantFormParam {
        private String tabParentKey;
        private String tabKey;
        private String entityNumber;
        private String billId;
        private String schemaNumbers;

        private AnalysisAssistantFormParam() {
        }
    }
}

